/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.util.Set;
import mondrian.olap.Util;
import mondrian.spi.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlPattern {
    private final String sql;
    private final String triggerSql;
    private final Set<Dialect.DatabaseProduct> databaseProducts;

    public SqlPattern(Set<Dialect.DatabaseProduct> databaseProducts, String sql, int startsWithLen) {
        this(databaseProducts, sql, sql.substring(0, startsWithLen));
    }

    public SqlPattern(Dialect.DatabaseProduct databaseProduct, String sql, int startsWithLen) {
        this(databaseProduct, sql, sql.substring(0, startsWithLen));
    }

    public SqlPattern(Dialect.DatabaseProduct databaseProduct, String sql, String triggerSql) {
        this((Set<Dialect.DatabaseProduct>)Util.enumSetOf((Enum)databaseProduct, (Enum[])new Dialect.DatabaseProduct[0]), sql, triggerSql);
    }

    public SqlPattern(Set<Dialect.DatabaseProduct> databaseProducts, String sql, String triggerSql) {
        this.databaseProducts = databaseProducts;
        this.sql = sql;
        this.triggerSql = triggerSql != null ? triggerSql : sql;
    }

    public static SqlPattern getPattern(Dialect.DatabaseProduct d, SqlPattern[] patterns) {
        if (d == Dialect.DatabaseProduct.UNKNOWN) {
            return null;
        }
        for (SqlPattern pattern : patterns) {
            if (!pattern.hasDatabaseProduct(d)) continue;
            return pattern;
        }
        return null;
    }

    public boolean hasDatabaseProduct(Dialect.DatabaseProduct databaseProduct) {
        return this.databaseProducts.contains((Object)databaseProduct);
    }

    public String getSql() {
        return this.sql;
    }

    public String getTriggerSql() {
        return this.triggerSql;
    }
}

