/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.netbeans.core.windows.view.ui.slides.CommandManager;
import org.netbeans.core.windows.view.ui.slides.SlideBarController;
import org.netbeans.core.windows.view.ui.slides.SlideGestureRecognizer;
import org.netbeans.core.windows.view.ui.slides.TabbedSlideAdapter;
import org.netbeans.core.windows.view.ui.tabcontrol.TabbedAdapter;
import org.netbeans.swing.tabcontrol.SlideBarDataModel;
import org.netbeans.swing.tabcontrol.SlidingButton;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbed;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;
import org.openide.windows.TopComponent;

public final class SlideBar
extends Box
implements ComplexListDataListener,
SlideBarController,
Tabbed.Accessor,
WinsysInfoForTabbed,
ChangeListener {
    public static final String COMMAND_SLIDE_IN = "slideIn";
    public static final String COMMAND_SLIDE_OUT = "slideOut";
    public static final String COMMAND_SLIDE_RESIZE = "slideResize";
    public static final String COMMAND_POPUP_REQUEST = "popup";
    public static final String COMMAND_DISABLE_AUTO_HIDE = "disableAutoHide";
    public static final String COMMAND_MAXIMIZE = "slideMaximize";
    private final TabbedSlideAdapter tabbed;
    private final SlideBarDataModel dataModel;
    private final SingleSelectionModel selModel;
    private SlideGestureRecognizer gestureRecognizer;
    private List<SlidingButton> buttons;
    private CommandManager commandMgr;
    private boolean active = false;

    public SlideBar(TabbedSlideAdapter tabbedSlideAdapter, SlideBarDataModel slideBarDataModel, SingleSelectionModel singleSelectionModel) {
        super(slideBarDataModel.getOrientation() == 3 ? 0 : 1);
        this.tabbed = tabbedSlideAdapter;
        this.dataModel = slideBarDataModel;
        this.selModel = singleSelectionModel;
        this.commandMgr = new CommandManager(this);
        this.gestureRecognizer = new SlideGestureRecognizer(this, this.commandMgr.getResizer());
        this.buttons = new ArrayList<SlidingButton>(5);
        this.syncWithModel();
        slideBarDataModel.addComplexListDataListener((ComplexListDataListener)this);
        singleSelectionModel.addChangeListener(this);
    }

    public SlideBarDataModel getModel() {
        return this.dataModel;
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selModel;
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        int n = listDataEvent.getIndex0();
        int n2 = listDataEvent.getIndex1();
        SlideBarDataModel slideBarDataModel = (SlideBarDataModel)listDataEvent.getSource();
        for (int i = n; i <= n2; ++i) {
            SlidingButton slidingButton = new SlidingButton(slideBarDataModel.getTab(i), slideBarDataModel.getOrientation());
            this.gestureRecognizer.attachButton((AbstractButton)slidingButton);
            this.buttons.add(i, slidingButton);
            this.add((Component)slidingButton, i * 2);
            this.add(this.createStrut(), i * 2 + 1);
            this.revalidate();
        }
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        int n = listDataEvent.getIndex0();
        int n2 = listDataEvent.getIndex1();
        SlideBarDataModel slideBarDataModel = (SlideBarDataModel)listDataEvent.getSource();
        Object var5_5 = null;
        for (int i = n2; i >= n; --i) {
            this.gestureRecognizer.detachButton((AbstractButton)this.buttons.get(i));
            this.buttons.remove(i);
            this.remove(i * 2 + 1);
            this.remove(i * 2);
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.syncWithModel();
    }

    public void indicesAdded(ComplexListDataEvent complexListDataEvent) {
        this.syncWithModel();
    }

    public void indicesChanged(ComplexListDataEvent complexListDataEvent) {
        this.syncWithModel();
    }

    public void indicesRemoved(ComplexListDataEvent complexListDataEvent) {
        this.syncWithModel();
    }

    public int tabForCoordinate(int n, int n2) {
        Rectangle rectangle = new Rectangle();
        int n3 = 0;
        Iterator<SlidingButton> iterator = this.buttons.iterator();
        while (iterator.hasNext()) {
            ((Component)iterator.next()).getBounds(rectangle);
            if (rectangle.contains(n, n2)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    int nextTabForCoordinate(int n, int n2) {
        Rectangle rectangle = new Rectangle();
        int n3 = 0;
        for (Component component : this.buttons) {
            component.getBounds(rectangle);
            if (this.dataModel.getOrientation() == 3) {
                if (rectangle.x + rectangle.width / 2 < n) {
                    ++n3;
                    continue;
                }
            } else if (rectangle.y + rectangle.height / 2 < n2) {
                ++n3;
                continue;
            }
            return n3;
        }
        return n3;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.selModel.getSelectedIndex();
        this.tabbed.postSelectionEvent();
        if (this.isDisplayable() && this.isVisible()) {
            if (n != -1) {
                this.commandMgr.slideIn(n);
            } else {
                this.commandMgr.slideOut(true, true);
            }
        }
    }

    public void userToggledAutoHide(int n, boolean bl) {
        this.commandMgr.slideIntoDesktop(n, true);
    }

    public void userTriggeredPopup(MouseEvent mouseEvent, Component component) {
        int n = this.getButtonIndex(component);
        this.commandMgr.showPopup(mouseEvent, n);
    }

    private SlidingButton buttonFor(TopComponent topComponent) {
        TabData tabData;
        int n = 0;
        Iterator iterator = this.dataModel.getTabs().iterator();
        while (iterator.hasNext() && (tabData = (TabData)iterator.next()).getComponent() != topComponent) {
            if (!iterator.hasNext()) {
                n = -1;
                continue;
            }
            ++n;
        }
        if (n >= 0 && n < this.dataModel.size()) {
            return this.getButton(n);
        }
        return null;
    }

    public void setBlinking(TopComponent topComponent, boolean bl) {
        SlidingButton slidingButton = this.buttonFor(topComponent);
        if (slidingButton != null) {
            slidingButton.setBlinking(bl);
        }
    }

    public void userClickedSlidingButton(Component component) {
        int n = this.getButtonIndex(component);
        SlidingButton slidingButton = this.buttons.get(n);
        slidingButton.setBlinking(false);
        if (n != this.selModel.getSelectedIndex() || !this.isActive()) {
            TopComponent topComponent = (TopComponent)this.dataModel.getTab(n).getComponent();
            if (topComponent != null) {
                topComponent.requestActive();
            }
            slidingButton.setSelected(true);
        } else {
            this.selModel.setSelectedIndex(-1);
        }
    }

    public boolean userTriggeredAutoSlideIn(Component component) {
        int n = this.getButtonIndex(component);
        if (n < 0) {
            return false;
        }
        SlidingButton slidingButton = this.buttons.get(n);
        slidingButton.setBlinking(false);
        TopComponent topComponent = (TopComponent)this.dataModel.getTab(n).getComponent();
        if (topComponent == null) {
            return false;
        }
        topComponent.requestVisible();
        return true;
    }

    public void userTriggeredAutoSlideOut() {
        this.selModel.setSelectedIndex(-1);
    }

    public Rectangle getTabBounds(int n) {
        SlidingButton slidingButton = this.getButton(n);
        if (slidingButton == null) {
            return null;
        }
        Insets insets = this.getInsets();
        Point point = new Point(insets.left, insets.top);
        Dimension dimension = this.createStrut().getPreferredSize();
        if (this.dataModel.getOrientation() == 3) {
            for (int i = 0; i < n; ++i) {
                point.x += this.getButton((int)i).getPreferredSize().width;
                point.x += dimension.width;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                point.y += this.getButton((int)i).getPreferredSize().height;
                point.y += dimension.height;
            }
        }
        return new Rectangle(point, slidingButton.getPreferredSize());
    }

    public Tabbed getTabbed() {
        return this.tabbed;
    }

    public Object getOrientation(Component component) {
        if (WindowManagerImpl.getInstance().getEditorAreaState() != 0) {
            return TabDisplayer.ORIENTATION_INVISIBLE;
        }
        return TabDisplayer.ORIENTATION_CENTER;
    }

    public boolean inMaximizedMode(Component component) {
        return TabbedAdapter.isInMaximizedMode(component);
    }

    Component getSlidedComp() {
        return this.commandMgr.getSlidedComp();
    }

    void setActive(boolean bl) {
        this.active = bl;
        this.commandMgr.setActive(bl);
    }

    boolean isActive() {
        return this.active;
    }

    boolean isHoveringAllowed() {
        return !this.isActive() || !this.commandMgr.isCompSlided();
    }

    int getButtonIndex(Component component) {
        return this.buttons.indexOf(component);
    }

    SlidingButton getButton(int n) {
        return this.buttons.get(n);
    }

    boolean containsComp(Component component) {
        List list = this.getModel().getTabs();
        TabData tabData2 = null;
        for (TabData tabData2 : list) {
            if (!component.equals(tabData2.getComponent())) continue;
            return true;
        }
        return false;
    }

    private Component createStrut() {
        return this.dataModel.getOrientation() == 3 ? SlideBar.createHorizontalStrut(5) : SlideBar.createVerticalStrut(5);
    }

    private void syncWithModel() {
        assert (SwingUtilities.isEventDispatchThread());
        HashSet<TabData> hashSet = null;
        for (SlidingButton slidingButton : this.buttons) {
            if (slidingButton.isBlinking()) {
                if (hashSet == null) {
                    hashSet = new HashSet<TabData>();
                }
                hashSet.add(slidingButton.getData());
            }
            this.gestureRecognizer.detachButton((AbstractButton)slidingButton);
        }
        this.removeAll();
        this.buttons.clear();
        List list = this.dataModel.getTabs();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SlidingButton slidingButton;
            TabData tabData = (TabData)iterator.next();
            slidingButton = new SlidingButton(tabData, this.dataModel.getOrientation());
            if (hashSet != null && hashSet.contains(tabData)) {
                slidingButton.setBlinking(true);
            }
            this.gestureRecognizer.attachButton((AbstractButton)slidingButton);
            this.buttons.add(slidingButton);
            this.add((Component)slidingButton);
            this.add(this.createStrut());
        }
        this.commandMgr.syncWithModel();
        this.revalidate();
        this.repaint();
    }
}

