/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.loader;

import java.nio.charset.Charset;
import org.netbeans.modules.db.sql.loader.SQLEditorSupport;
import org.netbeans.modules.db.sql.loader.SQLNode;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class SQLDataObject
extends MultiDataObject {
    private Lookup lookup;

    public SQLDataObject(FileObject fileObject, UniFileLoader uniFileLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)uniFileLoader);
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add((Node.Cookie)new SQLEditorSupport(this));
    }

    protected Node createNodeDelegate() {
        return new SQLNode(this);
    }

    public synchronized Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = new ProxyLookup(new Lookup[]{this.getCookieSet().getLookup(), Lookups.singleton((Object)((Object)new FileEncodingQueryImpl()))});
        }
        return this.lookup;
    }

    public boolean isConsole() {
        try {
            return "nbfs".equals(this.getPrimaryFile().getURL().getProtocol());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return false;
        }
    }

    void addCookie(Node.Cookie cookie) {
        this.getCookieSet().add(cookie);
    }

    void removeCookie(Node.Cookie cookie) {
        this.getCookieSet().remove(cookie);
    }

    private final class FileEncodingQueryImpl
    extends FileEncodingQueryImplementation {
        private FileEncodingQueryImpl() {
        }

        public Charset getEncoding(FileObject fileObject) {
            if (SQLDataObject.this.isConsole()) {
                return Charset.forName("UTF-8");
            }
            return null;
        }
    }
}

