/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderList;
import org.openide.util.Enumerations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FolderOrder
implements Comparator<DataObject> {
    private static final WeakHashMap<FileObject, Reference<FolderOrder>> map = new WeakHashMap(101);
    private static final Map<FileObject, Object> knownOrders = Collections.synchronizedMap(new WeakHashMap(50));
    private Map<String, Integer> order;
    private FileObject folder;
    private DataFolder.SortMode sortMode;
    private Object previous;

    private FolderOrder(FileObject fileObject) {
        this.folder = fileObject;
    }

    public void setSortMode(DataFolder.SortMode sortMode) throws IOException {
        this.sortMode = sortMode;
        sortMode.write(this.folder);
    }

    public DataFolder.SortMode getSortMode() {
        if (this.sortMode == null) {
            this.sortMode = DataFolder.SortMode.read(this.folder);
        }
        return this.sortMode;
    }

    public synchronized void setOrder(DataObject[] dataObjectArray) throws IOException {
        if (dataObjectArray != null) {
            this.order = new HashMap<String, Integer>(dataObjectArray.length * 4 / 3 + 1);
            Enumeration enumeration = Enumerations.removeDuplicates((Enumeration)Enumerations.array((Object[])dataObjectArray));
            int n = 0;
            while (enumeration.hasMoreElements()) {
                DataObject dataObject = (DataObject)enumeration.nextElement();
                FileObject fileObject = dataObject.getPrimaryFile();
                if (!this.folder.equals(fileObject.getParent())) continue;
                this.order.put(fileObject.getNameExt(), n++);
            }
        } else {
            this.order = null;
        }
        this.write();
    }

    @Override
    public int compare(DataObject dataObject, DataObject dataObject2) {
        Integer n;
        Integer n2 = this.order == null ? null : this.order.get(dataObject.getPrimaryFile().getNameExt());
        Integer n3 = n = this.order == null ? null : this.order.get(dataObject2.getPrimaryFile().getNameExt());
        if (n2 == null) {
            if (n != null) {
                return 1;
            }
            return this.getSortMode().compare(dataObject, dataObject2);
        }
        if (n == null) {
            return -1;
        }
        if (n2.intValue() == n.intValue()) {
            return 0;
        }
        if (n2 < n) {
            return -1;
        }
        return 1;
    }

    public void write() throws IOException {
        if (this.folder.getAttribute("OpenIDE-Folder-Order") != null) {
            this.folder.setAttribute("OpenIDE-Folder-Order", null);
        }
        if (this.order != null) {
            FileObject[] fileObjectArray = new FileObject[this.order.size()];
            for (Map.Entry<String, Integer> entry : this.order.entrySet()) {
                fileObjectArray[entry.getValue().intValue()] = this.folder.getFileObject(entry.getKey());
            }
            FileUtil.setOrder(Arrays.asList(fileObjectArray));
        }
    }

    private void read() {
        Object object = this.folder.getAttribute("OpenIDE-Folder-Order");
        if (this.previous == null && object == null || this.previous != null && this.previous.equals(object)) {
            return;
        }
        if (object instanceof Object[] && this.previous instanceof Object[] && FolderOrder.compare((Object[])object, (Object[])this.previous)) {
            return;
        }
        this.doRead(object);
        this.previous = object;
        if (this.previous != null) {
            knownOrders.put(this.folder, this.previous);
        }
        FolderList.changedFolderOrder(this.folder);
    }

    private static boolean compare(Object[] objectArray, Object[] objectArray2) {
        Object[] objectArray3;
        if (objectArray == objectArray2) {
            return true;
        }
        int n = Math.min(objectArray.length, objectArray2.length);
        for (int i = 0; i < n; ++i) {
            if (objectArray[i] == objectArray2[i]) continue;
            if (objectArray[i] == null) {
                return false;
            }
            if (objectArray[i].equals(objectArray2[i])) continue;
            if (objectArray[i] instanceof Object[] && objectArray2[i] instanceof Object[]) {
                if (FolderOrder.compare((Object[])objectArray[i], (Object[])objectArray2[i])) continue;
                return false;
            }
            return false;
        }
        Object[] objectArray4 = objectArray3 = objectArray.length > objectArray2.length ? objectArray : objectArray2;
        return !FolderOrder.checkNonNull(objectArray3, n);
    }

    private static boolean checkNonNull(Object[] objectArray, int n) {
        for (int i = n; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            return true;
        }
        return false;
    }

    private void doRead(Object object) {
        if (object == null) {
            this.order = null;
            return;
        }
        if (object instanceof String[][]) {
            String[][] stringArray = (String[][])object;
            if (stringArray.length != 2) {
                this.order = null;
                return;
            }
            String[] stringArray2 = stringArray[0];
            String[] stringArray3 = stringArray[1];
            if (stringArray2 == null || stringArray3 == null || stringArray2.length != stringArray3.length) {
                this.order = null;
                return;
            }
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(stringArray2.length);
            for (int i = 0; i < stringArray2.length; ++i) {
                hashMap.put(stringArray2[i], i);
            }
            this.order = hashMap;
            return;
        }
        if (object instanceof String) {
            String string = (String)object;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                hashMap.put(string2, n);
                ++n;
            }
            this.order = hashMap;
            return;
        }
        this.order = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FolderOrder findFor(FileObject fileObject) {
        FolderOrder folderOrder = null;
        Object object = map;
        synchronized (object) {
            Reference<FolderOrder> reference = map.get(fileObject);
            FolderOrder folderOrder2 = folderOrder = reference == null ? null : reference.get();
            if (folderOrder == null) {
                folderOrder = new FolderOrder(fileObject);
                folderOrder.previous = knownOrders.get(fileObject);
                folderOrder.doRead(folderOrder.previous);
                map.put(fileObject, new SoftReference<FolderOrder>(folderOrder));
            }
        }
        object = folderOrder;
        synchronized (object) {
            folderOrder.read();
            return folderOrder;
        }
    }
}

