/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.io.IOException;
import java.io.Writer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatTokenPositionSupport;

public final class FormatWriter
extends Writer {
    public static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.format");
    public static final boolean debugModify = Boolean.getBoolean("netbeans.debug.editor.format.modify");
    private static final char[] EMPTY_BUFFER = new char[0];
    private ExtFormatter formatter;
    private Document doc;
    private int offset;
    private Writer underWriter;
    private Syntax syntax;
    private boolean indentOnly;
    private char[] buffer;
    private int bufferSize;
    private FormatTokenPositionSupport ftps;
    private int offsetPreScan;
    private boolean firstFlush;
    private ExtTokenItem lastToken;
    private FormatTokenPosition formatStartPosition;
    private FormatTokenPosition textStartPosition;
    private boolean chainModified;
    private boolean restartFormat;
    private boolean lastFlush;
    private int indentShift;
    private boolean simple;
    private boolean reformatting;

    void setReformatting(boolean bl) {
        this.reformatting = bl;
    }

    FormatWriter(ExtFormatter extFormatter, Document document, int n, Writer writer, boolean bl) {
        Object object;
        block18: {
            Object object2;
            Class clazz;
            this.formatter = extFormatter;
            this.doc = document;
            this.offset = n;
            this.underWriter = writer;
            this.setIndentOnly(bl);
            if (debug) {
                System.err.println("FormatWriter() created, formatter=" + extFormatter + ", document=" + document.getClass() + ", expandTabs=" + extFormatter.expandTabs() + ", spacesPerTab=" + extFormatter.getSpacesPerTab() + ", tabSize=" + (document instanceof BaseDocument ? ((BaseDocument)document).getTabSize() : extFormatter.getTabSize()) + ", shiftWidth=" + (document instanceof BaseDocument ? ((BaseDocument)document).getShiftWidth() : extFormatter.getShiftWidth()));
            }
            if (extFormatter.isSimple()) {
                this.simple = true;
                return;
            }
            this.buffer = EMPTY_BUFFER;
            this.firstFlush = true;
            Class clazz2 = clazz = document instanceof BaseDocument ? ((BaseDocument)document).getKitClass() : extFormatter.getKitClass();
            if (clazz == null || !BaseKit.class.isAssignableFrom(clazz)) {
                this.simple = true;
                return;
            }
            this.syntax = BaseKit.getKit(clazz).createFormatSyntax(document);
            if (!extFormatter.acceptSyntax(this.syntax)) {
                this.simple = true;
                return;
            }
            this.ftps = new FormatTokenPositionSupport(this);
            if (document instanceof BaseDocument) {
                try {
                    TokenItem tokenItem;
                    object = (BaseDocument)document;
                    ((BaseDocument)object).getSyntaxSupport().initSyntax(this.syntax, n, n, false, true);
                    this.offsetPreScan = this.syntax.getPreScan();
                    if (debug) {
                        System.err.println("FormatWriter: preScan=" + this.offsetPreScan + " at offset=" + n);
                    }
                    if (n <= 0) break block18;
                    object2 = (ExtSyntaxSupport)((BaseDocument)object).getSyntaxSupport();
                    Integer n2 = (Integer)((AbstractDocument)object).getProperty("line-batch-size");
                    int n3 = Utilities.getRowStart((BaseDocument)object, Math.max(n - this.offsetPreScan, 0), -Math.max(n2, 1));
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    if ((tokenItem = ((ExtSyntaxSupport)object2).getTokenChain(n3, n)) != null && tokenItem.getOffset() < n - this.offsetPreScan) {
                        this.lastToken = new FilterDocumentItem(tokenItem, null, false);
                        if (debug) {
                            System.err.println("FormatWriter: first doc token=" + this.lastToken);
                        }
                        while (this.lastToken.getNext() != null && this.lastToken.getNext().getOffset() < n - this.offsetPreScan) {
                            this.lastToken = (ExtTokenItem)this.lastToken.getNext();
                            if (!debug) continue;
                            System.err.println("FormatWriter: doc token=" + this.lastToken);
                        }
                        ((FilterDocumentItem)this.lastToken).terminate();
                    }
                }
                catch (BadLocationException badLocationException) {
                    Utilities.annotateLoggable(badLocationException);
                }
            } else {
                try {
                    object = document.getText(0, n);
                    object2 = ((String)object).toCharArray();
                    this.syntax.load(null, (char[])object2, 0, ((char[])object2).length, false, 0);
                    TokenID tokenID = this.syntax.nextToken();
                    while (tokenID != null) {
                        int n4 = this.syntax.getTokenOffset();
                        this.lastToken = new FormatTokenItem(tokenID, this.syntax.getTokenContextPath(), n4, ((String)object).substring(n4, n4 + this.syntax.getTokenLength()), this.lastToken);
                        if (debug) {
                            System.err.println("FormatWriter: non-bd token=" + this.lastToken);
                        }
                        ((FormatTokenItem)this.lastToken).markWritten();
                        tokenID = this.syntax.nextToken();
                    }
                    this.offsetPreScan = this.syntax.getPreScan();
                }
                catch (BadLocationException badLocationException) {
                    Utilities.annotateLoggable(badLocationException);
                }
            }
        }
        object = this.syntax.getBuffer();
        int n5 = this.syntax.getOffset();
        if (debug) {
            System.err.println("FormatWriter: writing preScan chars='" + EditorDebug.debugChars((char[])object, n5 - this.offsetPreScan, this.offsetPreScan) + "'" + ", length=" + this.offsetPreScan);
        }
        this.addToBuffer((char[])object, n5 - this.offsetPreScan, this.offsetPreScan);
    }

    public final ExtFormatter getFormatter() {
        return this.formatter;
    }

    public final Document getDocument() {
        return this.doc;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final boolean isIndentOnly() {
        return this.indentOnly;
    }

    public void setIndentOnly(boolean bl) {
        this.indentOnly = bl;
    }

    public FormatTokenPosition getFormatStartPosition() {
        return this.formatStartPosition;
    }

    public FormatTokenPosition getTextStartPosition() {
        return this.textStartPosition;
    }

    public TokenItem getLastToken() {
        return this.lastToken;
    }

    public TokenItem findFirstToken(TokenItem tokenItem) {
        if (tokenItem == null) {
            TokenItem tokenItem2 = tokenItem = this.textStartPosition != null ? this.textStartPosition.getToken() : null;
            if (tokenItem == null && (tokenItem = this.formatStartPosition.getToken()) == null && (tokenItem = this.lastToken) == null) {
                return null;
            }
        }
        while (tokenItem.getPrevious() != null) {
            tokenItem = tokenItem.getPrevious();
        }
        return tokenItem;
    }

    public boolean isAfter(TokenItem tokenItem, TokenItem tokenItem2) {
        while (tokenItem2 != null) {
            if ((tokenItem2 = tokenItem2.getNext()) != tokenItem) continue;
            return true;
        }
        return false;
    }

    public boolean isAfter(FormatTokenPosition formatTokenPosition, FormatTokenPosition formatTokenPosition2) {
        if (formatTokenPosition.getToken() == formatTokenPosition2.getToken()) {
            return formatTokenPosition.getOffset() > formatTokenPosition2.getOffset();
        }
        return this.isAfter(formatTokenPosition.getToken(), formatTokenPosition2.getToken());
    }

    public TokenItem findNonEmptyToken(TokenItem tokenItem, boolean bl) {
        while (tokenItem != null && tokenItem.getImage().length() == 0) {
            tokenItem = bl ? tokenItem.getPrevious() : tokenItem.getNext();
        }
        return tokenItem;
    }

    public boolean canInsertToken(TokenItem tokenItem) {
        return tokenItem == null || !((ExtTokenItem)tokenItem).isWritten();
    }

    public TokenItem insertToken(TokenItem tokenItem, TokenID tokenID, TokenContextPath tokenContextPath, String string) {
        FormatTokenItem formatTokenItem;
        if (debugModify) {
            System.err.println("FormatWriter.insertToken(): beforeToken=" + tokenItem + ", tokenID=" + tokenID + ", contextPath=" + tokenContextPath + ", tokenImage='" + string + "'");
        }
        if (!this.canInsertToken(tokenItem)) {
            throw new IllegalStateException("Can't insert token into chain");
        }
        if (this.reformatting) {
            try {
                this.doc.insertString(this.getDocOffset(tokenItem), string, null);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        if (tokenItem != null) {
            formatTokenItem = ((FormatTokenItem)tokenItem).insertToken(tokenID, tokenContextPath, -1, string);
        } else {
            formatTokenItem = new FormatTokenItem(tokenID, tokenContextPath, -1, string, this.lastToken);
            this.lastToken = formatTokenItem;
        }
        this.ftps.tokenInsert(formatTokenItem);
        this.chainModified = true;
        return formatTokenItem;
    }

    private int getDocOffset(TokenItem tokenItem) {
        int n = 0;
        for (tokenItem = tokenItem != null ? tokenItem.getPrevious() : this.lastToken; tokenItem != null; tokenItem = tokenItem.getPrevious()) {
            n += tokenItem.getImage().length();
            if (!(tokenItem instanceof FilterDocumentItem)) continue;
            return n + tokenItem.getOffset();
        }
        return n;
    }

    public boolean canRemoveToken(TokenItem tokenItem) {
        return !((ExtTokenItem)tokenItem).isWritten();
    }

    public void removeToken(TokenItem tokenItem) {
        if (debugModify) {
            System.err.println("FormatWriter.removeToken(): token=" + tokenItem);
        }
        if (!this.canRemoveToken(tokenItem)) {
            return;
        }
        if (this.reformatting) {
            try {
                this.doc.remove(this.getDocOffset(tokenItem), tokenItem.getImage().length());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        this.ftps.tokenRemove(tokenItem);
        if (this.lastToken == tokenItem) {
            this.lastToken = (ExtTokenItem)tokenItem.getPrevious();
        }
        ((FormatTokenItem)tokenItem).remove();
        this.chainModified = true;
    }

    public boolean canSplitStart(TokenItem tokenItem, int n) {
        return !((ExtTokenItem)tokenItem).isWritten();
    }

    public TokenItem splitStart(TokenItem tokenItem, int n, TokenID tokenID, TokenContextPath tokenContextPath) {
        if (!this.canSplitStart(tokenItem, n)) {
            throw new IllegalStateException("Can't split the token=" + tokenItem);
        }
        String string = tokenItem.getImage();
        if (n > string.length()) {
            throw new IllegalArgumentException("startLength=" + n + " is greater than token length=" + string.length());
        }
        String string2 = string.substring(0, n);
        ExtTokenItem extTokenItem = (ExtTokenItem)this.insertToken(tokenItem, tokenID, tokenContextPath, string2);
        this.ftps.splitStartTokenPositions(tokenItem, n);
        this.remove(tokenItem, 0, n);
        return extTokenItem;
    }

    public boolean canSplitEnd(TokenItem tokenItem, int n) {
        int n2 = tokenItem.getImage().length() - n;
        return ((ExtTokenItem)tokenItem).getWrittenLength() <= n2;
    }

    public TokenItem splitEnd(TokenItem tokenItem, int n, TokenID tokenID, TokenContextPath tokenContextPath) {
        if (!this.canSplitEnd(tokenItem, n)) {
            throw new IllegalStateException("Can't split the token=" + tokenItem);
        }
        String string = tokenItem.getImage();
        if (n > string.length()) {
            throw new IllegalArgumentException("endLength=" + n + " is greater than token length=" + string.length());
        }
        String string2 = string.substring(0, n);
        ExtTokenItem extTokenItem = (ExtTokenItem)this.insertToken(tokenItem.getNext(), tokenID, tokenContextPath, string2);
        this.ftps.splitEndTokenPositions(tokenItem, n);
        this.remove(tokenItem, string.length() - n, n);
        return extTokenItem;
    }

    public boolean canModifyToken(TokenItem tokenItem, int n) {
        int n2 = ((ExtTokenItem)tokenItem).getWrittenLength();
        return n >= 0 && n2 <= n;
    }

    public void insertString(TokenItem tokenItem, int n, String string) {
        if (debugModify) {
            System.err.println("FormatWriter.insertString(): token=" + tokenItem + ", offset=" + n + ", text='" + string + "'");
        }
        if (string.length() == 0) {
            return;
        }
        if (!this.canModifyToken(tokenItem, n)) {
            return;
        }
        if (this.reformatting) {
            try {
                this.doc.insertString(this.getDocOffset(tokenItem) + n, string, null);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        this.ftps.tokenTextInsert(tokenItem, n, string.length());
        String string2 = tokenItem.getImage();
        ((ExtTokenItem)tokenItem).setImage(string2.substring(0, n) + string + string2.substring(n));
    }

    public void remove(TokenItem tokenItem, int n, int n2) {
        String string;
        if (debugModify) {
            string = n >= 0 && n2 >= 0 && n + n2 <= tokenItem.getImage().length() ? tokenItem.getImage().substring(n, n + n2) : "<INVALID>";
            System.err.println("FormatWriter.remove(): token=" + tokenItem + ", offset=" + n + ", length=" + n2 + "removing text='" + string + "'");
        }
        if (n2 == 0) {
            return;
        }
        if (!this.canModifyToken(tokenItem, n)) {
            return;
        }
        if (this.reformatting) {
            try {
                this.doc.remove(this.getDocOffset(tokenItem) + n, n2);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        this.ftps.tokenTextRemove(tokenItem, n, n2);
        string = tokenItem.getImage();
        ((ExtTokenItem)tokenItem).setImage(string.substring(0, n) + string.substring(n + n2));
    }

    public FormatTokenPosition getPosition(TokenItem tokenItem, int n, Position.Bias bias) {
        return this.ftps.getTokenPosition(tokenItem, n, bias);
    }

    public boolean isChainStartPosition(FormatTokenPosition formatTokenPosition) {
        TokenItem tokenItem = formatTokenPosition.getToken();
        return formatTokenPosition.getOffset() == 0 && (tokenItem == null && this.getLastToken() == null || tokenItem != null && tokenItem.getPrevious() == null);
    }

    private void addToBuffer(char[] cArray, int n, int n2) {
        if (n2 > this.buffer.length - this.bufferSize) {
            char[] cArray2 = new char[n2 + 2 * this.buffer.length];
            System.arraycopy(this.buffer, 0, cArray2, 0, this.bufferSize);
            this.buffer = cArray2;
        }
        System.arraycopy(cArray, n, this.buffer, this.bufferSize, n2);
        this.bufferSize += n2;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.simple) {
            this.underWriter.write(cArray, n, n2);
            return;
        }
        this.write(cArray, n, n2, null, null);
    }

    public synchronized void write(char[] cArray, int n, int n2, int[] nArray, Position.Bias[] biasArray) throws IOException {
        if (this.simple) {
            this.underWriter.write(cArray, n, n2);
            return;
        }
        if (nArray != null) {
            this.ftps.addSaveSet(this.bufferSize, n2, nArray, biasArray);
        }
        this.lastFlush = false;
        if (debug) {
            System.err.println("FormatWriter.write(): '" + EditorDebug.debugChars(cArray, n, n2) + "', length=" + n2 + ", bufferSize=" + this.bufferSize);
        }
        this.addToBuffer(cArray, n, n2);
    }

    public boolean isChainModified() {
        return this.chainModified;
    }

    public void setChainModified(boolean bl) {
        this.chainModified = bl;
    }

    public boolean isRestartFormat() {
        return this.restartFormat;
    }

    public void setRestartFormat(boolean bl) {
        this.restartFormat = bl;
    }

    public int getIndentShift() {
        return this.indentShift;
    }

    public void setIndentShift(int n) {
        this.indentShift = n;
    }

    public void flush() throws IOException {
        CharSequence charSequence;
        if (debug) {
            System.err.println("FormatWriter.flush() called");
        }
        if (this.simple) {
            this.underWriter.flush();
            return;
        }
        if (this.lastFlush) {
            return;
        }
        this.lastFlush = true;
        int n = 0;
        if (this.firstFlush) {
            n = this.offsetPreScan;
        }
        this.syntax.relocate(this.buffer, n, this.bufferSize - n, true, -1);
        this.formatStartPosition = null;
        TokenID tokenID = this.syntax.nextToken();
        if (this.firstFlush && n > 0) {
            while (true) {
                charSequence = new String(this.buffer, this.syntax.getTokenOffset(), this.syntax.getTokenLength());
                this.lastToken = new FormatTokenItem(tokenID, this.syntax.getTokenContextPath(), -1, (String)charSequence, this.lastToken);
                if (debug) {
                    System.err.println("FormatWriter.flush(): doc&format token=" + this.lastToken);
                }
                this.lastToken.setWrittenLength(n);
                if (((String)charSequence).length() > n) {
                    this.formatStartPosition = this.getPosition(this.lastToken, n, Position.Bias.Backward);
                }
                tokenID = this.syntax.nextToken();
                if (((String)charSequence).length() >= n) break;
                this.lastToken.setWrittenLength(Integer.MAX_VALUE);
                n -= ((String)charSequence).length();
            }
        }
        while (tokenID != null) {
            charSequence = new String(this.buffer, this.syntax.getTokenOffset(), this.syntax.getTokenLength());
            this.lastToken = new FormatTokenItem(tokenID, this.syntax.getTokenContextPath(), -1, (String)charSequence, this.lastToken);
            if (this.formatStartPosition == null) {
                this.formatStartPosition = this.getPosition(this.lastToken, 0, Position.Bias.Backward);
            }
            if (debug) {
                System.err.println("FormatWriter.flush(): format token=" + this.lastToken);
            }
            tokenID = this.syntax.nextToken();
        }
        if (this.formatStartPosition == null) {
            this.formatStartPosition = this.getPosition(null, 0, Position.Bias.Backward);
        }
        if (this.firstFlush) {
            this.textStartPosition = this.formatStartPosition;
        }
        this.bufferSize = 0;
        if (debug) {
            System.err.println("FormatWriter.flush(): formatting ...");
        }
        this.formatter.format(this);
        charSequence = new StringBuffer();
        ExtTokenItem extTokenItem = (ExtTokenItem)this.formatStartPosition.getToken();
        ExtTokenItem extTokenItem2 = null;
        if (extTokenItem != null) {
            switch (extTokenItem.getWrittenLength()) {
                case -1: {
                    ((StringBuffer)charSequence).append(extTokenItem.getImage());
                    break;
                }
                case 0x7FFFFFFF: {
                    throw new IllegalStateException("Wrong formatStartPosition");
                }
                default: {
                    ((StringBuffer)charSequence).append(extTokenItem.getImage().substring(this.formatStartPosition.getOffset()));
                }
            }
            extTokenItem.markWritten();
            extTokenItem2 = extTokenItem;
            for (extTokenItem = (ExtTokenItem)extTokenItem.getNext(); extTokenItem != null; extTokenItem = (ExtTokenItem)extTokenItem.getNext()) {
                extTokenItem2.setWrittenLength(Integer.MAX_VALUE);
                ((StringBuffer)charSequence).append(extTokenItem.getImage());
                extTokenItem.markWritten();
                extTokenItem2 = extTokenItem;
            }
        }
        if (((StringBuffer)charSequence).length() > 0) {
            char[] cArray = new char[((StringBuffer)charSequence).length()];
            ((StringBuffer)charSequence).getChars(0, cArray.length, cArray, 0);
            if (debug) {
                System.err.println("FormatWriter.flush(): chars to underlying writer='" + EditorDebug.debugChars(cArray, 0, cArray.length) + "'");
            }
            this.underWriter.write(cArray, 0, cArray.length);
        }
        this.underWriter.flush();
        this.firstFlush = false;
    }

    public void close() throws IOException {
        if (debug) {
            System.err.println("FormatWriter: close() called (-> flush())");
        }
        this.flush();
        this.underWriter.close();
    }

    public void checkChain() {
        TokenItem tokenItem = this.getLastToken();
        if (tokenItem.getNext() != null) {
            throw new IllegalStateException("Successor of last token exists.");
        }
        FormatTokenPosition formatTokenPosition = this.getFormatStartPosition();
        if (formatTokenPosition == null) {
            throw new IllegalStateException("getFormatStartPosition() returns null.");
        }
        this.checkFSPFollowsTSP();
    }

    private void checkFSPFollowsTSP() {
        if (!this.formatStartPosition.equals(this.textStartPosition) && !this.isAfter(this.formatStartPosition, this.textStartPosition)) {
            throw new IllegalStateException("formatStartPosition doesn't follow textStartPosition");
        }
    }

    public String chainToString(TokenItem tokenItem) {
        return this.chainToString(tokenItem, 5);
    }

    public String chainToString(TokenItem tokenItem, int n) {
        this.checkChain();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("D - document tokens, W - written tokens, F - tokens being formatted\n");
        this.checkFSPFollowsTSP();
        TokenItem tokenItem2 = this.getTextStartPosition().getToken();
        TokenItem tokenItem3 = this.getFormatStartPosition().getToken();
        TokenItem tokenItem4 = tokenItem2;
        if (tokenItem4 == null) {
            tokenItem4 = this.getLastToken();
        }
        while (tokenItem4 != null && tokenItem4.getPrevious() != null && --n > 0) {
            tokenItem4 = tokenItem4.getPrevious();
        }
        while (tokenItem4 != tokenItem2) {
            stringBuffer.append(tokenItem4 == tokenItem ? (char)'>' : ' ');
            stringBuffer.append("D  ");
            stringBuffer.append(tokenItem4.toString());
            stringBuffer.append('\n');
            tokenItem4 = tokenItem4.getNext();
        }
        while (tokenItem4 != tokenItem3) {
            stringBuffer.append(tokenItem4 == tokenItem ? (char)'>' : ' ');
            if (tokenItem4 == tokenItem2) {
                stringBuffer.append("D(" + this.getTextStartPosition().getOffset() + ')');
            }
            stringBuffer.append("W ");
            stringBuffer.append(tokenItem4.toString());
            stringBuffer.append('\n');
            tokenItem4 = tokenItem4.getNext();
        }
        stringBuffer.append(tokenItem4 == tokenItem ? (char)'>' : ' ');
        if (this.getFormatStartPosition().getOffset() > 0) {
            if (tokenItem3 == tokenItem2) {
                stringBuffer.append('D');
            } else {
                stringBuffer.append('W');
            }
        }
        stringBuffer.append("F ");
        stringBuffer.append(tokenItem4 != null ? tokenItem4.toString() : "NULL");
        stringBuffer.append('\n');
        if (tokenItem4 != null) {
            tokenItem4 = tokenItem4.getNext();
        }
        while (tokenItem4 != null) {
            stringBuffer.append(tokenItem4 == tokenItem ? (char)'>' : ' ');
            stringBuffer.append("F ");
            stringBuffer.append(tokenItem4.toString());
            stringBuffer.append('\n');
            tokenItem4 = tokenItem4.getNext();
        }
        return stringBuffer.toString();
    }

    static interface ExtTokenItem
    extends TokenItem {
        public void setNext(TokenItem var1);

        public void setPrevious(TokenItem var1);

        public boolean isWritten();

        public void markWritten();

        public int getWrittenLength();

        public void setWrittenLength(int var1);

        public void setImage(String var1);
    }

    static class FilterDocumentItem
    extends TokenItem.FilterItem
    implements ExtTokenItem {
        private static final FilterDocumentItem NULL_ITEM = new FilterDocumentItem(null, null, false);
        private TokenItem previous;
        private TokenItem next;

        FilterDocumentItem(TokenItem tokenItem, FilterDocumentItem filterDocumentItem, boolean bl) {
            super(tokenItem);
            if (filterDocumentItem != null) {
                if (bl) {
                    this.previous = filterDocumentItem;
                } else {
                    this.next = filterDocumentItem;
                }
            }
        }

        public TokenItem getNext() {
            TokenItem tokenItem;
            if (this.next == null && (tokenItem = super.getNext()) != null) {
                this.next = new FilterDocumentItem(tokenItem, this, true);
            }
            return this.next != NULL_ITEM ? this.next : null;
        }

        public void setNext(TokenItem tokenItem) {
            this.next = tokenItem;
        }

        public void terminate() {
            this.setNext(NULL_ITEM);
        }

        public void setPrevious(TokenItem tokenItem) {
            this.previous = tokenItem;
        }

        public boolean isWritten() {
            return true;
        }

        public void markWritten() {
        }

        public int getWrittenLength() {
            return Integer.MAX_VALUE;
        }

        public void setWrittenLength(int n) {
            if (n != Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Wrong writtenLength=" + n);
            }
        }

        public void setImage(String string) {
            throw new IllegalStateException("Cannot set image of the document-token.");
        }

        public TokenItem getPrevious() {
            TokenItem tokenItem;
            if (this.previous == null && (tokenItem = super.getPrevious()) != null) {
                this.previous = new FilterDocumentItem(tokenItem, this, false);
            }
            return this.previous;
        }
    }

    static class FormatTokenItem
    extends TokenItem.AbstractItem
    implements ExtTokenItem {
        int writtenLength = -1;
        TokenItem next;
        TokenItem previous;
        String image;
        int saveOffset;

        FormatTokenItem(TokenID tokenID, TokenContextPath tokenContextPath, int n, String string, TokenItem tokenItem) {
            super(tokenID, tokenContextPath, n, string);
            this.image = string;
            this.previous = tokenItem;
            if (tokenItem instanceof ExtTokenItem) {
                ((ExtTokenItem)tokenItem).setNext(this);
            }
        }

        public TokenItem getNext() {
            return this.next;
        }

        public TokenItem getPrevious() {
            return this.previous;
        }

        public void setNext(TokenItem tokenItem) {
            this.next = tokenItem;
        }

        public void setPrevious(TokenItem tokenItem) {
            this.previous = tokenItem;
        }

        public boolean isWritten() {
            return this.writtenLength >= 0;
        }

        public void markWritten() {
            if (this.writtenLength == Integer.MAX_VALUE) {
                throw new IllegalStateException("Already marked unextendable.");
            }
            this.writtenLength = this.getImage().length();
        }

        public int getWrittenLength() {
            return this.writtenLength;
        }

        public void setWrittenLength(int n) {
            if (n <= this.writtenLength) {
                throw new IllegalArgumentException("this.writtenLength=" + this.writtenLength + " < writtenLength=" + n);
            }
            this.writtenLength = n;
        }

        public String getImage() {
            return this.image;
        }

        public void setImage(String string) {
            this.image = string;
        }

        FormatTokenItem insertToken(TokenID tokenID, TokenContextPath tokenContextPath, int n, String string) {
            FormatTokenItem formatTokenItem = new FormatTokenItem(tokenID, tokenContextPath, n, string, this.previous);
            formatTokenItem.next = this;
            this.previous = formatTokenItem;
            return formatTokenItem;
        }

        void remove() {
            if (this.previous instanceof ExtTokenItem) {
                ((ExtTokenItem)this.previous).setNext(this.next);
            }
            if (this.next instanceof ExtTokenItem) {
                ((ExtTokenItem)this.next).setPrevious(this.previous);
            }
        }

        int getSaveOffset() {
            return this.saveOffset;
        }

        void setSaveOffset(int n) {
            this.saveOffset = n;
        }
    }
}

