/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseApprovalPanel
extends JPanel {
    public static final String LICENSE_APPROVED = "license-approved";
    private Map<String, Set<String>> license4plugins;
    private ButtonGroup bgApproveButtons;
    private JRadioButton rbAccept;
    private JRadioButton rbDismis;
    private JScrollPane spLicenses;
    private JTextArea taLicenses;
    private JTextArea taTitle;

    public LicenseApprovalPanel(InstallUnitWizardModel installUnitWizardModel) {
        this.initComponents();
        this.rbDismis.setSelected(true);
        if (installUnitWizardModel != null) {
            this.writeLicenses(installUnitWizardModel);
        } else {
            this.rbAccept.setEnabled(false);
            this.rbDismis.setEnabled(false);
            this.taLicenses.setEnabled(false);
        }
    }

    Collection<String> getLicenses() {
        assert (this.license4plugins != null) : "Licenses must found.";
        if (this.license4plugins == null && this.license4plugins.isEmpty()) {
            return Collections.emptyList();
        }
        return this.license4plugins.keySet();
    }

    private void goOverLicenses(InstallUnitWizardModel installUnitWizardModel) {
        for (UpdateElement updateElement : installUnitWizardModel.getAllUpdateElements()) {
            if (updateElement.getLicence() == null) continue;
            if (this.license4plugins == null) {
                this.license4plugins = new HashMap<String, Set<String>>();
            }
            if (this.license4plugins.containsKey(updateElement.getLicence())) {
                this.license4plugins.get(updateElement.getLicence()).add(updateElement.getDisplayName());
                continue;
            }
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(updateElement.getDisplayName());
            this.license4plugins.put(updateElement.getLicence(), hashSet);
        }
    }

    public boolean isApproved() {
        return this.rbAccept.isSelected();
    }

    private void initComponents() {
        this.bgApproveButtons = new ButtonGroup();
        this.taTitle = new JTextArea();
        this.rbAccept = new JRadioButton();
        this.rbDismis = new JRadioButton();
        this.spLicenses = new JScrollPane();
        this.taLicenses = new JTextArea();
        this.taTitle.setEditable(false);
        this.taTitle.setLineWrap(true);
        this.taTitle.setText(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_taTitle_Text"));
        this.taTitle.setWrapStyleWord(true);
        this.taTitle.setMargin(new Insets(0, 4, 0, 0));
        this.taTitle.setOpaque(false);
        this.bgApproveButtons.add(this.rbAccept);
        Mnemonics.setLocalizedText((AbstractButton)this.rbAccept, (String)NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_rbAccept_Text"));
        this.rbAccept.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbAccept.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LicenseApprovalPanel.this.rbAcceptActionPerformed(actionEvent);
            }
        });
        this.bgApproveButtons.add(this.rbDismis);
        Mnemonics.setLocalizedText((AbstractButton)this.rbDismis, (String)NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_rbDismis_Text"));
        this.rbDismis.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbDismis.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LicenseApprovalPanel.this.rbDismisActionPerformed(actionEvent);
            }
        });
        this.taLicenses.setColumns(20);
        this.taLicenses.setEditable(false);
        this.taLicenses.setLineWrap(true);
        this.taLicenses.setRows(5);
        this.taLicenses.setWrapStyleWord(true);
        this.taLicenses.setMargin(new Insets(0, 4, 0, 4));
        this.spLicenses.setViewportView(this.taLicenses);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.taTitle, -1, 473, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.rbDismis, -1, -1, Short.MAX_VALUE).add((Component)this.rbAccept, -1, -1, Short.MAX_VALUE)).add(1, (Component)this.spLicenses, -1, 473, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.taTitle, -2, 45, -2).addPreferredGap(0).add((Component)this.spLicenses, -1, 293, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.rbAccept).addPreferredGap(0).add((Component)this.rbDismis).addContainerGap()));
    }

    private void rbDismisActionPerformed(ActionEvent actionEvent) {
        this.firePropertyChange(LICENSE_APPROVED, null, (Object)this.rbAccept.isSelected());
    }

    private void rbAcceptActionPerformed(ActionEvent actionEvent) {
        this.firePropertyChange(LICENSE_APPROVED, null, (Object)this.rbAccept.isSelected());
    }

    private void writeLicenses(InstallUnitWizardModel installUnitWizardModel) {
        this.goOverLicenses(installUnitWizardModel);
        String string = "";
        for (String string2 : this.license4plugins.keySet()) {
            String string3 = "";
            for (String string4 : this.license4plugins.get(string2)) {
                string3 = string3 + (string3.length() == 0 ? "" : NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_tpLicense_Delimeter")) + string4;
            }
            string = string + NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_tpLicense_Head", (Object)string3);
            string = string + "\n";
            string = string + string2;
            string = string + NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_tpLicense_Separator");
        }
        this.taLicenses.setText(string);
        this.taLicenses.setCaretPosition(0);
    }
}

