/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Union2;

final class MIMESupport {
    private static final Reference<FileObject> EMPTY = new WeakReference<Object>(null);
    private static Reference<FileObject> lastFo = EMPTY;
    private static Reference<FileObject> lastCfo = EMPTY;
    private static Object lock = new Object();
    private static Logger ERR = Logger.getLogger(MIMESupport.class.getName());

    private MIMESupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String findMIMEType(FileObject fileObject, String string) {
        Object object;
        if (!fileObject.isValid() || fileObject.isFolder()) {
            return null;
        }
        if (string != null && !CachedFileObject.isAnyResolver()) {
            return string;
        }
        Object object2 = null;
        try {
            Object object3 = lock;
            synchronized (object3) {
                object = (CachedFileObject)lastCfo.get();
                object2 = object == null || fileObject != lastFo.get() || MIMESupport.timeOf(fileObject) != MIMESupport.timeOf((FileObject)object) ? new CachedFileObject(fileObject) : object;
                lastCfo = EMPTY;
            }
            object3 = ((CachedFileObject)object2).getMIMEType(string);
            return object3;
        }
        finally {
            object = lock;
            synchronized (object) {
                lastFo = new WeakReference<FileObject>(fileObject);
                lastCfo = new WeakReference<CachedFileObject>((CachedFileObject)object2);
            }
        }
    }

    private static long timeOf(FileObject fileObject) {
        if (fileObject == null) {
            throw new NullPointerException();
        }
        Date date = fileObject.lastModified();
        assert (date != null) : "Null lastModified from " + fileObject;
        return date.getTime();
    }

    static MIMEResolver[] getResolvers() {
        return CachedFileObject.getResolvers();
    }

    private static class CachedInputStream
    extends InputStream {
        private InputStream inputStream;
        private byte[] buffer = null;
        private int len = 0;
        private int pos = 0;
        private boolean eof = false;

        CachedInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public void close() throws IOException {
        }

        void internalClose() {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected void finalize() {
            this.internalClose();
        }

        private boolean ensureBufferLength(int n) throws IOException {
            if (!this.eof && n > this.len) {
                int n2;
                byte[] byArray = new byte[this.len + n];
                if (this.len > 0) {
                    System.arraycopy(this.buffer, 0, byArray, 0, this.len);
                }
                if ((n2 = this.inputStream.read(byArray, this.len, n)) > 0) {
                    this.buffer = byArray;
                    this.len += n2;
                } else {
                    this.eof = true;
                }
            }
            return this.len >= n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            this.ensureBufferLength(this.pos + n2);
            int n4 = Math.min(this.len, this.pos + n2);
            int n5 = n3 = n4 > this.pos ? n4 - this.pos : -1;
            if (n3 != -1) {
                System.arraycopy(this.buffer, this.pos, byArray, n, n3);
                this.pos += n3;
            }
            return n3;
        }

        public int read() throws IOException {
            int n = -1;
            this.ensureBufferLength(this.pos + 1);
            if (this.len > this.pos) {
                n = (n = this.buffer[this.pos++]) < 0 ? n + 256 : n;
            }
            return n;
        }

        void cacheToStart() {
            this.pos = 0;
            this.eof = false;
        }

        public String toString() {
            String string = super.toString() + '[' + this.inputStream.toString() + ']' + '\n';
            string = string + new String(this.buffer);
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedFileObject
    extends FileObject
    implements FileChangeListener {
        static Lookup.Result<MIMEResolver> result;
        private static Union2<MIMEResolver[], Set<Thread>> resolvers;
        private static MIMEResolver[] previousResolvers;
        String mimeType;
        Date lastModified;
        CachedInputStream fixIt;
        FileObject fileObj;

        CachedFileObject(FileObject fileObject) {
            this.fileObj = fileObject;
            this.lastModified = this.fileObj.lastModified();
            this.fileObj.addFileChangeListener(FileUtil.weakFileChangeListener(this, this.fileObj));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static MIMEResolver[] getResolvers() {
            MIMEResolver[] mIMEResolverArray = CachedFileObject.class;
            synchronized (CachedFileObject.class) {
                HashSet<Thread> hashSet;
                if (resolvers != null && resolvers.hasFirst()) {
                    // ** MonitorExit[var1] (shouldn't be in output)
                    return (MIMEResolver[])resolvers.first();
                }
                if (resolvers != null) {
                    hashSet = (HashSet<Thread>)resolvers.second();
                    if (hashSet.contains(Thread.currentThread())) {
                        ERR.fine("Stack Overflow prevention. Returning previousResolvers: " + previousResolvers);
                        MIMEResolver[] mIMEResolverArray2 = previousResolvers;
                        if (mIMEResolverArray2 == null) {
                            mIMEResolverArray2 = new MIMEResolver[]{};
                        }
                        // ** MonitorExit[var1] (shouldn't be in output)
                        return mIMEResolverArray2;
                    }
                } else {
                    hashSet = new HashSet<Thread>();
                    resolvers = Union2.createSecond(hashSet);
                }
                if (result == null) {
                    result = Lookup.getDefault().lookupResult(MIMEResolver.class);
                    result.addLookupListener(new LookupListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void resultChanged(LookupEvent lookupEvent) {
                            Class<CachedFileObject> clazz = CachedFileObject.class;
                            synchronized (CachedFileObject.class) {
                                ERR.fine("Clearing cache");
                                Union2 union2 = resolvers;
                                if (union2 != null && union2.hasFirst()) {
                                    CachedFileObject.access$302((MIMEResolver[])union2.first());
                                }
                                resolvers = null;
                                lastFo = EMPTY;
                                lastCfo = EMPTY;
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return;
                            }
                        }
                    });
                }
                hashSet.add(Thread.currentThread());
                // ** MonitorExit[var1] (shouldn't be in output)
                ERR.fine("Computing resolvers");
                mIMEResolverArray = result.allInstances().toArray(new MIMEResolver[0]);
                ERR.fine("Resolvers computed");
                Class<CachedFileObject> clazz = CachedFileObject.class;
                synchronized (CachedFileObject.class) {
                    if (resolvers != null && resolvers.hasSecond() && resolvers.second() == hashSet) {
                        resolvers = Union2.createFirst((Object)mIMEResolverArray);
                        previousResolvers = null;
                        ERR.fine("Resolvers assigned");
                    } else {
                        ERR.fine("Somebody else computes resolvers: " + resolvers);
                    }
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return mIMEResolverArray;
                }
            }
        }

        public static boolean isAnyResolver() {
            return CachedFileObject.getResolvers().length > 0;
        }

        public void freeCaches() {
            this.fixIt = null;
            this.mimeType = null;
            this.lastModified = null;
        }

        @Override
        public String getMIMEType() {
            return this.getMIMEType(null);
        }

        public String getMIMEType(String string) {
            if (this.mimeType == null) {
                this.mimeType = this.resolveMIME(string);
            }
            return this.mimeType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String resolveMIME(String string) {
            String string2 = null;
            MIMEResolver[] mIMEResolverArray = CachedFileObject.getResolvers();
            try {
                for (int i = 0; i < mIMEResolverArray.length; ++i) {
                    string2 = mIMEResolverArray[i].findMIMEType(this);
                    if (string2 == null) continue;
                    String string3 = string2;
                    return string3;
                }
                if (string != null) {
                    String string4 = string;
                    return string4;
                }
                String string5 = "content/unknown";
                return string5;
            }
            finally {
                if (this.fixIt != null) {
                    this.fixIt.internalClose();
                }
                this.fixIt = null;
            }
        }

        @Override
        public Date lastModified() {
            if (this.lastModified != null) {
                return this.lastModified;
            }
            this.lastModified = this.fileObj.lastModified();
            return this.lastModified;
        }

        @Override
        public InputStream getInputStream() throws FileNotFoundException {
            if (this.fixIt == null) {
                InputStream inputStream = this.fileObj.getInputStream();
                if (!(inputStream instanceof BufferedInputStream)) {
                    inputStream = new BufferedInputStream(inputStream);
                }
                this.fixIt = new CachedInputStream(inputStream);
            }
            this.fixIt.cacheToStart();
            return this.fixIt;
        }

        @Override
        public void fileChanged(FileEvent fileEvent) {
            this.freeCaches();
        }

        @Override
        public void fileDeleted(FileEvent fileEvent) {
            this.freeCaches();
        }

        @Override
        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.freeCaches();
        }

        @Override
        public FileObject getParent() {
            return this.fileObj.getParent();
        }

        @Override
        @Deprecated
        public String getPackageNameExt(char c, char c2) {
            return this.fileObj.getPackageNameExt(c, c2);
        }

        @Override
        public FileObject copy(FileObject fileObject, String string, String string2) throws IOException {
            return this.fileObj.copy(fileObject, string, string2);
        }

        @Override
        protected void fireFileDeletedEvent(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
            this.fileObj.fireFileDeletedEvent(enumeration, fileEvent);
        }

        @Override
        protected void fireFileFolderCreatedEvent(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
            this.fileObj.fireFileFolderCreatedEvent(enumeration, fileEvent);
        }

        @Override
        @Deprecated
        public void setImportant(boolean bl) {
            this.fileObj.setImportant(bl);
        }

        @Override
        public boolean isData() {
            return this.fileObj.isData();
        }

        @Override
        public Object getAttribute(String string) {
            return this.fileObj.getAttribute(string);
        }

        @Override
        public Enumeration<? extends FileObject> getFolders(boolean bl) {
            return this.fileObj.getFolders(bl);
        }

        @Override
        public void delete(FileLock fileLock) throws IOException {
            this.fileObj.delete(fileLock);
        }

        @Override
        public boolean isRoot() {
            return this.fileObj.isRoot();
        }

        @Override
        public Enumeration<? extends FileObject> getData(boolean bl) {
            return this.fileObj.getData(bl);
        }

        @Override
        public FileObject[] getChildren() {
            return this.fileObj.getChildren();
        }

        @Override
        public String getNameExt() {
            return this.fileObj.getNameExt();
        }

        @Override
        public boolean isValid() {
            return this.fileObj.isValid();
        }

        @Override
        @Deprecated
        public boolean isReadOnly() {
            return this.fileObj.isReadOnly();
        }

        @Override
        public String getExt() {
            return this.fileObj.getExt();
        }

        @Override
        public String getName() {
            return this.fileObj.getName();
        }

        @Override
        public void removeFileChangeListener(FileChangeListener fileChangeListener) {
            this.fileObj.removeFileChangeListener(fileChangeListener);
        }

        @Override
        protected void fireFileRenamedEvent(Enumeration<FileChangeListener> enumeration, FileRenameEvent fileRenameEvent) {
            this.fileObj.fireFileRenamedEvent(enumeration, fileRenameEvent);
        }

        @Override
        public void refresh(boolean bl) {
            this.fileObj.refresh(bl);
        }

        @Override
        protected void fireFileAttributeChangedEvent(Enumeration<FileChangeListener> enumeration, FileAttributeEvent fileAttributeEvent) {
            this.fileObj.fireFileAttributeChangedEvent(enumeration, fileAttributeEvent);
        }

        @Override
        public long getSize() {
            return this.fileObj.getSize();
        }

        @Override
        public Enumeration<String> getAttributes() {
            return this.fileObj.getAttributes();
        }

        @Override
        public void rename(FileLock fileLock, String string, String string2) throws IOException {
            this.fileObj.rename(fileLock, string, string2);
        }

        @Override
        protected void fireFileChangedEvent(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
            this.fileObj.fireFileChangedEvent(enumeration, fileEvent);
        }

        @Override
        public FileObject getFileObject(String string, String string2) {
            return this.fileObj.getFileObject(string, string2);
        }

        @Override
        public void refresh() {
            this.fileObj.refresh();
        }

        @Override
        public FileObject createData(String string, String string2) throws IOException {
            return this.fileObj.createData(string, string2);
        }

        @Override
        public void addFileChangeListener(FileChangeListener fileChangeListener) {
            this.fileObj.addFileChangeListener(fileChangeListener);
        }

        @Override
        protected void fireFileDataCreatedEvent(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
            this.fileObj.fireFileDataCreatedEvent(enumeration, fileEvent);
        }

        @Override
        public boolean isFolder() {
            return this.fileObj.isFolder();
        }

        @Override
        public FileObject createFolder(String string) throws IOException {
            return this.fileObj.createFolder(string);
        }

        @Override
        public Enumeration<? extends FileObject> getChildren(boolean bl) {
            return this.fileObj.getChildren(bl);
        }

        @Override
        public void setAttribute(String string, Object object) throws IOException {
            this.fileObj.setAttribute(string, object);
        }

        @Override
        @Deprecated
        public String getPackageName(char c) {
            return this.fileObj.getPackageName(c);
        }

        @Override
        public FileSystem getFileSystem() throws FileStateInvalidException {
            return this.fileObj.getFileSystem();
        }

        @Override
        public OutputStream getOutputStream(FileLock fileLock) throws IOException {
            return this.fileObj.getOutputStream(fileLock);
        }

        @Override
        public boolean existsExt(String string) {
            return this.fileObj.existsExt(string);
        }

        @Override
        public FileObject move(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
            return this.fileObj.move(fileLock, fileObject, string, string2);
        }

        @Override
        public synchronized boolean isLocked() {
            return this.fileObj.isLocked();
        }

        @Override
        public FileLock lock() throws IOException {
            return this.fileObj.lock();
        }

        @Override
        public void fileFolderCreated(FileEvent fileEvent) {
        }

        @Override
        public void fileDataCreated(FileEvent fileEvent) {
        }

        @Override
        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public int hashCode() {
            return this.fileObj.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof CachedFileObject) {
                return ((CachedFileObject)object).fileObj.equals(this.fileObj);
            }
            return super.equals(object);
        }

        static /* synthetic */ MIMEResolver[] access$302(MIMEResolver[] mIMEResolverArray) {
            previousResolvers = mIMEResolverArray;
            return mIMEResolverArray;
        }
    }
}

