/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditor;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.sheet.properties.AbstractProperty;
import com.jaspersoft.ireport.designer.undo.PropertyUndoableEdit;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class EditTextfieldExpressionAction
extends NodeAction {
    public String getName() {
        return I18n.getString("EditTextfieldExpressionAction.name");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        ElementNode node = (ElementNode)activatedNodes[0];
        ExpressionEditor editor = new ExpressionEditor();
        JRDesignTextField element = (JRDesignTextField)node.getElement();
        if (ModelUtils.getTopElementGroup((JRDesignElement)element) instanceof JRDesignCellContents) {
            JRDesignCellContents contents = (JRDesignCellContents)ModelUtils.getTopElementGroup((JRDesignElement)element);
            editor.setExpressionContext(new ExpressionContext(contents.getOrigin().getCrosstab()));
        } else {
            JRDesignDataset dataset = ModelUtils.getElementDataset((JRDesignElement)element, node.getJasperDesign());
            if (dataset != null) {
                editor.setExpressionContext(new ExpressionContext(dataset));
            }
        }
        if (element.getExpression() != null) {
            editor.setExpression(Misc.getExpressionText(element.getExpression()));
        }
        if (editor.showDialog(Misc.getMainFrame()) == 0) {
            JRDesignExpression oldExp = (JRDesignExpression)element.getExpression();
            JRDesignExpression newExp = new JRDesignExpression();
            newExp.setValueClassName(this.getExpressionClassName(element));
            newExp.setText(editor.getExpression());
            element.setExpression((JRExpression)newExp);
            Node.Property obj = ModelUtils.findProperty(node.getPropertySets(), "expression");
            if (obj != null && obj instanceof AbstractProperty) {
                PropertyUndoableEdit edit = new PropertyUndoableEdit((AbstractProperty)obj, oldExp, newExp);
                IReportManager.getInstance().addUndoableEdit(edit);
                IReportManager.getInstance().notifyReportChange();
            }
        }
    }

    private String getExpressionClassName(JRDesignTextField element) {
        if (element.getExpression() == null) {
            return "java.lang.String";
        }
        if (element.getExpression().getValueClassName() == null) {
            return "java.lang.String";
        }
        return element.getExpression().getValueClassName();
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        if (!(activatedNodes[0] instanceof ElementNode)) {
            return false;
        }
        ElementNode node = (ElementNode)activatedNodes[0];
        return node.getElement() instanceof JRDesignTextField;
    }
}

