/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.connection.JDBCConnection;
import com.jaspersoft.ireport.designer.connection.gui.JDBCDriverDefinition;
import com.jaspersoft.ireport.designer.connection.gui.JDBCDriverListRenderer;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class JDBCConnectionEditor
extends JPanel
implements IReportConnectionEditor {
    private IReportConnection iReportConnection = null;
    public static JDBCDriverDefinition[] definitions = new JDBCDriverDefinition[]{new JDBCDriverDefinition("Cloudscape", "COM.cloudscape.JDBCDriver", "jdbc:cloudscape:/{1}"), new JDBCDriverDefinition("IBM DB2", "COM.ibm.db2.jdbc.app.DB2Driver", "jdbc:db2:{0}/{1}"), new JDBCDriverDefinition("inetdae7", "com.inet.tds.TdsDriver", "jdbc:inetdae7:{0}:1433/{1}"), new JDBCDriverDefinition("Informix", "com.informix.jdbc.IfxDriver", "jdbc:informix-sqli://{0}:informixserver={1}"), new JDBCDriverDefinition("Ingres", "com.ingres.jdbc.IngresDriver", "jdbc:ingres://{0}:II7/{1}"), new JDBCDriverDefinition("HSQLDB (file)", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:[PATH_TO_DB_FILES]/{1}"), new JDBCDriverDefinition("HSQLDB (server)", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:hsql://{0}"), new JDBCDriverDefinition("JDBC-ODBC Bridge", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:{1}", "DSNAME"), new JDBCDriverDefinition("JDBC-ODBC Bridge", "com.ms.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:{1}", "DSNAME"), new JDBCDriverDefinition("MS SQLServer", "com.internetcds.jdbc.tds.Driver", "jdbc:freetds:sqlserver://{0}/{1}"), new JDBCDriverDefinition("MS SQLServer (2000)", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "jdbc:microsoft:sqlserver://{0}:1433;DatabaseName={1}"), new JDBCDriverDefinition("MS SQLServer (2005)", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://{0}:1433;databaseName={1}"), new JDBCDriverDefinition("MS SQLServer", "net.sourceforge.jtds.jdbc.Driver", "jdbc:jtds:sqlserver://{0}/{1}"), new JDBCDriverDefinition("MS SQLServer", "com.merant.datadirect.jdbc.sqlserver.SQLServerDriver", "jdbc:sqlserver://{0}:1433/{1}"), new JDBCDriverDefinition("MySQL", "org.gjt.mm.mysql.Driver", "jdbc:mysql://{0}/{1}"), new JDBCDriverDefinition("MySQL", "com.mysql.jdbc.Driver", "jdbc:mysql://{0}/{1}"), new JDBCDriverDefinition("Oracle", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@{0}:1521:{1}"), new JDBCDriverDefinition("PostgreSQL", "org.postgresql.Driver", "jdbc:postgresql://{0}:5432/{1}"), new JDBCDriverDefinition("Sybase", "com.sybase.jdbc2.jdbc.SybDriver", "jdbc:sybase:Tds:{0}:2638/{1}"), new JDBCDriverDefinition("Vertica", "com.vertica.Driver", "jdbc:vertica://{0}:5433/{1}")};
    private JButton jButtonWizard;
    private JCheckBox jCheckBoxSavePassword;
    private JComboBox jComboBoxJDBCDriver;
    private JLabel jLabel1;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel2;
    private JPanel jPanelJDBC;
    private JTextField jTextFieldDBName;
    private JTextField jTextFieldJDBCUrl;
    private JPasswordField jTextFieldPassword;
    private JTextField jTextFieldServerAddress;
    private JTextField jTextFieldUsername;

    public JDBCConnectionEditor() {
        this.initComponents();
        this.jComboBoxJDBCDriver.setRenderer(new JDBCDriverListRenderer());
        this.jComboBoxJDBCDriver.setModel(new DefaultComboBoxModel<JDBCDriverDefinition>(definitions));
        this.jComboBoxJDBCDriver.setSelectedIndex(15);
        this.jLabel1.setText(I18n.getString("XMLADataSourceConnectionEditor.Label.Warning"));
    }

    private void initComponents() {
        this.jPanelJDBC = new JPanel();
        this.jLabel2 = new JLabel();
        this.jComboBoxJDBCDriver = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jTextFieldJDBCUrl = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel14 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextFieldDBName = new JTextField();
        this.jTextFieldServerAddress = new JTextField();
        this.jButtonWizard = new JButton();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jTextFieldPassword = new JPasswordField();
        this.jTextFieldUsername = new JTextField();
        this.jCheckBoxSavePassword = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.setLayout(new BorderLayout());
        this.jPanelJDBC.setLayout(new GridBagLayout());
        this.jLabel2.setText(I18n.getString("JDBCConnectionEditor.Label.JDBC_Driver"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanelJDBC.add((Component)this.jLabel2, gridBagConstraints);
        this.jComboBoxJDBCDriver.setEditable(true);
        this.jComboBoxJDBCDriver.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDBCConnectionEditor.this.jComboBoxJDBCDriverActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 0, 6);
        this.jPanelJDBC.add((Component)this.jComboBoxJDBCDriver, gridBagConstraints);
        this.jLabel3.setText(I18n.getString("JDBCConnectionEditor.Label.JDBC_URL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanelJDBC.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 6, 0, 6);
        this.jPanelJDBC.add((Component)this.jTextFieldJDBCUrl, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("JDBC URL Wizard"));
        this.jPanel2.setMinimumSize(new Dimension(179, 70));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel14.setText(I18n.getString("JDBCConnectionEditor.Label.Server_Address"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel14, gridBagConstraints);
        this.jLabel5.setText(I18n.getString("JDBCConnectionEditor.Label.Database"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanel2.add((Component)this.jTextFieldDBName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanel2.add((Component)this.jTextFieldServerAddress, gridBagConstraints);
        this.jButtonWizard.setText(I18n.getString("Global.Button.Wizard"));
        this.jButtonWizard.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonWizard.setMaximumSize(new Dimension(60, 23));
        this.jButtonWizard.setMinimumSize(new Dimension(60, 23));
        this.jButtonWizard.setPreferredSize(new Dimension(60, 23));
        this.jButtonWizard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDBCConnectionEditor.this.jButtonWizardActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.jPanel2.add((Component)this.jButtonWizard, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanelJDBC.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabel6.setText(I18n.getString("Global.Label.Username"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanelJDBC.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText(I18n.getString("Global.Label.Password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanelJDBC.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanelJDBC.add((Component)this.jTextFieldPassword, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanelJDBC.add((Component)this.jTextFieldUsername, gridBagConstraints);
        this.jCheckBoxSavePassword.setText(I18n.getString("Global.CheckBox.Save_password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 6);
        this.jPanelJDBC.add((Component)this.jCheckBoxSavePassword, gridBagConstraints);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/connection/gui/warning.png")));
        this.jLabel1.setText("Attention! Passwords are saved in clear text.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelJDBC.add((Component)this.jLabel1, gridBagConstraints);
        this.add((Component)this.jPanelJDBC, "Center");
    }

    private void jComboBoxJDBCDriverActionPerformed(ActionEvent evt) {
        this.jButtonWizardActionPerformed(null);
    }

    private void jButtonWizardActionPerformed(ActionEvent evt) {
        if (this.jComboBoxJDBCDriver.getSelectedIndex() < 0) {
            return;
        }
        if (this.jComboBoxJDBCDriver.getSelectedItem() instanceof JDBCDriverDefinition) {
            String server = this.jTextFieldServerAddress.getText().trim();
            if (server.length() == 0) {
                server = "localhost";
            }
            String databaseName = this.jTextFieldDBName.getText().trim();
            this.jTextFieldJDBCUrl.setText(((JDBCDriverDefinition)this.jComboBoxJDBCDriver.getSelectedItem()).getUrl(server, databaseName));
        }
    }

    public void setIReportConnection(IReportConnection c) {
        this.iReportConnection = c;
        if (this.iReportConnection instanceof JDBCConnection) {
            JDBCConnection con = (JDBCConnection)this.iReportConnection;
            boolean found = false;
            for (int i = 0; i < definitions.length; ++i) {
                if (!definitions[i].getDriverName().equals(con.getJDBCDriver())) continue;
                this.jComboBoxJDBCDriver.setSelectedItem(definitions[i]);
                found = true;
            }
            if (!found) {
                this.jComboBoxJDBCDriver.setSelectedItem(con.getJDBCDriver());
            }
            this.jTextFieldJDBCUrl.setText(con.getUrl());
            this.jTextFieldServerAddress.setText(con.getServerAddress());
            this.jTextFieldDBName.setText(con.getDatabase());
            this.jTextFieldUsername.setText(con.getUsername());
            if (con.isSavePassword()) {
                this.jTextFieldPassword.setText(con.getPassword());
            } else {
                this.jTextFieldPassword.setText("");
            }
            this.jCheckBoxSavePassword.setSelected(con.isSavePassword());
        }
    }

    public IReportConnection getIReportConnection() {
        JDBCConnection irConn = new JDBCConnection();
        irConn.setServerAddress(this.jTextFieldServerAddress.getText().trim());
        irConn.setDatabase(this.jTextFieldDBName.getText().trim());
        irConn.setUsername(this.jTextFieldUsername.getText().trim());
        if (this.jCheckBoxSavePassword.isSelected()) {
            irConn.setPassword(new String(this.jTextFieldPassword.getPassword()));
        } else {
            irConn.setPassword("");
        }
        irConn.setSavePassword(this.jCheckBoxSavePassword.isSelected());
        Object obj = this.jComboBoxJDBCDriver.getSelectedItem();
        String driver = obj + "";
        if (obj instanceof JDBCDriverDefinition) {
            driver = ((JDBCDriverDefinition)obj).getDriverName();
        }
        irConn.setJDBCDriver(driver.trim());
        if (driver.trim().length() == 0 || driver.indexOf(" ") >= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("JDBCConnectionEditor.Message.JDBCDriver"), I18n.getString("JDBCConnectionEditor.Message.InvalidDriver"), 2);
            return null;
        }
        if (this.jTextFieldJDBCUrl.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("JDBCConnectionEditor.Message.JDBCurl"), I18n.getString("JDBCConnectionEditor.Message.InvalidUrl"), 2);
            return null;
        }
        irConn.setUrl(this.jTextFieldJDBCUrl.getText().trim());
        this.iReportConnection = irConn;
        return this.iReportConnection;
    }
}

