/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.formatting.actions;

import com.jaspersoft.ireport.designer.formatting.actions.AbstractFormattingToolAction;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;

public class JoinRightAction
extends AbstractFormattingToolAction {
    public JoinRightAction() {
        this.putValue("Name", this.getName());
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 3));
    }

    protected String iconResource() {
        return "com/jaspersoft/ireport/designer/resources/formatting/joinright.png";
    }

    protected void performAction(Node[] nodes) {
        if (nodes.length == 0) {
            return;
        }
        JasperDesign jd = (JasperDesign)nodes[0].getLookup().lookup(JasperDesign.class);
        if (jd == null) {
            return;
        }
        List<JRDesignElement> elements = this.getSelectedElements(nodes);
        boolean aggregate = false;
        List<JRDesignElement> sortedElements = this.sortXY(elements, true);
        int actualX = sortedElements.get(0).getX() + sortedElements.get(0).getWidth();
        for (JRDesignElement element : sortedElements) {
            Rectangle oldBounds = this.getElementBounds(element);
            element.setX(actualX -= element.getWidth());
            aggregate = this.addTransformationUndo(element, oldBounds, aggregate);
        }
    }

    public String getName() {
        return I18n.getString("formatting.tools.joinRight");
    }

    public boolean requiresMultipleObjects() {
        return true;
    }
}

