/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.utils;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.utils.ExpressionInterpreter;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.FileResolver;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ExpressionFileResolver
implements FileResolver {
    private JRDesignExpression expression = null;
    private JasperDesign jasperDesign = null;
    private String reportFolder = null;
    private File file = null;
    private boolean resolveFile = true;
    private JRDesignDataset dataset = null;

    public ExpressionFileResolver(JRDesignExpression expression, JRDesignDataset dataset, JasperDesign jd) {
        File reportFolderFile;
        JrxmlVisualView visualView;
        this.expression = expression;
        this.jasperDesign = jd;
        this.dataset = dataset;
        if (dataset == null) {
            this.dataset = jd.getMainDesignDataset();
        }
        if ((visualView = IReportManager.getInstance().getActiveVisualView()) != null && (reportFolderFile = FileUtil.toFile((FileObject)visualView.getEditorSupport().getDataObject().getPrimaryFile())).getParentFile() != null) {
            this.reportFolder = reportFolderFile.getParent();
        }
    }

    public File resolveFile(String arg0) {
        if (this.resolveFile) {
            ClassLoader classLoader = IReportManager.getReportClassLoader();
            try {
                ExpressionInterpreter interpreter = new ExpressionInterpreter(this.dataset, classLoader);
                Object ret = interpreter.interpretExpression(Misc.getExpressionText((JRExpression)this.expression));
                if (ret != null) {
                    String resourceName = ret + "";
                    File f = new File(resourceName);
                    if (!f.exists()) {
                        URLClassLoader urlClassLoader;
                        URL url;
                        URL[] urls = new URL[]{};
                        if (this.reportFolder != null) {
                            urls = new URL[]{new File(this.reportFolder).toURI().toURL()};
                        }
                        if ((url = (urlClassLoader = new URLClassLoader(urls, classLoader)).findResource(resourceName)) != null && (f = new File(url.getPath())).exists()) {
                            this.file = f;
                        }
                    } else {
                        this.file = f;
                    }
                    this.resolveFile = false;
                }
            }
            catch (Exception ex) {
                this.resolveFile = false;
                ex.printStackTrace();
            }
        }
        return this.getFile();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        if (this.jasperDesign != jasperDesign) {
            this.jasperDesign = jasperDesign;
            this.file = null;
            this.resolveFile = true;
        }
    }

    public String getReportFolder() {
        return this.reportFolder;
    }

    public void setReportFolder(String reportFolder) {
        if (reportFolder == null && this.reportFolder == null) {
            return;
        }
        if (reportFolder != null && this.reportFolder == null || reportFolder == null && this.reportFolder != null || !reportFolder.equals(this.reportFolder)) {
            this.reportFolder = reportFolder;
            this.file = null;
            this.resolveFile = true;
        }
    }
}

