/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.NodeRenderer;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultTreeModel;
import org.openide.actions.EditAction;
import org.openide.cookies.EditCookie;
import org.openide.nodes.Node;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

final class NodeListener
implements MouseListener,
KeyListener,
TreeWillExpandListener,
TreeExpansionListener {
    private static final boolean COLLAPSE_FILE_ON_SELECTION = false;
    private static final boolean COLLAPSE_FILE_ON_UNSELECTION = true;
    private boolean selectionChangeEnabled = true;

    NodeListener() {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JTree jTree = (JTree)mouseEvent.getSource();
        int n = mouseEvent.getClickCount();
        if (n != 1 && n != 2) {
            return;
        }
        TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        ResultModel resultModel = this.getResultModel(jTree);
        boolean bl = this.isInsideCheckBox(jTree, treePath, resultModel, mouseEvent);
        int n2 = mouseEvent.getModifiersEx();
        if (n2 == 0 || n2 == 16 || n2 == 1024) {
            if (n == 1 && bl) {
                assert (treePath != null);
                this.toggleSelection(jTree, treePath);
            }
            if (n == 2 && !bl) {
                if (treePath.getPathCount() == 1) {
                    this.toggleExpansionState(jTree, treePath);
                } else {
                    Node node = NodeListener.getNbNode(treePath, resultModel);
                    this.callDefaultAction(node, mouseEvent.getSource(), mouseEvent.getID(), "double-click");
                }
            }
        }
    }

    private void popupTriggerEventFired(MouseEvent mouseEvent) {
        JTree jTree = (JTree)mouseEvent.getSource();
        TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        ResultModel resultModel = this.getResultModel(jTree);
        jTree.setSelectionPath(treePath);
        if (!this.isInsideCheckBox(jTree, treePath, resultModel, mouseEvent)) {
            this.showPopup(jTree, treePath, resultModel, mouseEvent);
        }
    }

    private boolean isInsideCheckBox(JTree jTree, TreePath treePath, ResultModel resultModel, MouseEvent mouseEvent) {
        if (resultModel == null || !resultModel.searchAndReplace) {
            return false;
        }
        Rectangle rectangle = jTree.getPathBounds(treePath);
        Rectangle rectangle2 = NodeRenderer.getCheckBoxRectangle();
        rectangle2.setLocation(rectangle.x + rectangle2.x, rectangle.y + rectangle2.y);
        return rectangle2.contains(mouseEvent.getPoint());
    }

    private void showPopup(JTree jTree, TreePath treePath, ResultModel resultModel, MouseEvent mouseEvent) {
        int n = treePath.getPathCount();
        if (n != 1) {
            if (n == 2) {
                JPopupMenu jPopupMenu;
                Node node = NodeListener.getNbNode(treePath, resultModel);
                if (node != null && (jPopupMenu = this.createFileNodePopupMenu(node)) != null) {
                    jPopupMenu.show(jTree, mouseEvent.getX(), mouseEvent.getY());
                }
            } else if (n == 3) {
                Node node = NodeListener.getNbNode(treePath, resultModel);
                if (node != null) {
                    node.getContextMenu().show(jTree, mouseEvent.getX(), mouseEvent.getY());
                }
            } else assert (false);
        }
    }

    private boolean autocollapseFileNodeIfNeeded(JTree jTree, TreePath treePath, MatchingObject matchingObject, boolean bl) {
        boolean bl2;
        boolean bl3;
        assert (treePath.getPathCount() == 2 && treePath.getLastPathComponent() == matchingObject);
        boolean bl4 = bl3 = !bl;
        if (bl3) {
            if (matchingObject.isExpanded()) {
                jTree.collapsePath(treePath);
            }
            bl2 = true;
        } else {
            bl2 = !jTree.isExpanded(treePath);
        }
        return bl2;
    }

    private void toggleRootNodeSelection(JTree jTree, TreePath treePath) {
        Object object3;
        ResultTreeModel resultTreeModel = this.getResultTreeModel(treePath);
        ResultModel resultModel = resultTreeModel.resultModel;
        boolean bl = resultTreeModel.isSelected();
        boolean bl2 = !bl;
        boolean bl3 = !bl2;
        MatchingObject[] matchingObjectArray = resultModel.getMatchingObjects();
        int[] nArray = null;
        Object object2 = null;
        ArrayList<Object> arrayList = null;
        int n = 0;
        for (int i = 0; i < matchingObjectArray.length; ++i) {
            boolean bl4;
            object3 = matchingObjectArray[i];
            boolean bl5 = bl4 = !((MatchingObject)object3).isExpanded();
            if (bl3 && !bl4) {
                jTree.collapsePath(treePath.pathByAddingChild(object3));
                bl4 = true;
            }
            if (((MatchingObject)object3).isSelected() == bl2) continue;
            ((MatchingObject)object3).setSelected(bl2);
            if (n == 0) {
                int n2 = matchingObjectArray.length - i;
                nArray = new int[n2];
                object2 = new MatchingObject[n2];
            }
            nArray[n] = i;
            object2[n] = object3;
            ++n;
            if (bl4) {
                ((MatchingObject)object3).markChildrenSelectionDirty();
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<Object>(6);
            }
            arrayList.add(object3);
        }
        if (n != 0 && n != matchingObjectArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
            object3 = new MatchingObject[n];
            System.arraycopy(object2, 0, object3, 0, n);
            object2 = object3;
        }
        resultTreeModel.setSelected(bl2);
        resultTreeModel.fireRootNodeChanged();
        if (n != 0) {
            assert (nArray.length == n);
            assert ((object2).length == n);
            resultTreeModel.fireFileNodesSelectionChanged(nArray, (MatchingObject[])object2);
        }
        if (arrayList != null) {
            for (Object object3 : arrayList) {
                resultTreeModel.fireFileNodeChildrenSelectionChanged((MatchingObject)object3);
            }
        }
    }

    private void setFileNodeSelected(JTree jTree, TreePath treePath, MatchingObject matchingObject, boolean bl) {
        boolean bl2;
        assert (treePath.getPathCount() == 2);
        boolean bl3 = bl2 = this.autocollapseFileNodeIfNeeded(jTree, treePath, matchingObject, bl);
        matchingObject.setSelected(bl);
        this.getResultTreeModel(treePath).fireFileNodeSelectionChanged(matchingObject, !bl3);
        if (bl3) {
            matchingObject.markChildrenSelectionDirty();
        }
    }

    private void toggleDetailNodeSelection(JTree jTree, ResultModel resultModel, MatchingObject matchingObject, int n) {
        matchingObject.toggleSubnodeSelection(resultModel, n);
        this.getResultTreeModel(jTree).fireDetailNodeSelectionChanged(matchingObject, n);
    }

    private ResultTreeModel getResultTreeModel(TreePath treePath) {
        return (ResultTreeModel)treePath.getPathComponent(0);
    }

    private ResultTreeModel getResultTreeModel(JTree jTree) {
        return (ResultTreeModel)jTree.getPathForRow(0).getPathComponent(0);
    }

    private ResultModel getResultModel(JTree jTree) {
        return ((ResultTreeModel)jTree.getPathForRow((int)0).getPathComponent((int)0)).resultModel;
    }

    private static Node getNbNode(TreePath treePath, ResultModel resultModel) {
        Node node;
        boolean bl;
        MatchingObject matchingObject;
        Object object = treePath.getLastPathComponent();
        if (object.getClass() == MatchingObject.class) {
            matchingObject = (MatchingObject)object;
            bl = true;
        } else {
            Object object2 = treePath.getParentPath().getLastPathComponent();
            assert (object2.getClass() == MatchingObject.class);
            matchingObject = (MatchingObject)object2;
            bl = false;
        }
        if (!matchingObject.isObjectValid()) {
            return null;
        }
        if (bl) {
            node = resultModel.getSearchGroup().getNodeForFoundObject(matchingObject.object);
        } else {
            assert (object instanceof Node);
            node = (Node)object;
        }
        return node;
    }

    private JPopupMenu createFileNodePopupMenu(Node node) {
        Action action = this.getDefaultAction(node);
        if (action == null) {
            return null;
        }
        assert (action.isEnabled());
        JMenuItem jMenuItem = action instanceof Presenter.Popup ? ((Presenter.Popup)action).getPopupPresenter() : null;
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (jMenuItem != null) {
            jPopupMenu.add(jMenuItem);
        } else {
            jPopupMenu.add(action);
        }
        return jPopupMenu;
    }

    private Action getDefaultAction(Node node) {
        Action action;
        EditAction editAction = (EditAction)SharedClassObject.findObject(EditAction.class, (boolean)true);
        if (editAction != null && (action = editAction.createContextAwareInstance(Lookups.singleton((Object)node))).isEnabled()) {
            return action;
        }
        Action action2 = node.getPreferredAction();
        if (action2 == null) {
            return null;
        }
        action = action2;
        if (action instanceof NodeAction) {
            action = ((NodeAction)action).createContextAwareInstance(Lookups.singleton((Object)node));
        }
        return action != null && action.isEnabled() ? action : null;
    }

    private void callDefaultAction(Node node, Object object, int n, String string) {
        if (node == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        EditCookie editCookie = (EditCookie)node.getCookie(EditCookie.class);
        if (editCookie != null) {
            editCookie.edit();
            return;
        }
        Action action = node.getPreferredAction();
        if (action == null) {
            return;
        }
        if (action instanceof NodeAction) {
            action = ((NodeAction)action).createContextAwareInstance(Lookups.singleton((Object)node));
        }
        if (action != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(object, n, string));
        }
    }

    private void toggleExpansionState(JTree jTree, TreePath treePath) {
        if (jTree.isCollapsed(treePath)) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
    }

    private void toggleSelection(JTree jTree, TreePath treePath) {
        assert (EventQueue.isDispatchThread());
        if (!this.selectionChangeEnabled) {
            return;
        }
        int n = treePath.getPathCount();
        if (n == 1) {
            this.toggleRootNodeSelection(jTree, treePath);
        } else if (n == 2) {
            MatchingObject matchingObject;
            this.setFileNodeSelected(jTree, treePath, matchingObject, !(matchingObject = (MatchingObject)treePath.getPathComponent(1)).isSelected());
        } else {
            assert (n == 3);
            MatchingObject matchingObject = (MatchingObject)treePath.getPathComponent(1);
            int n2 = jTree.getRowForPath(treePath.getParentPath());
            int n3 = jTree.getRowForPath(treePath);
            int n4 = n3 - n2 - 1;
            this.toggleDetailNodeSelection(jTree, this.getResultModel(jTree), matchingObject, n4);
        }
    }

    void setSelectionChangeEnabled(boolean bl) {
        assert (EventQueue.isDispatchThread());
        this.selectionChangeEnabled = bl;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupTriggerEventFired(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupTriggerEventFired(mouseEvent);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == ' ') {
            JTree jTree = (JTree)keyEvent.getSource();
            TreePath treePath = jTree.getSelectionPath();
            if (treePath != null) {
                this.toggleSelection(jTree, treePath);
            }
        } else if (keyEvent.getKeyCode() == 10 && keyEvent.getModifiersEx() == 0) {
            JTree jTree = (JTree)keyEvent.getSource();
            TreeSelectionModel treeSelectionModel = jTree.getSelectionModel();
            if (treeSelectionModel.getSelectionCount() != 1) {
                return;
            }
            TreePath treePath = treeSelectionModel.getLeadSelectionPath();
            if (treePath == null || treePath.getParentPath() == null) {
                return;
            }
            Node node = NodeListener.getNbNode(treePath, this.getResultModel(jTree));
            this.callDefaultAction(node, keyEvent.getSource(), keyEvent.getID(), "enter");
        }
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        MatchingObject matchingObject;
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath.getPathCount() == 2 && (matchingObject = (MatchingObject)treePath.getLastPathComponent()).isChildrenSelectionDirty()) {
            this.getResultTreeModel(treePath).fireFileNodeChildrenSelectionChanged(matchingObject);
            matchingObject.markChildrenSelectionClean();
        }
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath.getPathCount() == 2) {
            ((MatchingObject)treePath.getLastPathComponent()).markExpanded(true);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath.getPathCount() == 2) {
            ((MatchingObject)treePath.getLastPathComponent()).markExpanded(false);
        }
    }
}

