/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.netbeans.modules.search.DialogLifetime;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openidex.search.SearchType;

public final class SearchTypePanel
extends JPanel
implements PropertyChangeListener,
ActionListener,
DialogLifetime {
    public static final String PROP_CUSTOMIZED = "customized";
    private static final String MODIFICATOR_SUFFIX = " *";
    private boolean customized;
    private SearchType searchType;
    private boolean initialized = false;
    final Customizer customizer;
    final Component customizerComponent;
    private String lastSavedName;
    private final JCheckBox applyCheckBox = new JCheckBox();
    private JPanel customizerPanel;

    public SearchTypePanel(SearchType searchType) {
        this.initComponents();
        this.initAccessibility();
        this.searchType = searchType;
        this.customizer = SearchTypePanel.createCustomizer(this.searchType);
        if (this.customizer != null) {
            this.customizerComponent = (Component)((Object)this.customizer);
        } else {
            this.customizerComponent = null;
            this.initialized = true;
            System.err.println("No customizer for " + this.searchType.getName() + ", skipping...");
        }
        this.customizer.setObject(this.searchType);
        this.searchType.addPropertyChangeListener((PropertyChangeListener)this);
        ResourceBundle resourceBundle = NbBundle.getBundle(SearchTypePanel.class);
        Mnemonics.setLocalizedText((AbstractButton)this.applyCheckBox, (String)resourceBundle.getString("TEXT_BUTTON_APPLY"));
        this.customizerPanel.add(this.customizerComponent, "Center");
        this.setCustomized(this.searchType.isValid());
        this.setName(this.createName());
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle(SearchTypePanel.class);
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_DIALOG_DESC"));
        this.applyCheckBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_BUTTON_APPLY"));
    }

    private void initComponents() {
        this.customizerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.customizerPanel.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.customizerPanel, gridBagConstraints);
        this.applyCheckBox.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(17, 11, 0, 11);
        this.add((Component)this.applyCheckBox, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.applyCheckBox) {
            boolean bl = this.applyCheckBox.isSelected();
            this.setCustomized(bl);
            this.searchType.setValid(bl);
        } else assert (false);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.searchType && "valid".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getNewValue().equals(Boolean.FALSE)) {
                this.setCustomized(false);
                return;
            }
            this.setCustomized(true);
        }
    }

    public void onOk() {
        if (this.customizer instanceof DialogLifetime) {
            ((DialogLifetime)((Object)this.customizer)).onOk();
        }
    }

    public void onCancel() {
        if (this.customizer instanceof DialogLifetime) {
            ((DialogLifetime)((Object)this.customizer)).onCancel();
        }
    }

    private String createName() {
        String string = this.searchType.getName();
        if (this.customized) {
            return string + MODIFICATOR_SUFFIX;
        }
        return string;
    }

    private static Customizer createCustomizer(SearchType searchType) {
        Object object;
        Class<?> clazz = searchType.getClass();
        Class<?> clazz2 = null;
        if (SearchTypePanel.isDefaultSearchType(clazz)) {
            object = searchType.getClass().getName();
            assert (((String)object).endsWith("Type"));
            int n = ((String)object).length();
            String string = new StringBuffer(n + 6).append(((String)object).substring(0, n - 4)).append("Customizer").toString();
            try {
                clazz2 = Class.forName(string);
            }
            catch (Exception exception) {
                assert (false);
                ErrorManager.getDefault().notify(65536, (Throwable)exception);
            }
        }
        if (clazz2 == null) {
            try {
                object = Utilities.getBeanInfo(clazz);
            }
            catch (IntrospectionException introspectionException) {
                ErrorManager.getDefault().notify(1, (Throwable)introspectionException);
                return null;
            }
            clazz2 = object.getBeanDescriptor().getCustomizerClass();
        }
        if (clazz2 == null) {
            return null;
        }
        try {
            object = clazz2.newInstance();
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        if (!(object instanceof Component) || !(object instanceof Customizer)) {
            return null;
        }
        return (Customizer)object;
    }

    private static boolean isDefaultSearchType(Class clazz) {
        assert (SearchType.class.isAssignableFrom(clazz));
        String string = "org.netbeans.modules.search.types";
        String string2 = clazz.getName();
        return string2.startsWith(string) && string2.lastIndexOf(46) == string.length();
    }

    private void setCustomized(boolean bl) {
        this.customized = bl;
        this.applyCheckBox.setSelected(this.customized);
        this.setName(this.createName());
        this.firePropertyChange(PROP_CUSTOMIZED, !bl, bl);
    }

    public boolean isCustomized() {
        return this.customized;
    }

    private void restoreSearchType(SearchType searchType) {
        this.searchType.removePropertyChangeListener((PropertyChangeListener)this);
        this.searchType = (SearchType)searchType.clone();
        this.initialized = false;
        this.initializeWithObject();
        this.searchType.addPropertyChangeListener((PropertyChangeListener)this);
        this.setCustomized(true);
    }

    final void initializeWithObject() {
        if (!this.initialized) {
            this.customizer.setObject(this.searchType);
            this.initialized = true;
        }
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public boolean equals(Object object) {
        try {
            return this.searchType.getClass().equals(((SearchTypePanel)object).getSearchType().getClass());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public HelpCtx getHelpCtx() {
        return this.searchType.getHelpCtx();
    }
}

