/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import mondrian.olap.Util;
import mondrian.util.ObjectPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectPoolTest
extends TestCase {
    public ObjectPoolTest() {
    }

    public ObjectPoolTest(String name) {
        super(name);
    }

    public void testString() throws Exception {
        int i;
        if (Util.PreJdk15) {
            return;
        }
        ObjectPool<String> strings = new ObjectPool<String>();
        int nos = 100000;
        String[] ss1 = ObjectPoolTest.genStringsArray(nos);
        for (int i2 = 0; i2 < nos; ++i2) {
            strings.add(ss1[i2]);
        }
        ObjectPoolTest.assertEquals((String)"size not equal", (int)nos, (int)strings.size());
        String[] ss2 = ObjectPoolTest.genStringsArray(nos);
        for (i = 0; i < nos; ++i) {
            String s = strings.add(ss2[i]);
            ObjectPoolTest.assertEquals((String)("string not equal: " + s), (String)s, (String)ss2[i]);
        }
        strings.clear();
        ObjectPoolTest.assertEquals((String)"size not equal", (int)0, (int)strings.size());
        nos = 25;
        ss1 = ObjectPoolTest.genStringsArray(nos);
        for (i = 0; i < nos; ++i) {
            strings.add(ss1[i]);
        }
        ObjectPoolTest.assertEquals((String)"size not equal", (int)nos, (int)strings.size());
        List<String> l = ObjectPoolTest.genStringsList(nos);
        Iterator it = strings.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            l.remove(s);
        }
        ObjectPoolTest.assertTrue((String)"list not empty", (boolean)l.isEmpty());
    }

    public void testKeyValue() throws Exception {
        int i;
        ObjectPool<KeyValue> op = new ObjectPool<KeyValue>();
        int nos = 100000;
        KeyValue[] kv1 = ObjectPoolTest.genKeyValueArray(nos);
        for (int i2 = 0; i2 < nos; ++i2) {
            op.add(kv1[i2]);
        }
        ObjectPoolTest.assertEquals((String)"size not equal", (int)nos, (int)op.size());
        KeyValue[] kv2 = ObjectPoolTest.genKeyValueArray(nos);
        for (i = 0; i < nos; ++i) {
            KeyValue kv = op.add(kv2[i]);
            ObjectPoolTest.assertEquals((String)("KeyValue not equal: " + kv), (Object)kv, (Object)kv2[i]);
            ObjectPoolTest.assertFalse((String)"same object", (kv == kv2[i] ? 1 : 0) != 0);
        }
        op.clear();
        ObjectPoolTest.assertEquals((String)"size not equal", (int)0, (int)op.size());
        nos = 25;
        kv1 = ObjectPoolTest.genKeyValueArray(nos);
        for (i = 0; i < nos; ++i) {
            op.add(kv1[i]);
        }
        ObjectPoolTest.assertEquals((String)"size not equal", (int)nos, (int)op.size());
        List<KeyValue> l = ObjectPoolTest.genKeyValueList(nos);
        Iterator it = op.iterator();
        while (it.hasNext()) {
            KeyValue kv = (KeyValue)it.next();
            l.remove(kv);
        }
        ObjectPoolTest.assertTrue((String)"list not empty", (boolean)l.isEmpty());
    }

    public void testLarge() {
        this.checkLargeMulti(300000, 0.01, 700000, 298477, 7068);
        this.checkLargeMulti(300000, 0.5, 700000, 236022, 275117);
        this.checkLargeMulti(300000, 0.999, 700000, 189850, 442618);
    }

    private void checkLargeMulti(int entryCount, double density, int retrieveCount, int expectedDistinct, int expectedHits) {
        this.checkLarge(true, true, entryCount, density, retrieveCount, expectedDistinct, expectedHits);
        this.checkLarge(false, true, entryCount, density, retrieveCount, expectedDistinct, expectedHits);
        this.checkLarge(false, true, entryCount, density, retrieveCount, expectedDistinct, expectedHits);
        this.checkLarge(false, false, entryCount, density, retrieveCount, expectedDistinct, expectedHits);
    }

    private void checkLarge(boolean usePool, boolean intKey, int entryCount, double density, int retrieveCount, int expectedDistinct, int expectedHits) {
        boolean print = false;
        long t1 = System.currentTimeMillis();
        assert (density > 0.0 && density <= 1.0);
        int space = (int)((double)entryCount / density);
        ObjectPool<Integer> objectPool = new ObjectPool<Integer>();
        HashSet<Integer> set = new HashSet<Integer>();
        Random random = new Random(1234L);
        int distinctCount = 0;
        String longString = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxyyyyyyyyyyyyyyy";
        for (int i = 0; i < entryCount; ++i) {
            Integer key;
            Integer n = key = intKey ? Integer.valueOf(random.nextInt(space)) : "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxyyyyyyyyyyyyyyy" + random.nextInt(space);
            if (usePool) {
                if (objectPool.add(key) == null) continue;
                ++distinctCount;
                continue;
            }
            if (!set.add(key)) continue;
            ++distinctCount;
        }
        long t2 = System.currentTimeMillis();
        int hitCount = 0;
        for (int i = 0; i < retrieveCount; ++i) {
            Integer key;
            Integer n = key = intKey ? Integer.valueOf(random.nextInt(space)) : "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxyyyyyyyyyyyyyyy" + random.nextInt(space);
            if (usePool) {
                if (!objectPool.contains(key)) continue;
                ++hitCount;
                continue;
            }
            if (!set.contains(key)) continue;
            ++hitCount;
        }
        long t3 = System.currentTimeMillis();
        if (usePool) {
            distinctCount = objectPool.size();
        } else {
            ObjectPoolTest.assertEquals((int)expectedDistinct, (int)set.size());
        }
        ObjectPoolTest.assertEquals((int)expectedDistinct, (int)distinctCount);
        ObjectPoolTest.assertEquals((int)expectedHits, (int)hitCount);
    }

    private static String[] genStringsArray(int nos) {
        List<String> l = ObjectPoolTest.genStringsList(nos);
        return l.toArray(new String[l.size()]);
    }

    private static List<String> genStringsList(int nos) {
        ArrayList<String> l = new ArrayList<String>(nos);
        for (int i = 0; i < nos; ++i) {
            l.add(Integer.valueOf(i).toString());
        }
        return l;
    }

    private static KeyValue[] genKeyValueArray(int nos) {
        List<KeyValue> l = ObjectPoolTest.genKeyValueList(nos);
        return l.toArray(new KeyValue[l.size()]);
    }

    private static List<KeyValue> genKeyValueList(int nos) {
        ArrayList<KeyValue> l = new ArrayList<KeyValue>(nos);
        for (int i = 0; i < nos; ++i) {
            l.add(new KeyValue(i, i));
        }
        return l;
    }

    static class KeyValue {
        long key;
        Object value;

        KeyValue(long key, Object value) {
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            return (int)(this.key ^ this.key >>> 32);
        }

        public boolean equals(Object o) {
            return o instanceof KeyValue ? ((KeyValue)o).key == this.key : false;
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

