/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.palette.actions.tools;

import com.jaspersoft.ireport.designer.editor.ExpObjectCellRenderer;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;

/**
 *
 * @author gtoffoli
 */
public class FieldPercentageDialog extends javax.swing.JDialog {

    private JasperDesign jasperDesign = null;
    private int dialogResult = JOptionPane.CANCEL_OPTION;

    /** Creates new form FieldPercentageDialog */
    public FieldPercentageDialog(java.awt.Frame parent) {
        super(parent, true);
        initComponents();
        setLocationRelativeTo(null);
        jComboBoxFields.setRenderer(new ExpObjectCellRenderer());

        setTitle(I18n.getString("FieldPercentageDialog.title")); // NOI18N
        jLabelField.setText(I18n.getString("FieldPercentageDialog.jLabelField.text")); // NOI18N
        jLabelResetType.setText(I18n.getString("FieldPercentageDialog.jLabelResetType.text")); // NOI18N
        jLabel1.setText(I18n.getString("FieldPercentageDialog.jLabel1.text")); // NOI18N
        jButtonOk.setText(I18n.getString("FieldPercentageDialog.jButtonOk.text")); // NOI18N
        jButtonCancel.setText(I18n.getString("FieldPercentageDialog.jButtonCancel.text")); // NOI18N

        pack();
    }

    public JRField getSelectedField()
    {
        return (JRField)jComboBoxFields.getSelectedItem();
    }

    public Byte getSelectedResetType()
    {
        Tag selectedTag = (Tag)jComboBoxResetType.getSelectedItem();
        if (selectedTag != null &&
            selectedTag.getValue() instanceof Byte) return (Byte)selectedTag.getValue();
        if (selectedTag != null &&
            selectedTag.getValue() instanceof JRGroup) return JRVariable.RESET_TYPE_GROUP;
        return null;
    }

    public JRGroup getSelectedGroup()
    {
        Tag selectedTag = (Tag)jComboBoxResetType.getSelectedItem();
        if (selectedTag != null &&
            selectedTag.getValue() instanceof JRGroup) return (JRGroup)selectedTag.getValue();
        return null;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabelField = new javax.swing.JLabel();
        jComboBoxFields = new javax.swing.JComboBox();
        jLabelResetType = new javax.swing.JLabel();
        jComboBoxResetType = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        jButtonOk = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Percentage");

        jLabelField.setText("Field");

        jLabelResetType.setText("Reset type");

        jLabel1.setText("<html>This tool is used to create a textfield to display the percentage of the total sum of a particular numeric field.");

        jButtonOk.setMnemonic('o');
        jButtonOk.setText("Ok");
        jButtonOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOkActionPerformed(evt);
            }
        });

        jButtonCancel.setMnemonic('c');
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 354, Short.MAX_VALUE)
                    .add(jComboBoxFields, 0, 354, Short.MAX_VALUE)
                    .add(jLabelResetType, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 354, Short.MAX_VALUE)
                    .add(jComboBoxResetType, 0, 354, Short.MAX_VALUE)
                    .add(jSeparator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 354, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(jButtonOk)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jButtonCancel))
                    .add(jLabelField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 354, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 37, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(11, 11, 11)
                .add(jLabelField)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jComboBoxFields, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(jLabelResetType)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jComboBoxResetType, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jButtonCancel)
                    .add(jButtonOk))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed


        dialogResult = JOptionPane.CANCEL_OPTION;
        setVisible(false);
        dispose();

    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOkActionPerformed

        dialogResult = JOptionPane.OK_OPTION;
        setVisible(false);
        dispose();
    }//GEN-LAST:event_jButtonOkActionPerformed



    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOk;
    private javax.swing.JComboBox jComboBoxFields;
    private javax.swing.JComboBox jComboBoxResetType;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabelField;
    private javax.swing.JLabel jLabelResetType;
    private javax.swing.JSeparator jSeparator1;
    // End of variables declaration//GEN-END:variables

    /**
     * @return the jasperDesign
     */
    public JasperDesign getJasperDesign() {
        return jasperDesign;
    }

    /**
     * @param jasperDesign the jasperDesign to set
     */
    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;

        jComboBoxFields.removeAllItems();

        // Load all the numeric fields...
        JRField[] fields = jasperDesign.getFields();
        for (int i=0; i<fields.length; ++i)
        {
            if ( Misc.isNumeric(fields[i].getValueClassName()))
            {
                jComboBoxFields.addItem(fields[i]);
            }
        }

        jButtonOk.setEnabled(jComboBoxFields.getItemCount() > 0);

        if (jComboBoxFields.getItemCount() > 0)
        {
            jComboBoxFields.setSelectedIndex(0);
        }

        jComboBoxResetType.removeAllItems();

        jComboBoxResetType.addItem(new Tag(new Byte(JRDesignVariable.RESET_TYPE_REPORT), I18n.getString("VariableNode.Property.Report")));
        jComboBoxResetType.addItem(new Tag(new Byte(JRDesignVariable.RESET_TYPE_COLUMN), I18n.getString("VariableNode.Property.Column")));

        // for each group...
        JRGroup[] groups = jasperDesign.getGroups();
        for (int i=0; i<groups.length; ++i)
        {
            jComboBoxResetType.addItem(new Tag(groups[i], I18n.getString("FieldPercentageDialog.group.label",groups[i].getName())));
        }

        jComboBoxResetType.addItem(new Tag(new Byte(JRDesignVariable.RESET_TYPE_PAGE), I18n.getString("VariableNode.Property.Page")));

        jComboBoxResetType.setSelectedIndex(0);

    }

    /**
     * @return the dialogResult
     */
    public int getDialogResult() {
        return dialogResult;
    }

}
