/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.RolapCube;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapCubeTest
extends FoodMartTestCase {
    public void testProcessFormatStringAttributeToIgnoreNullFormatString() {
        RolapCube cube = (RolapCube)this.getConnection().getSchema().lookupCube("Sales", false);
        StringBuilder builder = new StringBuilder();
        cube.processFormatStringAttribute(new MondrianDef.CalculatedMember(), builder);
        RolapCubeTest.assertEquals((int)0, (int)builder.length());
    }

    public void testProcessFormatStringAttribute() {
        String format;
        RolapCube cube = (RolapCube)this.getConnection().getSchema().lookupCube("Sales", false);
        StringBuilder builder = new StringBuilder();
        MondrianDef.CalculatedMember xmlCalcMember = new MondrianDef.CalculatedMember();
        xmlCalcMember.formatString = format = "FORMAT";
        cube.processFormatStringAttribute(xmlCalcMember, builder);
        RolapCubeTest.assertEquals((String)("," + Util.nl + "FORMAT_STRING = \"" + format + "\""), (String)builder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetCalculatedMembersWithNoRole() {
        String[] expectedCalculatedMembers = new String[]{"[Measures].[Profit]", "[Measures].[Average Warehouse Sale]", "[Measures].[Profit Growth]", "[Measures].[Profit Per Unit Shipped]"};
        Connection connection = this.getTestContext().getConnection();
        try {
            Cube warehouseAndSalesCube = this.cubeByName(connection, "Warehouse and Sales");
            SchemaReader schemaReader = warehouseAndSalesCube.getSchemaReader(null);
            List<Member> calculatedMembers = schemaReader.getCalculatedMembers();
            RolapCubeTest.assertEquals((int)expectedCalculatedMembers.length, (int)calculatedMembers.size());
            this.assertCalculatedMemberExists(expectedCalculatedMembers, calculatedMembers);
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetCalculatedMembersForCaliforniaManager() {
        String[] expectedCalculatedMembers = new String[]{"[Measures].[Profit]", "[Measures].[Profit last Period]", "[Measures].[Profit Growth]"};
        Connection connection = this.getTestContext().withRole("California manager").getConnection();
        try {
            Cube salesCube = this.cubeByName(connection, "Sales");
            SchemaReader schemaReader = salesCube.getSchemaReader(connection.getRole());
            List<Member> calculatedMembers = schemaReader.getCalculatedMembers();
            RolapCubeTest.assertEquals((int)expectedCalculatedMembers.length, (int)calculatedMembers.size());
            this.assertCalculatedMemberExists(expectedCalculatedMembers, calculatedMembers);
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetCalculatedMembersReturnsOnlyAccessibleMembers() {
        String[] expectedCalculatedMembers = new String[]{"[Measures].[Profit]", "[Measures].[Profit last Period]", "[Measures].[Profit Growth]", "[Product].[~Missing]"};
        TestContext testContext = this.createTestContextWithAdditionalMembersAndARole();
        Connection connection = testContext.getConnection();
        try {
            Cube salesCube = this.cubeByName(connection, "Sales");
            SchemaReader schemaReader = salesCube.getSchemaReader(connection.getRole());
            List<Member> calculatedMembers = schemaReader.getCalculatedMembers();
            RolapCubeTest.assertEquals((int)expectedCalculatedMembers.length, (int)calculatedMembers.size());
            this.assertCalculatedMemberExists(expectedCalculatedMembers, calculatedMembers);
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetCalculatedMembersReturnsOnlyAccessibleMembersForHierarchy() {
        String[] expectedCalculatedMembersFromProduct = new String[]{"[Product].[~Missing]"};
        TestContext testContext = this.createTestContextWithAdditionalMembersAndARole();
        Connection connection = testContext.getConnection();
        try {
            Cube salesCube = this.cubeByName(connection, "Sales");
            SchemaReader schemaReader = salesCube.getSchemaReader(connection.getRole());
            List<Member> calculatedMembers = schemaReader.getCalculatedMembers(this.getDimensionWithName("Product", salesCube.getDimensions()).getHierarchy());
            RolapCubeTest.assertEquals((int)expectedCalculatedMembersFromProduct.length, (int)calculatedMembers.size());
            this.assertCalculatedMemberExists(expectedCalculatedMembersFromProduct, calculatedMembers);
            calculatedMembers = schemaReader.getCalculatedMembers(this.getDimensionWithName("Gender", salesCube.getDimensions()).getHierarchy());
            RolapCubeTest.assertEquals((int)0, (int)calculatedMembers.size());
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetCalculatedMembersReturnsOnlyAccessibleMembersForLevel() {
        String[] expectedCalculatedMembersFromProduct = new String[]{"[Product].[~Missing]"};
        TestContext testContext = this.createTestContextWithAdditionalMembersAndARole();
        Connection connection = testContext.getConnection();
        try {
            Cube salesCube = this.cubeByName(connection, "Sales");
            SchemaReader schemaReader = salesCube.getSchemaReader(connection.getRole());
            List<Member> calculatedMembers = schemaReader.getCalculatedMembers(this.getDimensionWithName("Product", salesCube.getDimensions()).getHierarchy().getLevels()[0]);
            RolapCubeTest.assertEquals((int)expectedCalculatedMembersFromProduct.length, (int)calculatedMembers.size());
            this.assertCalculatedMemberExists(expectedCalculatedMembersFromProduct, calculatedMembers);
            calculatedMembers = schemaReader.getCalculatedMembers(this.getDimensionWithName("Gender", salesCube.getDimensions()).getHierarchy().getLevels()[0]);
            RolapCubeTest.assertEquals((int)0, (int)calculatedMembers.size());
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonJoiningDimensions() {
        TestContext testContext = this.getTestContext();
        Connection connection = testContext.getConnection();
        try {
            RolapCube salesCube = (RolapCube)this.cubeByName(connection, "Sales");
            RolapCube warehouseAndSalesCube = (RolapCube)this.cubeByName(connection, "Warehouse and Sales");
            SchemaReader readerWarehouseAndSales = warehouseAndSalesCube.getSchemaReader();
            ArrayList<Member> members = new ArrayList<Member>();
            List<Member> warehouseMembers = this.warehouseMembersCanadaMexicoUsa(readerWarehouseAndSales);
            Dimension warehouseDim = warehouseMembers.get(0).getDimension();
            members.addAll(warehouseMembers);
            List<Member> storeMembers = this.storeMembersCAAndOR(readerWarehouseAndSales);
            Dimension storeDim = storeMembers.get(0).getDimension();
            members.addAll(storeMembers);
            Set<Dimension> nonJoiningDims = salesCube.nonJoiningDimensions(members.toArray(new Member[0]));
            RolapCubeTest.assertFalse((boolean)nonJoiningDims.contains(storeDim));
            RolapCubeTest.assertTrue((boolean)nonJoiningDims.contains(warehouseDim));
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRolapCubeDimensionEquality() {
        TestContext testContext = this.getTestContext();
        Connection connection1 = testContext.getConnection();
        Connection connection2 = TestContext.create(null).getConnection();
        try {
            RolapCube salesCube1 = (RolapCube)this.cubeByName(connection1, "Sales");
            SchemaReader readerSales1 = salesCube1.getSchemaReader();
            List<Member> storeMembersSales = this.storeMembersCAAndOR(readerSales1);
            Dimension storeDim1 = storeMembersSales.get(0).getDimension();
            RolapCubeTest.assertEquals((Object)storeDim1, (Object)storeDim1);
            RolapCube salesCube2 = (RolapCube)this.cubeByName(connection2, "Sales");
            SchemaReader readerSales2 = salesCube2.getSchemaReader();
            List<Member> storeMembersSales2 = this.storeMembersCAAndOR(readerSales2);
            Dimension storeDim2 = storeMembersSales2.get(0).getDimension();
            RolapCubeTest.assertEquals((Object)storeDim1, (Object)storeDim2);
            RolapCube warehouseAndSalesCube = (RolapCube)this.cubeByName(connection1, "Warehouse and Sales");
            SchemaReader readerWarehouseAndSales = warehouseAndSalesCube.getSchemaReader();
            List<Member> storeMembersWarehouseAndSales = this.storeMembersCAAndOR(readerWarehouseAndSales);
            Dimension storeDim3 = storeMembersWarehouseAndSales.get(0).getDimension();
            RolapCubeTest.assertFalse((boolean)storeDim1.equals(storeDim3));
            List<Member> warehouseMembers = this.warehouseMembersCanadaMexicoUsa(readerWarehouseAndSales);
            Dimension warehouseDim = warehouseMembers.get(0).getDimension();
            RolapCubeTest.assertFalse((boolean)storeDim3.equals(warehouseDim));
        }
        finally {
            connection1.close();
            connection2.close();
        }
    }

    private TestContext createTestContextWithAdditionalMembersAndARole() {
        String nonAccessibleMember = "  <CalculatedMember name=\"~Missing\" dimension=\"Gender\">\n    <Formula>100</Formula>\n  </CalculatedMember>\n";
        String accessibleMember = "  <CalculatedMember name=\"~Missing\" dimension=\"Product\">\n    <Formula>100</Formula>\n  </CalculatedMember>\n";
        TestContext testContext = TestContext.createSubstitutingCube("Sales", null, nonAccessibleMember + accessibleMember);
        return testContext.withRole("California manager");
    }

    private void assertCalculatedMemberExists(String[] expectedCalculatedMembers, List<Member> calculatedMembers) {
        List<String> expectedCalculatedMemberNames = Arrays.asList(expectedCalculatedMembers);
        for (Member calculatedMember : calculatedMembers) {
            String calculatedMemberName = calculatedMember.getUniqueName();
            RolapCubeTest.assertTrue((String)("Calculated member name not found: " + calculatedMemberName), (boolean)expectedCalculatedMemberNames.contains(calculatedMemberName));
        }
    }
}

