/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.Column;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.ColumnVisitor;
import net.sf.jasperreports.components.table.CompiledCell;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardGroupCell;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnFactory
implements ColumnVisitor<BaseColumn> {
    private final JRBaseObjectFactory factory;

    public ColumnFactory(JRBaseObjectFactory factory) {
        this.factory = factory;
    }

    public List<BaseColumn> createColumns(List<BaseColumn> columns) {
        ArrayList<BaseColumn> createdCols = new ArrayList<BaseColumn>(columns.size());
        for (BaseColumn tableColumn : columns) {
            BaseColumn column = tableColumn.visitColumn(this);
            createdCols.add(column);
        }
        return createdCols;
    }

    public Cell createCell(Cell cell) {
        CompiledCell newCell = cell == null ? null : new CompiledCell(cell, this.factory);
        return newCell;
    }

    public List<GroupCell> createGroupCells(List<GroupCell> cells) {
        ArrayList<StandardGroupCell> newCells;
        if (cells == null) {
            newCells = null;
        } else {
            newCells = new ArrayList<StandardGroupCell>(cells.size());
            for (GroupCell groupCell : cells) {
                StandardGroupCell newCell = new StandardGroupCell(groupCell, this);
                newCells.add(newCell);
            }
        }
        return newCells;
    }

    @Override
    public BaseColumn visitColumn(Column column) {
        return new StandardColumn(column, this);
    }

    @Override
    public BaseColumn visitColumnGroup(ColumnGroup columnGroup) {
        return new StandardColumnGroup(columnGroup, this);
    }

    public JRBaseObjectFactory getBaseObjectFactory() {
        return this.factory;
    }
}

