/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.xmlss;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import net.sf.jasperreports.engine.JRAlignment;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.export.xmlss.XmlssBorderStyle;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class XmlssCellStyle
extends XmlssBorderStyle {
    private static final String ALIGNMENT_LEFT = "Left";
    private static final String ALIGNMENT_RIGHT = "Right";
    private static final String ALIGNMENT_CENTER = "Center";
    private static final String ALIGNMENT_TOP = "Top";
    private static final String ALIGNMENT_BOTTOM = "Bottom";
    private static final String READING_ORDER_LTR = "LeftToRight";
    private static final String READING_ORDER_RTL = "RightToLeft";
    private static final String ROTATE_NONE = "0";
    private static final String ROTATE_LEFT = "90";
    private static final String ROTATE_RIGHT = "-90";
    private static final String STYLE_AUTOMATIC = "Automatic";
    private static final String STYLE_NONE = "None";
    private static final String UNDERLINE_STYLE_SINGLE = "Single";
    private final String id;
    private String backcolor = "Automatic";
    private String horizontalAlignment = "Left";
    private String verticalAlignment = "Top";
    private String readingOrder = "LeftToRight";
    private String rotate = "0";
    private String shrinkToFit;
    private String wrapText = "1";
    private JRStyle style;
    private String verticalPosition = "None";
    private String pattern;
    private String forecolor = "Automatic";
    private JRFont defaultFont;
    private String excelFontName;

    public XmlssCellStyle(Writer styleWriter, JRPrintElement element, Color cellBackground, String pattern, boolean isShrinkToFit, JRFont defaultFont, Map fontMap) {
        super(styleWriter, element);
        JRAlignment alignment;
        this.style = element.getStyle() != null ? element.getStyle() : element.getDefaultStyleProvider().getDefaultStyle();
        this.defaultFont = defaultFont;
        this.pattern = pattern;
        this.shrinkToFit = String.valueOf(this.getBitValue(isShrinkToFit));
        if (ModeEnum.OPAQUE == element.getModeValue()) {
            if (element.getBackcolor() != null) {
                this.backcolor = "#" + JRColorUtil.getColorHexa(element.getBackcolor());
            } else if (this.style.getBackcolor() != null) {
                this.backcolor = "#" + JRColorUtil.getColorHexa(this.style.getBackcolor());
            }
        } else if (cellBackground != null) {
            this.backcolor = "#" + JRColorUtil.getColorHexa(cellBackground);
        }
        if (element.getForecolor() != null) {
            this.forecolor = "#" + JRColorUtil.getColorHexa(element.getForecolor());
        } else if (this.style.getForecolor() != null) {
            this.forecolor = "#" + JRColorUtil.getColorHexa(this.style.getForecolor());
        }
        RotationEnum rotation = element instanceof JRPrintText ? ((JRPrintText)element).getRotationValue() : RotationEnum.NONE;
        this.rotate = this.getRotation(rotation);
        if (element instanceof JRPrintText && ((JRPrintText)element).getRunDirectionValue() == RunDirectionEnum.RTL) {
            this.readingOrder = READING_ORDER_RTL;
        }
        JRAlignment jRAlignment = alignment = element instanceof JRAlignment ? (JRAlignment)((Object)element) : null;
        if (alignment != null) {
            this.horizontalAlignment = XmlssCellStyle.getHorizontalAlignment(alignment.getHorizontalAlignmentValue(), alignment.getVerticalAlignmentValue(), rotation);
            this.verticalAlignment = XmlssCellStyle.getVerticalAlignment(alignment.getHorizontalAlignmentValue(), alignment.getVerticalAlignmentValue(), rotation);
        }
        if (this.style != null) {
            String fontName = this.style.getFontName();
            this.excelFontName = fontMap != null && fontMap.containsKey(fontName) ? (String)fontMap.get(fontName) : fontName;
            this.id = this.horizontalAlignment + "|" + this.verticalAlignment + "|" + this.readingOrder + "|" + this.rotate + "|" + this.shrinkToFit + "|" + super.getId() + "|" + this.excelFontName + "|" + this.style.getFontSize() + "|" + this.forecolor + "|" + this.style.isItalic() + "|" + this.style.isBold() + "|" + this.style.isStrikeThrough() + "|" + this.style.isUnderline() + "|" + this.verticalPosition + "|" + this.backcolor + "|" + this.pattern;
        } else {
            String fontName = defaultFont.getFontName();
            this.excelFontName = fontMap != null && fontMap.containsKey(fontName) ? (String)fontMap.get(fontName) : fontName;
            this.id = this.horizontalAlignment + "|" + this.verticalAlignment + "|" + this.readingOrder + "|" + this.rotate + "|" + this.shrinkToFit + "|" + super.getId() + "|" + this.excelFontName + "|" + defaultFont.getFontSize() + "|" + this.forecolor + "|" + defaultFont.isItalic() + "|" + defaultFont.isBold() + "|" + defaultFont.isStrikeThrough() + "|" + defaultFont.isUnderline() + "|" + this.verticalPosition + "|" + this.backcolor + "|" + this.pattern;
        }
    }

    public String getId() {
        return this.id;
    }

    public void write(String cellStyleName) throws IOException {
        this.styleWriter.write("<ss:Style ss:ID=\"");
        this.styleWriter.write(cellStyleName);
        this.styleWriter.write("\">\n");
        this.styleWriter.write(" <ss:Alignment");
        this.styleWriter.write(" ss:Horizontal=\"" + this.horizontalAlignment + "\"");
        this.styleWriter.write(" ss:Vertical=\"" + this.verticalAlignment + "\"");
        this.styleWriter.write(" ss:ReadingOrder=\"" + this.readingOrder + "\"");
        this.styleWriter.write(" ss:Rotate=\"" + this.rotate + "\"");
        this.styleWriter.write(" ss:ShrinkToFit=\"" + this.shrinkToFit + "\"");
        this.styleWriter.write(" ss:WrapText=\"" + this.wrapText + "\"");
        this.styleWriter.write("/>\n");
        this.styleWriter.write(" <ss:Borders>");
        this.writeBorder(0);
        this.writeBorder(1);
        this.writeBorder(2);
        this.writeBorder(3);
        this.styleWriter.write(" </ss:Borders>\n");
        this.styleWriter.write(" <ss:Font");
        this.styleWriter.write(" ss:FontName=\"" + this.excelFontName + "\"");
        if (this.style != null) {
            if (this.style.getFontSize() != null) {
                this.styleWriter.write(" ss:Size=\"" + this.style.getFontSize() + "\"");
            }
            if (this.style.isBold() != null) {
                this.styleWriter.write(" ss:Bold=\"" + this.getBitValue(this.style.isBold()) + "\"");
            }
            if (this.style.isItalic() != null) {
                this.styleWriter.write(" ss:Italic=\"" + this.getBitValue(this.style.isItalic()) + "\"");
            }
            if (this.style.isStrikeThrough() != null) {
                this.styleWriter.write(" ss:StrikeThrough=\"" + this.getBitValue(this.style.isStrikeThrough()) + "\"");
            }
            if (this.style.isUnderline() != null) {
                this.styleWriter.write(" ss:Underline=\"" + this.getUnderlineStyle(this.style.isUnderline()) + "\"");
            }
        } else if (this.defaultFont != null) {
            this.styleWriter.write(" ss:Size=\"" + this.defaultFont.getFontSize() + "\"");
            this.styleWriter.write(" ss:Bold=\"" + this.getBitValue(this.defaultFont.isBold()) + "\"");
            this.styleWriter.write(" ss:Italic=\"" + this.getBitValue(this.defaultFont.isItalic()) + "\"");
            this.styleWriter.write(" ss:StrikeThrough=\"" + this.getBitValue(this.defaultFont.isStrikeThrough()) + "\"");
            this.styleWriter.write(" ss:Underline=\"" + this.getUnderlineStyle(this.defaultFont.isUnderline()) + "\"");
        }
        this.styleWriter.write(" ss:Color=\"" + this.forecolor + "\"");
        this.styleWriter.write("/>\n");
        this.styleWriter.write(" <ss:Interior");
        this.styleWriter.write(" ss:Color=\"" + this.backcolor + "\"");
        this.styleWriter.write(" ss:Pattern=\"Solid\"");
        this.styleWriter.write("/>\n");
        this.styleWriter.write(" <ss:NumberFormat");
        this.styleWriter.write(" ss:Format=\"" + this.pattern + "\"");
        this.styleWriter.write("/>\n");
        this.styleWriter.write(" <ss:Protection/>\n");
        this.styleWriter.write("</ss:Style>\n");
    }

    public static String getVerticalAlignment(HorizontalAlignEnum horizontalAlignment, VerticalAlignEnum verticalAlignment, RotationEnum rotation) {
        switch (rotation) {
            case LEFT: {
                switch (horizontalAlignment) {
                    case RIGHT: {
                        return ALIGNMENT_TOP;
                    }
                    case CENTER: {
                        return ALIGNMENT_CENTER;
                    }
                }
                return ALIGNMENT_BOTTOM;
            }
            case RIGHT: {
                switch (horizontalAlignment) {
                    case RIGHT: {
                        return ALIGNMENT_BOTTOM;
                    }
                    case CENTER: {
                        return ALIGNMENT_CENTER;
                    }
                }
                return ALIGNMENT_TOP;
            }
        }
        switch (verticalAlignment) {
            case BOTTOM: {
                return ALIGNMENT_BOTTOM;
            }
            case MIDDLE: {
                return ALIGNMENT_CENTER;
            }
        }
        return ALIGNMENT_TOP;
    }

    public static String getHorizontalAlignment(HorizontalAlignEnum horizontalAlignment, VerticalAlignEnum verticalAlignment, RotationEnum rotation) {
        switch (rotation) {
            case LEFT: {
                switch (verticalAlignment) {
                    case BOTTOM: {
                        return ALIGNMENT_RIGHT;
                    }
                    case MIDDLE: {
                        return ALIGNMENT_CENTER;
                    }
                }
                return ALIGNMENT_LEFT;
            }
            case RIGHT: {
                switch (verticalAlignment) {
                    case BOTTOM: {
                        return ALIGNMENT_LEFT;
                    }
                    case MIDDLE: {
                        return ALIGNMENT_CENTER;
                    }
                }
                return ALIGNMENT_RIGHT;
            }
        }
        switch (horizontalAlignment) {
            case RIGHT: {
                return ALIGNMENT_RIGHT;
            }
            case CENTER: {
                return ALIGNMENT_CENTER;
            }
        }
        return ALIGNMENT_LEFT;
    }

    private String getRotation(RotationEnum rotation) {
        switch (rotation) {
            case LEFT: {
                return ROTATE_LEFT;
            }
            case RIGHT: {
                return ROTATE_RIGHT;
            }
        }
        return ROTATE_NONE;
    }

    private byte getBitValue(boolean isTrue) {
        return isTrue ? (byte)1 : 0;
    }

    private String getUnderlineStyle(boolean isUnderline) {
        if (isUnderline) {
            return UNDERLINE_STYLE_SINGLE;
        }
        return STYLE_NONE;
    }
}

