/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.menu;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;

/**
 *
 * @author  gtoffoli
 */
public class DatasourceSelectorPanel extends javax.swing.JPanel implements PropertyChangeListener {
    
    private boolean init = false;
    
    public synchronized boolean isInit() { return init; }
    
    /** Returns the old value of init;
     */
    public synchronized boolean setInit(boolean b) { boolean oldB = init; init = b; return oldB; }
    
    
    /** Creates new form DatasourceSelectorPanel */
    public DatasourceSelectorPanel() {
        initComponents();
        IReportManager.getInstance().getPropertyChangeSupport().addPropertyChangeListener(this);
        updateConnections();
    }
    
    
     public void propertyChange(PropertyChangeEvent evt) {
         
         boolean oldB = setInit(true);
         try {
             if (evt.getPropertyName()== null) return;
             if (evt.getPropertyName().equals(IReportManager.PROPERTY_CONNECTIONS))
             {
                 updateConnections();
             }
             else if (evt.getPropertyName().equals(IReportManager.PROPERTY_DEFAULT_CONNECTION))
             {
                 jComboBox1.setSelectedItem(evt.getNewValue());
             }
         } finally {
             setInit(oldB);
         }
     }
     
     private void updateConnections()
     {
         boolean oldB = setInit(true);
         try {
             jComboBox1.removeAllItems();
             jComboBox1.setModel( new DefaultComboBoxModel( IReportManager.getInstance().getConnections().toArray()));
             jComboBox1.updateUI();
             jComboBox1.setSelectedItem(  IReportManager.getInstance().getDefaultConnection() );
             
         } finally {
             setInit(oldB);
         }
     }
     
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jComboBox1 = new javax.swing.JComboBox();

        setLayout(new java.awt.GridBagLayout());

        jComboBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(jComboBox1, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jComboBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox1ActionPerformed
       
        boolean oldB = setInit(true);
         try {
             IReportConnection con = (IReportConnection)jComboBox1.getSelectedItem();
             if (con == null) return;
             IReportManager.getInstance().setDefaultConnection(con);
             IReportManager.getInstance().saveiReportConfiguration();
         } finally {
             setInit(oldB);
         }
    }//GEN-LAST:event_jComboBox1ActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jComboBox1;
    // End of variables declaration//GEN-END:variables
    
}
