/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.TemplateReferenceChildren;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.sheet.properties.ExpressionProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.ErrorManager;
import org.openide.actions.DeleteAction;
import org.openide.actions.RenameAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class TemplateReferenceNode
extends AbstractNode
implements PropertyChangeListener {
    private JasperDesign jd;
    private JRDesignReportTemplate template = null;

    public TemplateReferenceNode(JasperDesign jd, JRDesignReportTemplate template, Lookup doLkp) {
        super((Children)new TemplateReferenceChildren(jd, template, doLkp), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, template})}));
        this.jd = jd;
        this.template = template;
        this.init();
        template.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public String getName() {
        return Misc.getExpressionText(this.template.getSourceExpression());
    }

    public String getDisplayName() {
        String fname;
        block4: {
            fname = "";
            try {
                fname = Misc.getExpressionText(this.template.getSourceExpression());
                File f = new File(fname);
                fname = f.getName();
                if (fname.startsWith("\"")) {
                    fname = fname.substring(1);
                }
                if (fname.endsWith("\"")) {
                    fname = fname.substring(0, fname.length() - 1);
                }
            }
            catch (Exception ex) {
                fname = "" + Misc.getExpressionText(this.template.getSourceExpression());
                if (fname.length() <= 20) break block4;
                fname = fname.substring(0, 20) + "...";
            }
        }
        return "Template (" + fname + ")";
    }

    private void init() {
        super.setName(Misc.getExpressionText(this.template.getSourceExpression()));
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/jasperreports_jrtx.png");
    }

    public void destroy() throws IOException {
        this.jd.removeTemplate((JRReportTemplate)this.template);
        IReportManager.getInstance().notifyReportChange();
        super.destroy();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new SourceExpressionProperty(this.template, this.jd));
        set.put((Node.Property)new SourceExpressionClassNameProperty(this.template));
        sheet.put(set);
        return sheet;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return true;
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)4);
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)1);
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(RenameAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        return tras;
    }

    public IllegalArgumentException annotateException(String msg) {
        IllegalArgumentException iae = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
        return iae;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("sourceExpression")) {
            super.setName(Misc.getExpressionText(this.template.getSourceExpression()));
            super.fireNameChange(null, super.getName());
            super.fireDisplayNameChange(null, this.getDisplayName());
        }
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public JRReportTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JRDesignReportTemplate template) {
        this.template = template;
    }

    public static final class SourceExpressionClassNameProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignReportTemplate template;
        PropertyEditor editor = null;

        public SourceExpressionClassNameProperty(JRDesignReportTemplate template) {
            super("valueClassName", String.class, I18n.getString("Expression_Class"), I18n.getString("Expression_Class"));
            this.template = template;
            this.setValue("canEditAsText", true);
            this.setValue("oneline", true);
            this.setValue("suppressCustomEditor", false);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (this.template.getSourceExpression() == null) {
                return "java.lang.String";
            }
            if (this.template.getSourceExpression().getValueClassName() == null) {
                return "java.lang.String";
            }
            return this.template.getSourceExpression().getValueClassName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            JRDesignExpression oldExp = (JRDesignExpression)this.template.getSourceExpression();
            JRDesignExpression newExp = null;
            String newVal = val != null ? val + "" : "";
            if ((newVal = newVal.trim()).equals("")) {
                newVal = null;
            }
            newExp = new JRDesignExpression();
            newExp.setText(oldExp != null ? oldExp.getText() : null);
            newExp.setValueClassName(newVal);
            this.template.setSourceExpression((JRExpression)newExp);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.template, "SourceExpression", JRExpression.class, oldExp, newExp);
            IReportManager.getInstance().addUndoableEdit(urob);
        }

        public boolean isDefaultValue() {
            return this.template.getSourceExpression() == null || this.template.getSourceExpression().getValueClassName() == null || this.template.getSourceExpression().getValueClassName().equals("java.lang.String");
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
            this.editor.setValue("java.lang.String");
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> classes = new ArrayList<Tag>();
                classes.add(new Tag("java.lang.String"));
                classes.add(new Tag("java.io.File"));
                classes.add(new Tag("java.net.URL"));
                classes.add(new Tag("java.io.InputStream"));
                classes.add(new Tag("net.sf.jasperreports.engine.JRTemplate"));
                this.editor = new ComboBoxPropertyEditor(false, classes);
            }
            return this.editor;
        }
    }

    public static final class SourceExpressionProperty
    extends ExpressionProperty {
        private JRDesignReportTemplate template = null;
        private JasperDesign jd = null;

        public SourceExpressionProperty(JRDesignReportTemplate template, JasperDesign jd) {
            super((Object)template, jd.getMainDesignDataset());
            this.setName("sourceExpression");
            this.setDisplayName("Source Expression");
            this.template = template;
            this.jd = jd;
        }

        public String getDefaultExpressionClassName() {
            return "java.lang.String";
        }

        public JRDesignExpression getExpression() {
            return (JRDesignExpression)this.template.getSourceExpression();
        }

        public void setExpression(JRDesignExpression expression) {
            this.template.setSourceExpression((JRExpression)expression);
        }
    }
}

