/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.templates;

import com.jaspersoft.ireport.designer.templates.TemplateCategory;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.ImageIcon;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class TemplateDescriptor {
    private TemplateCategory category = new TemplateCategory();
    private String displayName;
    private ImageIcon image;
    private long timestamp = 0L;
    private File file;
    private Dimension pageSize = null;

    public ImageIcon getPreviewIcon() {
        String fname;
        String filePath = this.getFile().getPath();
        String[] extensions = new String[]{".png", ".gif", ".jpg", ".jpeg"};
        File f = null;
        for (int i = 0; i < extensions.length && !(f = new File(fname = Misc.changeFileExtension(filePath, ".png"))).exists(); ++i) {
            f = null;
        }
        if (f != null && (this.image == null || this.timestamp < f.lastModified())) {
            this.image = new ImageIcon(f.getPath());
            this.timestamp = f.lastModified();
        } else if (this.image == null && this.getPageSize() != null) {
            BufferedImage img = new BufferedImage(this.getPageSize().width, this.getPageSize().height, 2);
            Graphics2D gfx = img.createGraphics();
            GradientPaint gradient = new GradientPaint(0.0f, this.getPageSize().height, new Color(232, 232, 232, 232), this.getPageSize().width, 0.0f, Color.WHITE);
            gfx.setPaint(gradient);
            gfx.fillRect(0, 0, this.getPageSize().width, this.getPageSize().height);
            gfx.setFont(new Font("SandSerif", 0, this.getPageSize().height / 3));
            FontMetrics fm = gfx.getFontMetrics();
            gfx.setColor(Color.DARK_GRAY);
            gfx.drawRect(0, 0, this.getPageSize().width - 1, this.getPageSize().height - 1);
            Rectangle2D rect = fm.getStringBounds("?", gfx);
            gfx.drawString("?", (int)(((double)this.getPageSize().width - rect.getWidth()) / 2.0), (int)((double)(this.getPageSize().height / 3) + ((double)this.getPageSize().height - rect.getHeight()) / 2.0));
            this.image = new ImageIcon(img);
        }
        return this.image;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setCategory(TemplateCategory cat) {
        this.category = cat;
    }

    public TemplateCategory getCategory() {
        return this.category;
    }

    public FileObject getFileObject() {
        if (this.getFile().exists()) {
            return FileUtil.toFileObject((File)this.getFile());
        }
        return null;
    }

    public Dimension getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Dimension pageSize) {
        this.pageSize = pageSize;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TemplateDescriptor) {
            return ((TemplateDescriptor)obj).getFile().equals(this.getFile());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.displayName != null ? this.displayName.hashCode() : 0);
        hash = 79 * hash + (this.file != null ? this.file.hashCode() : 0);
        return hash;
    }
}

