/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.netbeans.modules.editor.settings.storage.MimeTypesTracker;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProfilesTracker {
    public static final String PROP_PROFILES = "profiles";
    private static final Map<String, Map<StorageDescription, ProfilesTracker>> settingProfiles = new HashMap<String, Map<StorageDescription, ProfilesTracker>>();
    private static final Logger LOG = Logger.getLogger(ProfilesTracker.class.getName());
    private final SettingsType.Locator locator;
    private final MimeTypesTracker mimeTypes;
    private final FileSystem systemFileSystem;
    private final Listener listener;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final String LOCK = new String("ProfilesTracker.LOCK");
    private Map<String, ProfileDescription> profiles = Collections.emptyMap();
    private Map<String, ProfileDescription> profilesByDisplayName = Collections.emptyMap();
    private final RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

        public void run() {
            ProfilesTracker.this.rebuild();
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfilesTracker get(String string, String string2) {
        assert (string != null) : "The parameter settingsTypeId must not be null";
        assert (string2 != null) : "The parameter basePath must not be null";
        StorageDescription storageDescription = SettingsType.find(string);
        assert (storageDescription != null) : "Invalid editor settings type id: '" + string + "'";
        Map<String, Map<StorageDescription, ProfilesTracker>> map = settingProfiles;
        synchronized (map) {
            ProfilesTracker profilesTracker;
            Map<StorageDescription, ProfilesTracker> map2 = settingProfiles.get(string2);
            if (map2 == null) {
                map2 = new WeakHashMap<StorageDescription, ProfilesTracker>();
                settingProfiles.put(string2, map2);
            }
            if ((profilesTracker = map2.get(storageDescription)) == null) {
                SettingsType.Locator locator = SettingsType.getLocator(storageDescription);
                assert (locator.isUsingProfiles()) : "No need to track profiles for settings that do not use profiles.";
                profilesTracker = new ProfilesTracker(locator, MimeTypesTracker.get(null, string2));
                map2.put(storageDescription, profilesTracker);
            }
            return profilesTracker;
        }
    }

    ProfilesTracker(SettingsType.Locator locator, MimeTypesTracker mimeTypesTracker) {
        this.locator = locator;
        this.mimeTypes = mimeTypesTracker;
        this.rebuild();
        this.listener = new Listener();
        this.systemFileSystem = Repository.getDefault().getDefaultFileSystem();
        this.systemFileSystem.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.listener, (Object)this.systemFileSystem));
        this.mimeTypes.addPropertyChangeListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getProfilesDisplayNames() {
        String string = this.LOCK;
        synchronized (string) {
            return this.profilesByDisplayName.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileDescription getProfileByDisplayName(String string) {
        String string2 = this.LOCK;
        synchronized (string2) {
            return this.profilesByDisplayName.get(string);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        PropertyChangeEvent propertyChangeEvent = null;
        String string = this.LOCK;
        synchronized (string) {
            Object object;
            Object object2;
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            HashMap<String, List<Object[]>> hashMap = new HashMap<String, List<Object[]>>();
            FileObject fileObject = fileSystem.findResource(this.mimeTypes.getBasePath());
            if (fileObject != null && fileObject.isFolder()) {
                this.locator.scan(fileObject, null, null, false, true, true, false, hashMap);
                object2 = this.mimeTypes.getMimeTypes();
                object = object2.iterator();
                while (object.hasNext()) {
                    String string2 = (String)object.next();
                    this.locator.scan(fileObject, string2, null, false, true, true, false, hashMap);
                }
            }
            object2 = new HashMap();
            object = new HashMap();
            for (String string3 : hashMap.keySet()) {
                Object object3;
                List list = (List)hashMap.get(string3);
                String string4 = null;
                boolean bl = false;
                String string5 = null;
                Object object4 = list.iterator();
                while (object4.hasNext()) {
                    object3 = (Object[])object4.next();
                    FileObject fileObject2 = (FileObject)object3[0];
                    FileObject fileObject3 = (FileObject)object3[1];
                    boolean bl2 = (Boolean)object3[2];
                    if (fileObject2 != null) {
                        string5 = fileObject2.getPath();
                        if (string4 == null && (string4 = Utils.getLocalizedName(fileObject2, null)) == null) {
                            string4 = Utils.getLocalizedName(fileObject2, string3, null);
                        }
                    } else {
                        string5 = fileObject3.getPath();
                    }
                    if (!bl) {
                        bl = bl2;
                    }
                    if (string4 == null || !bl) continue;
                    break;
                }
                if ((object4 = (ProfileDescription)((HashMap)object).get(string4 = string4 == null ? string3 : string4)) != null) {
                    object3 = fileObject.getPath() + "/" + this.locator.getWritableFileName(null, string3, null, false);
                    if (((String)object3).startsWith(string5)) {
                        ((HashMap)object2).remove(((ProfileDescription)object4).getId());
                        ((HashMap)object).remove(string4);
                        LOG.warning("Ignoring profile '" + ((ProfileDescription)object4).getId() + "' (" + ((ProfileDescription)object4).profileOrigin + ") in favor of '" + string3 + "' (" + string5 + ") with the same display name.");
                    } else {
                        LOG.warning("Ignoring profile '" + string3 + "' (" + string5 + "), it's got the same display name as '" + ((ProfileDescription)object4).getId() + "' (" + ((ProfileDescription)object4).profileOrigin + ").");
                        continue;
                    }
                }
                object3 = this.reuseOrCreate(string3, string4, bl, string5);
                ((HashMap)object2).put(string3, object3);
                ((HashMap)object).put(string4, object3);
            }
            assert (((HashMap)object).size() == ((HashMap)object2).size()) : "Inconsistent profile maps";
            if (!((Object)this.profiles).equals(object2)) {
                propertyChangeEvent = new PropertyChangeEvent(this, PROP_PROFILES, this.profiles, object2);
                this.profiles = object2;
                this.profilesByDisplayName = object;
            }
        }
        if (propertyChangeEvent != null) {
            this.pcs.firePropertyChange(propertyChangeEvent);
        }
    }

    private ProfileDescription reuseOrCreate(String string, String string2, boolean bl, String string3) {
        ProfileDescription profileDescription = this.profiles.get(string);
        if (profileDescription != null && profileDescription.getDisplayName().equals(string2) && profileDescription.isRollbackAllowed() == bl) {
            return profileDescription;
        }
        return new ProfileDescription(string, string2, bl, string3);
    }

    private final class Listener
    extends FileChangeAdapter
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ProfilesTracker.this.rebuild();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.notifyRebuild(fileEvent.getFile());
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.notifyRebuild(fileEvent.getFile());
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.notifyRebuild(fileEvent.getFile());
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.notifyRebuild(fileRenameEvent.getFile());
        }

        private void notifyRebuild(FileObject fileObject) {
            String string = fileObject.getPath();
            if (string.startsWith(ProfilesTracker.this.mimeTypes.getBasePath())) {
                ProfilesTracker.this.task.schedule(100);
            }
        }
    }

    public static final class ProfileDescription {
        private final String id;
        private final String displayName;
        private final boolean isRollbackAllowed;
        private final String profileOrigin;

        private ProfileDescription(String string, String string2, boolean bl, String string3) {
            this.id = string;
            this.displayName = string2;
            this.isRollbackAllowed = bl;
            this.profileOrigin = string3;
        }

        public boolean isRollbackAllowed() {
            return this.isRollbackAllowed;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getId() {
            return this.id;
        }
    }
}

