/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun.vba;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.TestCase;
import mondrian.olap.InvalidArgumentException;
import mondrian.olap.fun.vba.Vba;

public class VbaTest
extends TestCase {
    private static final double SMALL = 1.0E-10;
    private static final Date SAMPLE_DATE = VbaTest.sampleDate();
    private static final String timeZoneName = TimeZone.getDefault().getDisplayName();
    private static final boolean isPST = timeZoneName.equals("America/Los_Angeles") || timeZoneName.equals("Pacific Standard Time");

    public void testCBool() {
        Boolean o;
        VbaTest.assertEquals((boolean)true, (boolean)Vba.cBool(Boolean.TRUE));
        VbaTest.assertEquals((boolean)false, (boolean)Vba.cBool(Boolean.FALSE));
        VbaTest.assertEquals((boolean)true, (boolean)Vba.cBool(1.5));
        VbaTest.assertEquals((boolean)true, (boolean)Vba.cBool("1.5"));
        VbaTest.assertEquals((boolean)false, (boolean)Vba.cBool("0.00"));
        try {
            o = Vba.cBool("a");
            VbaTest.fail((String)("expected error, got " + o));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "NumberFormatException");
        }
        try {
            o = Vba.cBool("true");
            VbaTest.fail((String)("expected error, got " + o));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "NumberFormatException");
        }
    }

    private void assertMessage(RuntimeException e, String expected) {
        String message = e.getClass().getName() + ": " + e.getMessage();
        VbaTest.assertTrue((String)("expected message to contain '" + expected + "', got '" + message + "'"), (message.indexOf(expected) >= 0 ? 1 : 0) != 0);
    }

    public void testCInt() {
        VbaTest.assertEquals((int)1, (int)Vba.cInt(1));
        VbaTest.assertEquals((int)1, (int)Vba.cInt(1.4));
        VbaTest.assertEquals((int)2, (int)Vba.cInt(1.5));
        VbaTest.assertEquals((int)2, (int)Vba.cInt(2.5));
        VbaTest.assertEquals((int)2, (int)Vba.cInt(1.6));
        VbaTest.assertEquals((int)-1, (int)Vba.cInt(-1.4));
        VbaTest.assertEquals((int)-2, (int)Vba.cInt(-1.5));
        VbaTest.assertEquals((int)-2, (int)Vba.cInt(-1.6));
        VbaTest.assertEquals((int)Integer.MAX_VALUE, (int)Vba.cInt(2.147483647E9));
        VbaTest.assertEquals((int)Integer.MIN_VALUE, (int)Vba.cInt(-2.147483648E9));
        VbaTest.assertEquals((int)Short.MAX_VALUE, (int)Vba.cInt(32767.4));
        VbaTest.assertEquals((int)Short.MIN_VALUE, (int)Vba.cInt(-32767.6));
        try {
            Integer o = Vba.cInt("a");
            VbaTest.fail((String)("expected error, got " + o));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "NumberFormatException");
        }
    }

    public void testInt() {
        VbaTest.assertEquals((int)1, (int)Vba.int_(1));
        VbaTest.assertEquals((int)1, (int)Vba.int_(1.4));
        VbaTest.assertEquals((int)1, (int)Vba.int_(1.5));
        VbaTest.assertEquals((int)2, (int)Vba.int_(2.5));
        VbaTest.assertEquals((int)1, (int)Vba.int_(1.6));
        VbaTest.assertEquals((int)-2, (int)Vba.int_(-2));
        VbaTest.assertEquals((int)-2, (int)Vba.int_(-1.4));
        VbaTest.assertEquals((int)-2, (int)Vba.int_(-1.5));
        VbaTest.assertEquals((int)-2, (int)Vba.int_(-1.6));
        VbaTest.assertEquals((int)Integer.MAX_VALUE, (int)Vba.int_(2.147483647E9));
        VbaTest.assertEquals((int)Integer.MIN_VALUE, (int)Vba.int_(-2.147483648E9));
        try {
            Integer o = Vba.int_("a");
            VbaTest.fail((String)("expected error, got " + o));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "Invalid parameter.");
        }
    }

    public void testFix() {
        VbaTest.assertEquals((int)1, (int)Vba.fix(1));
        VbaTest.assertEquals((int)1, (int)Vba.fix(1.4));
        VbaTest.assertEquals((int)1, (int)Vba.fix(1.5));
        VbaTest.assertEquals((int)2, (int)Vba.fix(2.5));
        VbaTest.assertEquals((int)1, (int)Vba.fix(1.6));
        VbaTest.assertEquals((int)-1, (int)Vba.fix(-1));
        VbaTest.assertEquals((int)-1, (int)Vba.fix(-1.4));
        VbaTest.assertEquals((int)-1, (int)Vba.fix(-1.5));
        VbaTest.assertEquals((int)-1, (int)Vba.fix(-1.6));
        VbaTest.assertEquals((int)Integer.MAX_VALUE, (int)Vba.fix(2.147483647E9));
        VbaTest.assertEquals((int)Integer.MIN_VALUE, (int)Vba.fix(-2.147483648E9));
        try {
            Integer o = Vba.fix("a");
            VbaTest.fail((String)("expected error, got " + o));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "Invalid parameter.");
        }
    }

    public void testCDbl() {
        VbaTest.assertEquals((Object)1.0, (Object)Vba.cDbl(1));
        VbaTest.assertEquals((Object)1.4, (Object)Vba.cDbl(1.4));
        VbaTest.assertEquals((Object)1.5, (Object)Vba.cDbl(1.5));
        VbaTest.assertEquals((Object)2.5, (Object)Vba.cDbl(2.5));
        VbaTest.assertEquals((Object)1.6, (Object)Vba.cDbl(1.6));
        VbaTest.assertEquals((Object)-1.4, (Object)Vba.cDbl(-1.4));
        VbaTest.assertEquals((Object)-1.5, (Object)Vba.cDbl(-1.5));
        VbaTest.assertEquals((Object)-1.6, (Object)Vba.cDbl(-1.6));
        VbaTest.assertEquals((Object)Double.MAX_VALUE, (Object)Vba.cDbl(Double.MAX_VALUE));
        VbaTest.assertEquals((Object)Double.MIN_VALUE, (Object)Vba.cDbl(Double.MIN_VALUE));
        try {
            Double o = Vba.cDbl("a");
            VbaTest.fail((String)("expected error, got " + o));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "NumberFormatException");
        }
    }

    public void testHex() {
        VbaTest.assertEquals((String)"0", (String)Vba.hex(0));
        VbaTest.assertEquals((String)"1", (String)Vba.hex(1));
        VbaTest.assertEquals((String)"A", (String)Vba.hex(10));
        VbaTest.assertEquals((String)"64", (String)Vba.hex(100));
        VbaTest.assertEquals((String)"FFFFFFFF", (String)Vba.hex(-1));
        VbaTest.assertEquals((String)"FFFFFFF6", (String)Vba.hex(-10));
        VbaTest.assertEquals((String)"FFFFFF9C", (String)Vba.hex(-100));
        try {
            String o = Vba.hex("a");
            VbaTest.fail((String)("expected error, got " + o));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "Invalid parameter.");
        }
    }

    public void testOct() {
        VbaTest.assertEquals((String)"0", (String)Vba.oct(0));
        VbaTest.assertEquals((String)"1", (String)Vba.oct(1));
        VbaTest.assertEquals((String)"12", (String)Vba.oct(10));
        VbaTest.assertEquals((String)"144", (String)Vba.oct(100));
        VbaTest.assertEquals((String)"37777777777", (String)Vba.oct(-1));
        VbaTest.assertEquals((String)"37777777766", (String)Vba.oct(-10));
        VbaTest.assertEquals((String)"37777777634", (String)Vba.oct(-100));
        try {
            String o = Vba.oct("a");
            VbaTest.fail((String)("expected error, got " + o));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "Invalid parameter.");
        }
    }

    public void testStr() {
        VbaTest.assertEquals((String)" 0", (String)Vba.str(0));
        VbaTest.assertEquals((String)" 1", (String)Vba.str(1));
        VbaTest.assertEquals((String)" 10", (String)Vba.str(10));
        VbaTest.assertEquals((String)" 100", (String)Vba.str(100));
        VbaTest.assertEquals((String)"-1", (String)Vba.str(-1));
        VbaTest.assertEquals((String)"-10", (String)Vba.str(-10));
        VbaTest.assertEquals((String)"-100", (String)Vba.str(-100));
        VbaTest.assertEquals((String)"-10.123", (String)Vba.str(-10.123));
        VbaTest.assertEquals((String)" 10.123", (String)Vba.str(10.123));
        try {
            String o = Vba.oct("a");
            VbaTest.fail((String)("expected error, got " + o));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "Invalid parameter.");
        }
    }

    public void testVal() {
        VbaTest.assertEquals((Object)-1615198.0, (Object)Vba.val(" -  1615 198th Street N.E."));
        VbaTest.assertEquals((Object)1615198.0, (Object)Vba.val(" 1615 198th Street N.E."));
        VbaTest.assertEquals((Object)1615.198, (Object)Vba.val(" 1615 . 198th Street N.E."));
        VbaTest.assertEquals((Object)1615.19, (Object)Vba.val(" 1615 . 19 . 8th Street N.E."));
        VbaTest.assertEquals((Object)65535.0, (Object)Vba.val("&HFFFF"));
        VbaTest.assertEquals((Object)668.0, (Object)Vba.val("&O1234"));
    }

    public void testCDate() throws ParseException {
        Date date = new Date();
        VbaTest.assertEquals((Object)date, (Object)Vba.cDate(date));
        VbaTest.assertNull((Object)Vba.cDate(null));
        try {
            VbaTest.assertEquals((Object)DateFormat.getDateInstance().parse("Jan 12, 1952"), (Object)Vba.cDate("Jan 12, 1952"));
            VbaTest.assertEquals((Object)DateFormat.getDateInstance().parse("October 19, 1962"), (Object)Vba.cDate("October 19, 1962"));
            VbaTest.assertEquals((Object)DateFormat.getTimeInstance().parse("4:35:47 PM"), (Object)Vba.cDate("4:35:47 PM"));
            VbaTest.assertEquals((Object)DateFormat.getDateTimeInstance().parse("October 19, 1962 4:35:47 PM"), (Object)Vba.cDate("October 19, 1962 4:35:47 PM"));
        }
        catch (ParseException e) {
            e.printStackTrace();
            VbaTest.fail();
        }
        try {
            Vba.cDate("Jan, 1952");
            VbaTest.fail();
        }
        catch (InvalidArgumentException e) {
            VbaTest.assertTrue((e.getMessage().indexOf("Jan, 1952") >= 0 ? 1 : 0) != 0);
        }
    }

    public void testIsDate() throws ParseException {
        VbaTest.assertFalse((boolean)Vba.isDate(null));
        VbaTest.assertTrue((boolean)Vba.isDate(new Date()));
        VbaTest.assertTrue((boolean)Vba.isDate("Jan 12, 1952"));
        VbaTest.assertTrue((boolean)Vba.isDate("October 19, 1962"));
        VbaTest.assertTrue((boolean)Vba.isDate("4:35:47 PM"));
        VbaTest.assertTrue((boolean)Vba.isDate("October 19, 1962 4:35:47 PM"));
        VbaTest.assertFalse((boolean)Vba.isDate("Jan, 1952"));
    }

    public void testDateAdd() {
        this.assertEquals("2008/04/24 19:10:45", SAMPLE_DATE);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2007, 1, 1, 0, 0, 0);
        Date feb2007 = calendar.getTime();
        this.assertEquals("2007/02/01 00:00:00", feb2007);
        this.assertEquals("2008/04/24 19:10:45", Vba.dateAdd("yyyy", 0.0, SAMPLE_DATE));
        this.assertEquals("2009/04/24 19:10:45", Vba.dateAdd("yyyy", 1.0, SAMPLE_DATE));
        this.assertEquals("2006/04/24 19:10:45", Vba.dateAdd("yyyy", -2.0, SAMPLE_DATE));
        Date sampleDatePlusTwoPointFiveYears = Vba.dateAdd("yyyy", 2.5, SAMPLE_DATE);
        if (isPST) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.US);
            String dateString = dateFormat.format(sampleDatePlusTwoPointFiveYears);
            VbaTest.assertTrue((String)("Got " + dateString), (dateString.equals("2010/10/24 06:40:45") || dateString.equals("2010/10/24 07:10:45") ? 1 : 0) != 0);
        }
        this.assertEquals("2009/01/24 19:10:45", Vba.dateAdd("q", 3.0, SAMPLE_DATE));
        this.assertEquals("2008/06/24 19:10:45", Vba.dateAdd("m", 2.0, SAMPLE_DATE));
        this.assertEquals("2007/01/01 00:00:00", Vba.dateAdd("m", -1.0, feb2007));
        this.assertEquals("2007/03/01 00:00:00", Vba.dateAdd("m", 1.0, feb2007));
        this.assertEquals("2007/02/08 00:00:00", Vba.dateAdd("m", 0.25, feb2007));
        this.assertEquals("2008/02/08 06:00:00", Vba.dateAdd("m", 12.25, feb2007));
        this.assertEquals("2008/05/01 19:10:45", Vba.dateAdd("y", 7.0, SAMPLE_DATE));
        this.assertEquals("2008/05/02 01:10:45", Vba.dateAdd("y", 7.25, SAMPLE_DATE));
        this.assertEquals("2008/04/24 23:10:45", Vba.dateAdd("h", 4.0, SAMPLE_DATE));
        this.assertEquals("2008/04/24 20:00:45", Vba.dateAdd("n", 50.0, SAMPLE_DATE));
        this.assertEquals("2008/04/24 19:10:36", Vba.dateAdd("s", -9.0, SAMPLE_DATE));
    }

    public void testDateDiff() {
    }

    public void testDatePart2() {
        VbaTest.assertEquals((int)2008, (int)Vba.datePart("yyyy", SAMPLE_DATE));
        VbaTest.assertEquals((int)2, (int)Vba.datePart("q", SAMPLE_DATE));
        VbaTest.assertEquals((int)4, (int)Vba.datePart("m", SAMPLE_DATE));
        VbaTest.assertEquals((int)5, (int)Vba.datePart("w", SAMPLE_DATE));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE));
        VbaTest.assertEquals((int)115, (int)Vba.datePart("y", SAMPLE_DATE));
        VbaTest.assertEquals((int)19, (int)Vba.datePart("h", SAMPLE_DATE));
        VbaTest.assertEquals((int)10, (int)Vba.datePart("n", SAMPLE_DATE));
        VbaTest.assertEquals((int)45, (int)Vba.datePart("s", SAMPLE_DATE));
    }

    public void testDatePart3() {
        VbaTest.assertEquals((int)5, (int)Vba.datePart("w", SAMPLE_DATE, 1));
        VbaTest.assertEquals((int)4, (int)Vba.datePart("w", SAMPLE_DATE, 2));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 1));
        VbaTest.assertEquals((int)18, (int)Vba.datePart("ww", SAMPLE_DATE, 4));
        VbaTest.assertEquals((int)18, (int)Vba.datePart("ww", SAMPLE_DATE, 5));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 6));
    }

    public void testDatePart4() {
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 1, 0));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 1, 1));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 1, 2));
        VbaTest.assertEquals((int)16, (int)Vba.datePart("ww", SAMPLE_DATE, 1, 3));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 2, 0));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 2, 1));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 2, 2));
        VbaTest.assertEquals((int)16, (int)Vba.datePart("ww", SAMPLE_DATE, 2, 3));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 3, 0));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 3, 1));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 3, 2));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 3, 3));
        VbaTest.assertEquals((int)18, (int)Vba.datePart("ww", SAMPLE_DATE, 4, 0));
        VbaTest.assertEquals((int)18, (int)Vba.datePart("ww", SAMPLE_DATE, 4, 1));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 4, 2));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 4, 3));
        VbaTest.assertEquals((int)18, (int)Vba.datePart("ww", SAMPLE_DATE, 5, 0));
        VbaTest.assertEquals((int)18, (int)Vba.datePart("ww", SAMPLE_DATE, 5, 1));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 5, 2));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 5, 3));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 6, 0));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 6, 1));
        VbaTest.assertEquals((int)16, (int)Vba.datePart("ww", SAMPLE_DATE, 6, 2));
        VbaTest.assertEquals((int)16, (int)Vba.datePart("ww", SAMPLE_DATE, 6, 3));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 7, 0));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 7, 1));
        VbaTest.assertEquals((int)17, (int)Vba.datePart("ww", SAMPLE_DATE, 7, 2));
        VbaTest.assertEquals((int)16, (int)Vba.datePart("ww", SAMPLE_DATE, 7, 3));
        try {
            int i = Vba.datePart("ww", SAMPLE_DATE, 1, 4);
            VbaTest.fail((String)("expected error, got " + i));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "ArrayIndexOutOfBoundsException");
        }
    }

    public void testDate() {
        Date date = Vba.date();
        VbaTest.assertNotNull((Object)date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        VbaTest.assertEquals((int)0, (int)calendar.get(11));
        VbaTest.assertEquals((int)0, (int)calendar.get(14));
    }

    public void testDateSerial() {
        Date date = Vba.dateSerial(2008, 2, 1);
        this.assertEquals("2008/02/01 00:00:00", date);
    }

    private void assertEquals(String expected, Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.US);
        String dateString = dateFormat.format(date);
        VbaTest.assertEquals((String)expected, (String)dateString);
    }

    public void testFormatDateTime() {
        try {
            Date date = DateFormat.getDateTimeInstance().parse("October 19, 1962 4:35:47 PM");
            VbaTest.assertEquals((String)"Oct 19, 1962 4:35:47 PM", (String)Vba.formatDateTime(date));
            VbaTest.assertEquals((String)"Oct 19, 1962 4:35:47 PM", (String)Vba.formatDateTime(date, 0));
            VbaTest.assertEquals((String)"October 19, 1962", (String)Vba.formatDateTime(date, 1));
            VbaTest.assertEquals((String)"10/19/62", (String)Vba.formatDateTime(date, 2));
            String datestr = Vba.formatDateTime(date, 3);
            VbaTest.assertNotNull((Object)datestr);
            VbaTest.assertTrue((boolean)datestr.startsWith("4:35:47 PM"));
            VbaTest.assertEquals((String)"4:35 PM", (String)Vba.formatDateTime(date, 4));
        }
        catch (ParseException e) {
            e.printStackTrace();
            VbaTest.fail();
        }
    }

    public void testDateValue() {
        Date date = new Date();
        Date date1 = Vba.dateValue(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date1);
        VbaTest.assertEquals((int)0, (int)calendar.get(11));
        VbaTest.assertEquals((int)0, (int)calendar.get(12));
        VbaTest.assertEquals((int)0, (int)calendar.get(13));
        VbaTest.assertEquals((int)0, (int)calendar.get(14));
    }

    private static Date sampleDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2008, 3, 24, 19, 10, 45);
        return calendar.getTime();
    }

    public void testDay() {
        VbaTest.assertEquals((int)24, (int)Vba.day(SAMPLE_DATE));
    }

    public void testHour() {
        VbaTest.assertEquals((int)19, (int)Vba.hour(SAMPLE_DATE));
    }

    public void testMinute() {
        VbaTest.assertEquals((int)10, (int)Vba.minute(SAMPLE_DATE));
    }

    public void testMonth() {
        VbaTest.assertEquals((int)4, (int)Vba.month(SAMPLE_DATE));
    }

    public void testNow() {
        Date date = Vba.now();
        VbaTest.assertNotNull((Object)date);
    }

    public void testSecond() {
        VbaTest.assertEquals((int)45, (int)Vba.second(SAMPLE_DATE));
    }

    public void testTimeSerial() {
        Date date = Vba.timeSerial(17, 42, 10);
        this.assertEquals("1970/01/01 17:42:10", date);
    }

    public void testTimeValue() {
        this.assertEquals("1970/01/01 19:10:45", Vba.timeValue(SAMPLE_DATE));
    }

    public void testTimer() {
        float v = Vba.timer();
        VbaTest.assertTrue((v >= 0.0f ? 1 : 0) != 0);
        VbaTest.assertTrue((v < 86400.0f ? 1 : 0) != 0);
    }

    public void testWeekday1() {
        if (Calendar.getInstance().getFirstDayOfWeek() == 1) {
            VbaTest.assertEquals((int)5, (int)Vba.weekday(SAMPLE_DATE));
        }
    }

    public void testWeekday2() {
        VbaTest.assertEquals((int)5, (int)Vba.weekday(SAMPLE_DATE, 1));
        VbaTest.assertEquals((int)4, (int)Vba.weekday(SAMPLE_DATE, 2));
        VbaTest.assertEquals((int)3, (int)Vba.weekday(SAMPLE_DATE, 3));
        VbaTest.assertEquals((int)2, (int)Vba.weekday(SAMPLE_DATE, 4));
        VbaTest.assertEquals((int)1, (int)Vba.weekday(SAMPLE_DATE, 5));
        VbaTest.assertEquals((int)7, (int)Vba.weekday(SAMPLE_DATE, 6));
        VbaTest.assertEquals((int)6, (int)Vba.weekday(SAMPLE_DATE, 7));
    }

    public void testYear() {
        VbaTest.assertEquals((int)2008, (int)Vba.year(SAMPLE_DATE));
    }

    public void testFormatNumber() {
        VbaTest.assertEquals((String)"1", (String)Vba.formatNumber(1.0));
        VbaTest.assertEquals((String)"1.0", (String)Vba.formatNumber(1.0, 1));
        VbaTest.assertEquals((String)"0.1", (String)Vba.formatNumber(0.1, -1, -1));
        VbaTest.assertEquals((String)".1", (String)Vba.formatNumber(0.1, -1, 0));
        VbaTest.assertEquals((String)"0.1", (String)Vba.formatNumber(0.1, -1, 1));
        VbaTest.assertEquals((String)"-1", (String)Vba.formatNumber(-1, -1, 1, -1));
        VbaTest.assertEquals((String)"-1", (String)Vba.formatNumber(-1, -1, 1, 0));
        VbaTest.assertEquals((String)"(1)", (String)Vba.formatNumber(-1, -1, 1, 1));
        VbaTest.assertEquals((String)"1", (String)Vba.formatNumber(1, -1, 1, -1));
        VbaTest.assertEquals((String)"1", (String)Vba.formatNumber(1, -1, 1, 0));
        VbaTest.assertEquals((String)"1", (String)Vba.formatNumber(1, -1, 1, 1));
        VbaTest.assertEquals((String)"1,000", (String)Vba.formatNumber(1000.0, -1, -1, -1, -1));
        VbaTest.assertEquals((String)"1000.0", (String)Vba.formatNumber(1000.0, 1, -1, -1, 0));
        VbaTest.assertEquals((String)"1,000.0", (String)Vba.formatNumber(1000.0, 1, -1, -1, 1));
    }

    public void testFormatPercent() {
        VbaTest.assertEquals((String)"100%", (String)Vba.formatPercent(1.0));
        VbaTest.assertEquals((String)"100.0%", (String)Vba.formatPercent(1.0, 1));
        VbaTest.assertEquals((String)"0.1%", (String)Vba.formatPercent(0.001, 1, -1));
        VbaTest.assertEquals((String)".1%", (String)Vba.formatPercent(0.001, 1, 0));
        VbaTest.assertEquals((String)"0.1%", (String)Vba.formatPercent(0.001, 1, 1));
        VbaTest.assertEquals((String)"11%", (String)Vba.formatPercent(0.111, -1));
        VbaTest.assertEquals((String)"11%", (String)Vba.formatPercent(0.111, 0));
        VbaTest.assertEquals((String)"11.100%", (String)Vba.formatPercent(0.111, 3));
        VbaTest.assertEquals((String)"-100%", (String)Vba.formatPercent(-1, -1, 1, -1));
        VbaTest.assertEquals((String)"-100%", (String)Vba.formatPercent(-1, -1, 1, 0));
        VbaTest.assertEquals((String)"(100%)", (String)Vba.formatPercent(-1, -1, 1, 1));
        VbaTest.assertEquals((String)"100%", (String)Vba.formatPercent(1, -1, 1, -1));
        VbaTest.assertEquals((String)"100%", (String)Vba.formatPercent(1, -1, 1, 0));
        VbaTest.assertEquals((String)"100%", (String)Vba.formatPercent(1, -1, 1, 1));
        VbaTest.assertEquals((String)"100,000%", (String)Vba.formatPercent(1000.0, -1, -1, -1, -1));
        VbaTest.assertEquals((String)"100000.0%", (String)Vba.formatPercent(1000.0, 1, -1, -1, 0));
        VbaTest.assertEquals((String)"100,000.0%", (String)Vba.formatPercent(1000.0, 1, -1, -1, 1));
    }

    public void testFormatCurrency() {
        VbaTest.assertEquals((String)"$1.00", (String)Vba.formatCurrency(1.0));
        VbaTest.assertEquals((String)"$0.00", (String)Vba.formatCurrency(0.0));
        VbaTest.assertEquals((String)"$1.0", (String)Vba.formatCurrency(1.0, 1));
        VbaTest.assertEquals((String)"$1", (String)Vba.formatCurrency(1.0, 0));
        VbaTest.assertEquals((String)"$.10", (String)Vba.formatCurrency(0.1, -1, 0));
        VbaTest.assertEquals((String)"$0.10", (String)Vba.formatCurrency(0.1, -1, -1));
        VbaTest.assertEquals((String)"($0.10)", (String)Vba.formatCurrency(-0.1, -1, -1, 0));
        VbaTest.assertEquals((String)"$1,000.00", (String)Vba.formatCurrency(1000.0, -1, -1, 0, 0));
        VbaTest.assertEquals((String)"$1000.00", (String)Vba.formatCurrency(1000.0, -1, -1, 0, -1));
    }

    public void testTypeName() {
        VbaTest.assertEquals((String)"Double", (String)Vba.typeName(1.0));
        VbaTest.assertEquals((String)"Integer", (String)Vba.typeName(1));
        VbaTest.assertEquals((String)"Float", (String)Vba.typeName(Float.valueOf(1.0f)));
        VbaTest.assertEquals((String)"Byte", (String)Vba.typeName((byte)1));
        VbaTest.assertEquals((String)"NULL", (String)Vba.typeName(null));
        VbaTest.assertEquals((String)"String", (String)Vba.typeName(""));
        VbaTest.assertEquals((String)"Date", (String)Vba.typeName(new Date()));
    }

    public void testFv() {
        double r = 0.0;
        int n = 3;
        double y = 2.0;
        double p = 7.0;
        boolean t = true;
        double f = Vba.fV(r, n, y, p, t);
        double x = -13.0;
        VbaTest.assertEquals((Object)x, (Object)f);
        r = 1.0;
        n = 10;
        y = 100.0;
        p = 10000.0;
        t = false;
        f = Vba.fV(r, n, y, p, t);
        x = -1.03423E7;
        VbaTest.assertEquals((Object)x, (Object)f);
        r = 1.0;
        n = 10;
        y = 100.0;
        p = 10000.0;
        t = true;
        f = Vba.fV(r, n, y, p, t);
        x = -1.04446E7;
        VbaTest.assertEquals((Object)x, (Object)f);
        r = 2.0;
        n = 12;
        y = 120.0;
        p = 12000.0;
        t = false;
        f = Vba.fV(r, n, y, p, t);
        x = -6.4091784E9;
        VbaTest.assertEquals((Object)x, (Object)f);
        r = 2.0;
        n = 12;
        y = 120.0;
        p = 12000.0;
        t = true;
        f = Vba.fV(r, n, y, p, t);
        x = -6.4729512E9;
        VbaTest.assertEquals((Object)x, (Object)f);
        r = 2.95;
        n = 13;
        y = 13000.0;
        p = -4406.78544294496;
        t = false;
        f = Vba.fV(r, n, y, p, t);
        x = 333891.230010986;
        VbaTest.assertEquals((double)x, (double)f, (double)0.01);
        r = 2.95;
        n = 13;
        y = 13000.0;
        p = -17406.7852148156;
        t = true;
        f = Vba.fV(r, n, y, p, t);
        x = 333891.230102539;
        VbaTest.assertEquals((double)x, (double)f, (double)0.01);
    }

    public void testNpv() {
        double r = 1.0;
        double[] v = new double[]{100.0, 200.0, 300.0, 400.0};
        double npv = Vba.nPV(r, v);
        double x = 162.5;
        VbaTest.assertEquals((Object)x, (Object)npv);
        r = 2.5;
        v = new double[]{1000.0, 666.66666, 333.33, 12.2768416};
        npv = Vba.nPV(r, v);
        x = 347.9923260414483;
        VbaTest.assertEquals((double)x, (double)npv, (double)1.0E-10);
        r = 12.33333;
        v = new double[]{1000.0, 0.0, -900.0, -7777.5765};
        npv = Vba.nPV(r, v);
        x = 74.3742433377061;
        VbaTest.assertEquals((double)x, (double)npv, (double)1.0E-12);
        r = 0.05;
        v = new double[]{200000.0, 300000.55, 400000.0, 1000000.0, 6000000.0, 7000000.0, -300000.0};
        npv = Vba.nPV(r, v);
        x = 1.13422834233124E7;
        VbaTest.assertEquals((double)x, (double)npv, (double)1.0E-8);
    }

    public void testPmt() {
        double r = 0.0;
        int n = 3;
        double p = 2.0;
        double f = 7.0;
        boolean t = true;
        double y = Vba.pmt(r, n, p, f, t);
        double x = -3.0;
        VbaTest.assertEquals((Object)x, (Object)y);
        r = 1.0;
        n = 10;
        p = -109.66796875;
        f = 10000.0;
        t = false;
        y = Vba.pmt(r, n, p, f, t);
        x = 100.0;
        VbaTest.assertEquals((Object)x, (Object)y);
        r = 1.0;
        n = 10;
        p = -209.5703125;
        f = 10000.0;
        t = true;
        y = Vba.pmt(r, n, p, f, t);
        x = 100.0;
        VbaTest.assertEquals((Object)x, (Object)y);
        r = 2.0;
        n = 12;
        f = -6.4091784E9;
        p = 12000.0;
        t = false;
        y = Vba.pmt(r, n, p, f, t);
        x = 120.0;
        VbaTest.assertEquals((Object)x, (Object)y);
        r = 2.0;
        n = 12;
        f = -6.4729512E9;
        p = 12000.0;
        t = true;
        y = Vba.pmt(r, n, p, f, t);
        x = 120.0;
        VbaTest.assertEquals((Object)x, (Object)y);
    }

    public void testPv() {
        double r = 0.0;
        int n = 3;
        double y = 2.0;
        double f = 7.0;
        boolean t = true;
        f = Vba.pV(r, n, y, f, t);
        double x = -13.0;
        VbaTest.assertEquals((Object)x, (Object)f);
        r = 1.0;
        n = 10;
        y = 100.0;
        f = 10000.0;
        t = false;
        double p = Vba.pV(r, n, y, f, t);
        x = -109.66796875;
        VbaTest.assertEquals((Object)x, (Object)p);
        r = 1.0;
        n = 10;
        y = 100.0;
        f = 10000.0;
        t = true;
        p = Vba.pV(r, n, y, f, t);
        x = -209.5703125;
        VbaTest.assertEquals((Object)x, (Object)p);
        r = 2.95;
        n = 13;
        y = 13000.0;
        f = 333891.23;
        t = false;
        p = Vba.pV(r, n, y, f, t);
        x = -4406.78544294496;
        VbaTest.assertEquals((double)x, (double)p, (double)1.0E-10);
        r = 2.95;
        n = 13;
        y = 13000.0;
        f = 333891.23;
        t = true;
        p = Vba.pV(r, n, y, f, t);
        x = -17406.7852148156;
        VbaTest.assertEquals((double)x, (double)p, (double)1.0E-10);
        r = 2.0;
        n = 12;
        y = 120.0;
        f = -6.4091784E9;
        t = false;
        p = Vba.pV(r, n, y, f, t);
        x = 12000.0;
        VbaTest.assertEquals((Object)x, (Object)p);
        r = 2.0;
        n = 12;
        y = 120.0;
        f = -6.4729512E9;
        t = true;
        p = Vba.pV(r, n, y, f, t);
        x = 12000.0;
        VbaTest.assertEquals((Object)x, (Object)p);
    }

    public void testDdb() {
        double cost = 100.0;
        double salvage = 0.0;
        double life = 10.0;
        double period = 1.0;
        double factor = 2.0;
        double result = Vba.dDB(cost, salvage, life, period, factor);
        VbaTest.assertEquals((Object)20.0, (Object)result);
        result = Vba.dDB(cost, salvage, life, period + 1.0, factor);
        VbaTest.assertEquals((Object)40.0, (Object)result);
        result = Vba.dDB(cost, salvage, life, period + 2.0, factor);
        VbaTest.assertEquals((Object)60.0, (Object)result);
        result = Vba.dDB(cost, salvage, life, period + 3.0, factor);
        VbaTest.assertEquals((Object)80.0, (Object)result);
    }

    public void testRate() {
        boolean type = false;
        double nPer = 360.0;
        double pmt = -877.57;
        double PV = 100000.0;
        double fv = 0.0;
        double guess = 0.008333333333333333;
        double result = Vba.rate(nPer, pmt, PV, fv, type, guess);
        double expRate = 0.0083333;
        double expPV = Vba.pV(expRate, 360.0, -877.57, 0.0, false);
        result = Vba.rate(360.0, -877.57, expPV, 0.0, false, 0.008333333333333333);
        VbaTest.assertTrue((Math.abs(expRate - result) < 1.0E-7 ? 1 : 0) != 0);
        double expFV = Vba.fV(expRate, 12.0, -100.0, 0.0, false);
        result = Vba.rate(12.0, -100.0, 0.0, expFV, false, 0.008333333333333333);
        VbaTest.assertTrue((Math.abs(expRate - result) < 1.0E-7 ? 1 : 0) != 0);
    }

    public void testIRR() {
        double[] vals = new double[]{-1000.0, 50.0, 50.0, 50.0, 50.0, 50.0, 1050.0};
        VbaTest.assertTrue((Math.abs(0.05 - Vba.IRR(vals, 0.1)) < 1.0E-7 ? 1 : 0) != 0);
        vals = new double[]{-1000.0, 200.0, 200.0, 200.0, 200.0, 200.0, 200.0};
        VbaTest.assertTrue((Math.abs(0.05471796 - Vba.IRR(vals, 0.1)) < 1.0E-7 ? 1 : 0) != 0);
        vals = new double[]{1000.0, -200.0, -200.0, -200.0, -200.0, -200.0, -200.0};
        VbaTest.assertTrue((Math.abs(0.05471796 - Vba.IRR(vals, 0.1)) < 1.0E-7 ? 1 : 0) != 0);
    }

    public void testMIRR() {
        double[] vals = new double[]{-1000.0, 50.0, 50.0, 50.0, 50.0, 50.0, 1050.0};
        VbaTest.assertTrue((Math.abs(0.05 - Vba.MIRR(vals, 0.05, 0.05)) < 1.0E-7 ? 1 : 0) != 0);
        vals = new double[]{-1000.0, 200.0, 200.0, 200.0, 200.0, 200.0, 200.0};
        VbaTest.assertTrue((Math.abs(0.05263266 - Vba.MIRR(vals, 0.05, 0.05)) < 1.0E-7 ? 1 : 0) != 0);
        vals = new double[]{-1000.0, 200.0, 200.0, 200.0, 200.0, 200.0, 200.0};
        VbaTest.assertTrue((Math.abs(0.04490701 - Vba.MIRR(vals, 0.06, 0.04)) < 1.0E-7 ? 1 : 0) != 0);
    }

    public void testIPmt() {
        VbaTest.assertEquals((Object)-10000.0, (Object)Vba.iPmt(0.1, 1.0, 30.0, 100000.0, 0.0, false));
        VbaTest.assertEquals((Object)-2185.473324557822, (Object)Vba.iPmt(0.1, 15.0, 30.0, 100000.0, 0.0, false));
        VbaTest.assertEquals((Object)-60.79248252633988, (Object)Vba.iPmt(0.1, 30.0, 30.0, 100000.0, 0.0, false));
    }

    public void testPPmt() {
        VbaTest.assertEquals((Object)-607.9248252633897, (Object)Vba.pPmt(0.1, 1.0, 30.0, 100000.0, 0.0, false));
        VbaTest.assertEquals((Object)-8422.451500705567, (Object)Vba.pPmt(0.1, 15.0, 30.0, 100000.0, 0.0, false));
        VbaTest.assertEquals((Object)-10547.13234273705, (Object)Vba.pPmt(0.1, 30.0, 30.0, 100000.0, 0.0, false));
        double pmt = Vba.pmt(0.1, 30.0, 100000.0, 0.0, false);
        double ipmt = Vba.iPmt(0.1, 15.0, 30.0, 100000.0, 0.0, false);
        double ppmt = Vba.pPmt(0.1, 15.0, 30.0, 100000.0, 0.0, false);
        VbaTest.assertTrue((Math.abs(pmt - (ipmt + ppmt)) < 1.0E-7 ? 1 : 0) != 0);
    }

    public void testSLN() {
        VbaTest.assertEquals((Object)18.0, (Object)Vba.sLN(100.0, 10.0, 5.0));
        VbaTest.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)Vba.sLN(100.0, 10.0, 0.0));
    }

    public void testSYD() {
        VbaTest.assertEquals((Object)300.0, (Object)Vba.sYD(1000.0, 100.0, 5.0, 5.0));
        VbaTest.assertEquals((Object)240.0, (Object)Vba.sYD(1000.0, 100.0, 4.0, 5.0));
        VbaTest.assertEquals((Object)180.0, (Object)Vba.sYD(1000.0, 100.0, 3.0, 5.0));
        VbaTest.assertEquals((Object)120.0, (Object)Vba.sYD(1000.0, 100.0, 2.0, 5.0));
        VbaTest.assertEquals((Object)60.0, (Object)Vba.sYD(1000.0, 100.0, 1.0, 5.0));
    }

    public void testInStr() {
        VbaTest.assertEquals((int)1, (int)Vba.inStr("the quick brown fox jumps over the lazy dog", "the"));
        VbaTest.assertEquals((int)32, (int)Vba.inStr(16, "the quick brown fox jumps over the lazy dog", "the"));
        VbaTest.assertEquals((int)0, (int)Vba.inStr(16, "the quick brown fox jumps over the lazy dog", "cat"));
        VbaTest.assertEquals((int)0, (int)Vba.inStr(1, "the quick brown fox jumps over the lazy dog", "cat"));
        VbaTest.assertEquals((int)0, (int)Vba.inStr(1, "", "cat"));
        VbaTest.assertEquals((int)0, (int)Vba.inStr(100, "short string", "str"));
        try {
            Vba.inStr(0, "the quick brown fox jumps over the lazy dog", "the");
            VbaTest.fail();
        }
        catch (InvalidArgumentException e) {
            VbaTest.assertTrue((e.getMessage().indexOf("-1 or a location") >= 0 ? 1 : 0) != 0);
        }
    }

    public void testInStrRev() {
        VbaTest.assertEquals((int)32, (int)Vba.inStrRev("the quick brown fox jumps over the lazy dog", "the"));
        VbaTest.assertEquals((int)1, (int)Vba.inStrRev("the quick brown fox jumps over the lazy dog", "the", 16));
        try {
            Vba.inStrRev("the quick brown fox jumps over the lazy dog", "the", 0);
            VbaTest.fail();
        }
        catch (InvalidArgumentException e) {
            VbaTest.assertTrue((e.getMessage().indexOf("-1 or a location") >= 0 ? 1 : 0) != 0);
        }
    }

    public void testStrComp() {
        VbaTest.assertEquals((int)-1, (int)Vba.strComp("a", "b", 0));
        VbaTest.assertEquals((int)0, (int)Vba.strComp("a", "a", 0));
        VbaTest.assertEquals((int)1, (int)Vba.strComp("b", "a", 0));
    }

    public void testNper() {
        double r = 0.0;
        double y = 7.0;
        double p = 2.0;
        double f = 3.0;
        boolean t = false;
        double n = Vba.nPer(r, y, p, f, t);
        double x = -0.71428571429;
        VbaTest.assertEquals((double)x, (double)n, (double)1.0E-10);
        r = 1.0;
        y = 100.0;
        p = -109.66796875;
        f = 10000.0;
        t = false;
        n = Vba.nPer(r, y, p, f, t);
        x = 10.0;
        VbaTest.assertEquals((double)x, (double)n, (double)1.0E-12);
        r = 1.0;
        y = 100.0;
        p = -209.5703125;
        f = 10000.0;
        t = true;
        n = Vba.nPer(r, y, p, f, t);
        x = 10.0;
        VbaTest.assertEquals((double)x, (double)n, (double)1.0E-14);
        r = 2.0;
        y = 120.0;
        f = -6.4091784E9;
        p = 12000.0;
        t = false;
        n = Vba.nPer(r, y, p, f, t);
        x = 12.0;
        VbaTest.assertEquals((double)x, (double)n, (double)1.0E-10);
        r = 2.0;
        y = 120.0;
        f = -6.4729512E9;
        p = 12000.0;
        t = true;
        n = Vba.nPer(r, y, p, f, t);
        x = 12.0;
        VbaTest.assertEquals((double)x, (double)n, (double)1.0E-10);
    }

    public void testAsc() {
        VbaTest.assertEquals((int)97, (int)Vba.asc("abc"));
        VbaTest.assertEquals((int)4660, (int)Vba.asc("\u1234abc"));
        try {
            Integer o = Vba.asc("");
            VbaTest.fail((String)("expected error, got " + o));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "StringIndexOutOfBoundsException");
        }
    }

    public void testAscB() {
        VbaTest.assertEquals((int)97, (int)Vba.ascB("abc"));
        VbaTest.assertEquals((int)52, (int)Vba.ascB("\u1234abc"));
        try {
            Integer o = Vba.ascB("");
            VbaTest.fail((String)("expected error, got " + o));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "StringIndexOutOfBoundsException");
        }
    }

    public void testAscW() {
        VbaTest.assertEquals((int)97, (int)Vba.ascW("abc"));
        VbaTest.assertEquals((int)4660, (int)Vba.ascW("\u1234abc"));
        try {
            Integer o = Vba.ascW("");
            VbaTest.fail((String)("expected error, got " + o));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "StringIndexOutOfBoundsException");
        }
    }

    public void testChr() {
        VbaTest.assertEquals((String)"a", (String)Vba.chr(97));
        VbaTest.assertEquals((String)"\u1234", (String)Vba.chr(4660));
    }

    public void testChrB() {
        VbaTest.assertEquals((String)"a", (String)Vba.chrB(97));
        VbaTest.assertEquals((String)"4", (String)Vba.chrB(4660));
    }

    public void testChrW() {
        VbaTest.assertEquals((String)"a", (String)Vba.chrW(97));
        VbaTest.assertEquals((String)"\u1234", (String)Vba.chrW(4660));
    }

    public void testLCase() {
        VbaTest.assertEquals((String)"", (String)Vba.lCase(""));
        VbaTest.assertEquals((String)"abc", (String)Vba.lCase("AbC"));
    }

    public void testLeft() {
        VbaTest.assertEquals((String)"abc", (String)Vba.left("abcxyz", 3));
        VbaTest.assertEquals((String)"", (String)Vba.left("abcxyz", 0));
        VbaTest.assertEquals((String)"abcxyz", (String)Vba.left("abcxyz", 8));
        VbaTest.assertEquals((String)"", (String)Vba.left("", 3));
        try {
            String s = Vba.left("xyz", -2);
            VbaTest.fail((String)("expected error, got " + s));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "StringIndexOutOfBoundsException");
        }
    }

    public void testLTrim() {
        VbaTest.assertEquals((String)"", (String)Vba.lTrim(""));
        VbaTest.assertEquals((String)"", (String)Vba.lTrim("  "));
        VbaTest.assertEquals((String)"abc  \r", (String)Vba.lTrim(" \n\tabc  \r"));
    }

    public void testMonthName() {
        VbaTest.assertEquals((String)"January", (String)Vba.monthName(1, false));
        VbaTest.assertEquals((String)"Jan", (String)Vba.monthName(1, true));
        VbaTest.assertEquals((String)"Dec", (String)Vba.monthName(12, true));
        try {
            String s = Vba.monthName(0, true);
            VbaTest.fail((String)("expected error, got " + s));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "ArrayIndexOutOfBoundsException");
        }
    }

    public void testReplace3() {
        VbaTest.assertEquals((String)"abczabcz", (String)Vba.replace("xyzxyz", "xy", "abc"));
        VbaTest.assertEquals((String)"wazwaz", (String)Vba.replace("wxyzwxyz", "xy", "a"));
        VbaTest.assertEquals((String)"wxyz", (String)Vba.replace("xyz", "xy", "wxy"));
        VbaTest.assertEquals((String)"wxyzwx", (String)Vba.replace("xyyzxy", "xy", "wx"));
        VbaTest.assertEquals((String)"wxyza", (String)Vba.replace("wxxyyzxya", "xy", ""));
    }

    public void testReplace4() {
        VbaTest.assertEquals((String)"azaz", (String)Vba.replace("xyzxyz", "xy", "a", 1));
        VbaTest.assertEquals((String)"xyzaz", (String)Vba.replace("xyzxyz", "xy", "a", 2));
        VbaTest.assertEquals((String)"xyzxyz", (String)Vba.replace("xyzxyz", "xy", "a", 30));
        VbaTest.assertEquals((String)"azaz", (String)Vba.replace("xyzxyz", "xy", "a", 0));
        VbaTest.assertEquals((String)"azaz", (String)Vba.replace("xyzxyz", "xy", "a", -5));
    }

    public void testReplace5() {
        VbaTest.assertEquals((String)"azaz", (String)Vba.replace("xyzxyz", "xy", "a", 1, -1));
        VbaTest.assertEquals((String)"azxyz", (String)Vba.replace("xyzxyz", "xy", "a", 1, 1));
        VbaTest.assertEquals((String)"azaz", (String)Vba.replace("xyzxyz", "xy", "a", 1, 2));
        VbaTest.assertEquals((String)"xyzazxyz", (String)Vba.replace("xyzxyzxyz", "xy", "a", 2, 1));
    }

    public void testReplace6() {
        VbaTest.assertEquals((String)"azaz", (String)Vba.replace("xyzxyz", "xy", "a", 1, -1, 1000));
        VbaTest.assertEquals((String)"azxyz", (String)Vba.replace("xyzxyz", "xy", "a", 1, 1, 0));
        VbaTest.assertEquals((String)"azaz", (String)Vba.replace("xyzxyz", "xy", "a", 1, 2, -6));
        VbaTest.assertEquals((String)"xyzazxyz", (String)Vba.replace("xyzxyzxyz", "xy", "a", 2, 1, 11));
    }

    public void testRight() {
        VbaTest.assertEquals((String)"xyz", (String)Vba.right("abcxyz", 3));
        VbaTest.assertEquals((String)"", (String)Vba.right("abcxyz", 0));
        VbaTest.assertEquals((String)"abcxyz", (String)Vba.right("abcxyz", 8));
        VbaTest.assertEquals((String)"", (String)Vba.right("", 3));
        try {
            String s = Vba.right("xyz", -2);
            VbaTest.fail((String)("expected error, got " + s));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "StringIndexOutOfBoundsException");
        }
    }

    public void testRTrim() {
        VbaTest.assertEquals((String)"", (String)Vba.rTrim(""));
        VbaTest.assertEquals((String)"", (String)Vba.rTrim("  "));
        VbaTest.assertEquals((String)" \n\tabc", (String)Vba.rTrim(" \n\tabc"));
        VbaTest.assertEquals((String)" \n\tabc", (String)Vba.rTrim(" \n\tabc  \r"));
    }

    public void testSpace() {
        VbaTest.assertEquals((String)"   ", (String)Vba.space(3));
        VbaTest.assertEquals((String)"", (String)Vba.space(0));
        try {
            String s = Vba.space(-2);
            VbaTest.fail((String)("expected error, got " + s));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "NegativeArraySizeException");
        }
    }

    public void testString() {
        VbaTest.assertEquals((String)"xxx", (String)Vba.string(3, 'x'));
        VbaTest.assertEquals((String)"", (String)Vba.string(0, 'y'));
        try {
            String s = Vba.string(-2, 'z');
            VbaTest.fail((String)("expected error, got " + s));
        }
        catch (RuntimeException e) {
            this.assertMessage(e, "NegativeArraySizeException");
        }
        VbaTest.assertEquals((String)"", (String)Vba.string(100, '\u0000'));
    }

    public void testStrReverse() {
        VbaTest.assertEquals((String)"cba", (String)Vba.strReverse("abc"));
        VbaTest.assertEquals((String)"wxyz", (String)Vba.strReverse("zyxw"));
        VbaTest.assertEquals((String)"", (String)Vba.strReverse(""));
    }

    public void testTrim() {
        VbaTest.assertEquals((String)"", (String)Vba.trim(""));
        VbaTest.assertEquals((String)"", (String)Vba.trim("  "));
        VbaTest.assertEquals((String)"abc", (String)Vba.trim("abc"));
        VbaTest.assertEquals((String)"abc", (String)Vba.trim(" \n\tabc  \r"));
    }

    public void testWeekdayName() {
        VbaTest.assertEquals((String)"Sunday", (String)Vba.weekdayName(1, false, 1));
        VbaTest.assertEquals((String)"Monday", (String)Vba.weekdayName(2, false, 1));
        VbaTest.assertEquals((String)"Saturday", (String)Vba.weekdayName(7, false, 1));
        VbaTest.assertEquals((String)"Sat", (String)Vba.weekdayName(7, true, 1));
        VbaTest.assertEquals((String)"Monday", (String)Vba.weekdayName(1, false, 2));
        VbaTest.assertEquals((String)"Sunday", (String)Vba.weekdayName(7, false, 2));
        switch (Calendar.getInstance().getFirstDayOfWeek()) {
            case 1: {
                VbaTest.assertEquals((String)"Sunday", (String)Vba.weekdayName(1, false, 0));
                VbaTest.assertEquals((String)"Monday", (String)Vba.weekdayName(2, false, 0));
                VbaTest.assertEquals((String)"Saturday", (String)Vba.weekdayName(7, false, 0));
                VbaTest.assertEquals((String)"Sat", (String)Vba.weekdayName(7, true, 0));
                break;
            }
            case 2: {
                VbaTest.assertEquals((String)"Monday", (String)Vba.weekdayName(1, false, 0));
                VbaTest.assertEquals((String)"Tuesday", (String)Vba.weekdayName(2, false, 0));
                VbaTest.assertEquals((String)"Sunday", (String)Vba.weekdayName(7, false, 0));
                VbaTest.assertEquals((String)"Sun", (String)Vba.weekdayName(7, true, 0));
            }
        }
    }

    public void testAbs() {
        VbaTest.assertEquals((Object)Vba.abs(-1.7), (Object)1.7);
    }

    public void testAtn() {
        VbaTest.assertEquals((double)0.0, (double)Vba.atn(0.0), (double)1.0E-10);
        VbaTest.assertEquals((double)0.7853981633974483, (double)Vba.atn(1.0), (double)1.0E-10);
    }

    public void testCos() {
        VbaTest.assertEquals((double)1.0, (double)Vba.cos(0.0), (double)0.0);
        VbaTest.assertEquals((double)Vba.sqr(0.5), (double)Vba.cos(0.7853981633974483), (double)0.0);
        VbaTest.assertEquals((double)0.0, (double)Vba.cos(1.5707963267948966), (double)1.0E-10);
        VbaTest.assertEquals((double)-1.0, (double)Vba.cos(Math.PI), (double)0.0);
    }

    public void testExp() {
        VbaTest.assertEquals((Object)1.0, (Object)Vba.exp(0.0));
        VbaTest.assertEquals((double)Math.E, (double)Vba.exp(1.0), (double)1.0E-10);
    }

    public void testRound() {
        VbaTest.assertEquals((double)123.0, (double)Vba.round(123.4567), (double)1.0E-10);
    }

    public void testRound2() {
        VbaTest.assertEquals((double)123.0, (double)Vba.round(123.4567, 0), (double)1.0E-10);
        VbaTest.assertEquals((double)123.46, (double)Vba.round(123.4567, 2), (double)1.0E-10);
        VbaTest.assertEquals((double)120.0, (double)Vba.round(123.45, -1), (double)1.0E-10);
        VbaTest.assertEquals((double)-123.46, (double)Vba.round(-123.4567, 2), (double)1.0E-10);
    }

    public void testSgn() {
        VbaTest.assertEquals((double)1.0, (double)Vba.sgn(3.11111), (double)0.0);
        VbaTest.assertEquals((double)-1.0, (double)Vba.sgn(-Math.PI), (double)0.0);
        VbaTest.assertTrue((0 == Vba.sgn(-0.0) ? 1 : 0) != 0);
        VbaTest.assertTrue((0 == Vba.sgn(0.0) ? 1 : 0) != 0);
    }

    public void testSin() {
        VbaTest.assertEquals((double)Vba.sqr(0.5), (double)Vba.sin(0.7853981633974483), (double)1.0E-10);
    }

    public void testSqr() {
        VbaTest.assertEquals((double)2.0, (double)Vba.sqr(4.0), (double)0.0);
        VbaTest.assertEquals((double)0.0, (double)Vba.sqr(0.0), (double)0.0);
        VbaTest.assertTrue((boolean)Double.isNaN(Vba.sqr(-4.0)));
    }

    public void testTan() {
        VbaTest.assertEquals((double)1.0, (double)Vba.tan(0.7853981633974483), (double)1.0E-10);
    }
}

