/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.util.HashMap;
import java.util.Map;
import mondrian.olap.MondrianProperties;
import org.eigenbase.util.property.BooleanProperty;
import org.eigenbase.util.property.DoubleProperty;
import org.eigenbase.util.property.IntegerProperty;
import org.eigenbase.util.property.Property;
import org.eigenbase.util.property.StringProperty;

public class PropertySaver {
    public final MondrianProperties properties = MondrianProperties.instance();
    private final Map<Property, String> originalValues = new HashMap<Property, String>();
    private static final String NOT_SET = new StringBuffer("NOT_SET").toString();

    public void set(BooleanProperty property, boolean value) {
        if (!this.originalValues.containsKey(property)) {
            String originalValue = this.properties.containsKey(property.getPath()) ? this.properties.getProperty(property.getPath()) : NOT_SET;
            this.originalValues.put((Property)property, originalValue);
        }
        property.set(value);
    }

    public void set(IntegerProperty property, int value) {
        if (!this.originalValues.containsKey(property)) {
            String originalValue = this.properties.containsKey(property.getPath()) ? this.properties.getProperty(property.getPath()) : NOT_SET;
            this.originalValues.put((Property)property, originalValue);
        }
        property.set(value);
    }

    public void set(StringProperty property, String value) {
        if (!this.originalValues.containsKey(property)) {
            String originalValue = this.properties.containsKey(property.getPath()) ? this.properties.getProperty(property.getPath()) : NOT_SET;
            this.originalValues.put((Property)property, originalValue);
        }
        property.set(value);
    }

    public void set(DoubleProperty property, Double value) {
        if (!this.originalValues.containsKey(property)) {
            String originalValue = this.properties.containsKey(property.getPath()) ? this.properties.getProperty(property.getPath()) : NOT_SET;
            this.originalValues.put((Property)property, originalValue);
        }
        property.set(value.doubleValue());
    }

    public void reset() {
        for (Map.Entry<Property, String> entry : this.originalValues.entrySet()) {
            String value = entry.getValue();
            if (value == NOT_SET) {
                this.properties.remove(entry.getKey());
                continue;
            }
            this.properties.setProperty(entry.getKey().getPath(), value);
        }
    }
}

