/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test.clearview;

import java.lang.reflect.Constructor;
import junit.framework.Test;
import junit.framework.TestSuite;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BatchTestCase;
import mondrian.spi.Dialect;
import mondrian.test.DiffRepository;
import mondrian.test.SqlPattern;
import mondrian.test.TestContext;

public abstract class ClearViewBase
extends BatchTestCase {
    public ClearViewBase() {
    }

    public ClearViewBase(String name) {
        super(name);
    }

    public abstract DiffRepository getDiffRepos();

    protected void setUp() throws Exception {
        DiffRepository diffRepos = this.getDiffRepos();
        diffRepos.setCurrentTestCaseName(this.getName());
    }

    protected void tearDown() throws Exception {
        DiffRepository diffRepos = this.getDiffRepos();
        diffRepos.setCurrentTestCaseName(null);
    }

    public static TestSuite constructSuite(DiffRepository diffRepos, Class clazz) {
        TestSuite suite = new TestSuite();
        Class[] types = new Class[]{String.class};
        for (String name : diffRepos.getTestCaseNames()) {
            try {
                Constructor cons = clazz.getConstructor(types);
                Object[] args = new Object[]{name};
                suite.addTest((Test)cons.newInstance(args));
            }
            catch (Exception e) {
                throw new Error(e.getMessage());
            }
        }
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Exception {
        DiffRepository diffRepos = this.getDiffRepos();
        TestContext testContext = this.getTestContext();
        String cubeName = diffRepos.expand(null, "${modifiedCubeName}").trim();
        if (!cubeName.equals("") && !cubeName.equals("${modifiedCubeName}")) {
            String customDimensions = diffRepos.expand(null, "${customDimensions}");
            customDimensions = !customDimensions.equals("") && !customDimensions.equals("${customDimensions}") ? customDimensions : null;
            String calculatedMembers = diffRepos.expand(null, "${calculatedMembers}");
            calculatedMembers = !calculatedMembers.equals("") && !calculatedMembers.equals("${calculatedMembers}") ? calculatedMembers : null;
            String namedSets = diffRepos.expand(null, "${namedSets}");
            namedSets = !namedSets.equals("") && !namedSets.equals("${namedSets}") ? namedSets : null;
            testContext = TestContext.createSubstitutingCube(cubeName, customDimensions, calculatedMembers, namedSets);
        }
        boolean origExpandNonNative = MondrianProperties.instance().ExpandNonNative.get();
        MondrianProperties.instance().ExpandNonNative.set(true);
        try {
            String mdx = diffRepos.expand(null, "${mdx}");
            String result = Util.nl + TestContext.toString(testContext.executeQuery(mdx));
            diffRepos.assertEquals("result", "${result}", result);
        }
        finally {
            MondrianProperties.instance().ExpandNonNative.set(origExpandNonNative);
        }
    }

    protected void assertQuerySql(boolean flushCache) throws Exception {
        DiffRepository diffRepos = this.getDiffRepos();
        if (this.buildSqlPatternArray() == null) {
            return;
        }
        super.assertQuerySqlOrNot(this.getTestContext(), diffRepos.expand(null, "${mdx}"), this.buildSqlPatternArray(), false, false, flushCache);
    }

    protected void assertNoQuerySql(boolean flushCache) throws Exception {
        DiffRepository diffRepos = this.getDiffRepos();
        if (this.buildSqlPatternArray() == null) {
            return;
        }
        super.assertQuerySqlOrNot(this.getTestContext(), diffRepos.expand(null, "${mdx}"), this.buildSqlPatternArray(), true, false, flushCache);
    }

    private SqlPattern[] buildSqlPatternArray() {
        DiffRepository diffRepos = this.getDiffRepos();
        Dialect d = this.getTestContext().getDialect();
        Dialect.DatabaseProduct dialect = d.getDatabaseProduct();
        String testCaseName = this.getName();
        String sql = diffRepos.get(testCaseName, "expectedSql", dialect.name());
        if (sql != null) {
            sql = sql.replaceAll("[ \t\n\f\r]+", " ").trim();
            SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(dialect, sql, null)};
            return patterns;
        }
        return null;
    }
}

