/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.CreateTableDialog;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableOwnerOperations;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class CreateTableAction
extends DatabaseAction {
    static final long serialVersionUID = -7008851466327604724L;

    public void performAction(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length <= 0) {
            return;
        }
        Node node = nodeArray[0];
        DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
        final TableOwnerOperations tableOwnerOperations = (TableOwnerOperations)((Object)databaseNodeInfo.getParent(this.nodename));
        Specification specification = (Specification)databaseNodeInfo.getSpecification();
        final CreateTableDialog createTableDialog = new CreateTableDialog(specification, (DatabaseNodeInfo)((Object)tableOwnerOperations));
        if (createTableDialog.run()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        tableOwnerOperations.addTable(createTableDialog.getTableName());
                    }
                    catch (DatabaseException databaseException) {
                        DbUtilities.reportError(DatabaseAction.bundle().getString("ERR_UnableToCreateTable"), databaseException.getMessage());
                    }
                }
            });
        }
    }
}

