/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dataview.DataViewWindow;
import org.netbeans.modules.db.explorer.dlg.LabeledTextFieldDialog;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableListNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class RecreateTableAction
extends DatabaseAction {
    static final long serialVersionUID = 6992569917995229492L;

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1;
    }

    public void performAction(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return;
        }
        Node node = nodeArray[0];
        final DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
        final Frame frame = WindowManager.getDefault().getMainWindow();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    Object object;
                    TableListNodeInfo tableListNodeInfo = (TableListNodeInfo)databaseNodeInfo.getParent(RecreateTableAction.this.nodename);
                    Specification specification = (Specification)tableListNodeInfo.getSpecification();
                    JFileChooser jFileChooser = new JFileChooser();
                    FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
                    jFileChooser.setDialogType(0);
                    jFileChooser.setDialogTitle(DatabaseAction.bundle().getString("RecreateTableFileOpenDialogTitle"));
                    jFileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().endsWith(".grab");
                        }

                        public String getDescription() {
                            return DatabaseAction.bundle().getString("GrabTableFileTypeDescription");
                        }
                    });
                    if (jFileChooser.showOpenDialog(frame) == 0) {
                        object = jFileChooser.getSelectedFile();
                        if (object == null || !((File)object).isFile()) {
                            return;
                        }
                    } else {
                        return;
                    }
                    Object object2 = new FileInputStream((File)object);
                    Object object3 = new ObjectInputStream((InputStream)object2);
                    AbstractCommand abstractCommand = (AbstractCommand)((ObjectInputStream)object3).readObject();
                    ((ObjectInputStream)object3).close();
                    abstractCommand.setSpecification(specification);
                    abstractCommand.setObjectOwner((String)databaseNodeInfo.get("schema"));
                    object = abstractCommand.getObjectName();
                    object2 = abstractCommand.getCommand();
                    object3 = new LabeledTextFieldDialog((String)object2);
                    ((LabeledTextFieldDialog)object3).setStringValue((String)object);
                    boolean bl = true;
                    while (bl) {
                        if (((LabeledTextFieldDialog)object3).run()) {
                            if (!((LabeledTextFieldDialog)object3).isEditable()) {
                                bl = RecreateTableAction.this.runCommand(tableListNodeInfo, (LabeledTextFieldDialog)object3, abstractCommand);
                                continue;
                            }
                            bl = RecreateTableAction.this.runWindow(databaseNodeInfo, (LabeledTextFieldDialog)object3);
                            continue;
                        }
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger("global").log(Level.INFO, null, exception);
                    DbUtilities.reportError(DatabaseAction.bundle().getString("ERR_UnableToRecreateTable"), exception.getMessage());
                }
            }
        }, 0);
    }

    private boolean runCommand(TableListNodeInfo tableListNodeInfo, LabeledTextFieldDialog labeledTextFieldDialog, AbstractCommand abstractCommand) {
        boolean bl = true;
        String string = labeledTextFieldDialog.getStringValue();
        abstractCommand.setObjectName(string);
        try {
            abstractCommand.execute();
            tableListNodeInfo.addTable(string);
            bl = false;
        }
        catch (DDLException dDLException) {
            Logger.getLogger("global").log(Level.INFO, null, dDLException);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)dDLException.getMessage(), 0));
            bl = true;
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger("global").log(Level.INFO, null, databaseException);
            bl = true;
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.INFO, null, exception);
            DbUtilities.reportError(RecreateTableAction.bundle().getString("ERR_UnableToRecreateTable"), exception.getMessage());
            bl = false;
        }
        return bl;
    }

    private boolean runWindow(DatabaseNodeInfo databaseNodeInfo, LabeledTextFieldDialog labeledTextFieldDialog) throws Exception {
        WindowTask windowTask = new WindowTask(databaseNodeInfo, labeledTextFieldDialog);
        Mutex.EVENT.postReadRequest((Runnable)windowTask);
        while (!windowTask.completed) {
            Thread.sleep(10L);
        }
        if (windowTask.exc != null) {
            throw new DatabaseException(windowTask.exc);
        }
        return !windowTask.win.executeCommand();
    }

    private static class WindowTask
    implements Runnable {
        public DataViewWindow win;
        public Exception exc = null;
        public boolean completed = false;
        private final DatabaseNodeInfo info;
        private final LabeledTextFieldDialog dlg;

        public WindowTask(DatabaseNodeInfo databaseNodeInfo, LabeledTextFieldDialog labeledTextFieldDialog) {
            this.info = databaseNodeInfo;
            this.dlg = labeledTextFieldDialog;
        }

        public void run() {
            try {
                this.win = new DataViewWindow(this.info, this.dlg.getEditedCommand());
            }
            catch (Exception exception) {
                this.exc = exception;
            }
            this.completed = true;
        }
    }
}

