/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.widgets;

import com.jaspersoft.ireport.components.table.DefaultTableCellElementsLayout;
import com.jaspersoft.ireport.components.table.TableCell;
import com.jaspersoft.ireport.components.table.TableMatrix;
import com.jaspersoft.ireport.components.table.TableObjectScene;
import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.borders.ReportBorder;
import com.jaspersoft.ireport.designer.utils.Java2DUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.draw.DrawVisitor;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.ImageUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableWidget
extends Widget
implements PropertyChangeListener {
    public static Color CELL_LABEL_COLOR = AbstractReportObjectScene.DESIGN_LINE_COLOR;
    int cellListenersCount = 0;
    private StandardTable table = null;
    private JRDesignComponentElement element = null;
    JRDesignDataset currentDataset = null;
    private PropertyChangeListener layoutListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("width")) {
                return;
            }
            TableWidget.this.layoutChanged(evt);
        }
    };
    PropertyChangeListener datasetRunChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            TableWidget.this.datasetPropertyChanged(evt);
        }
    };
    private PropertyChangeListener cellLayoutListener = new PropertyChangeListener(){

        public void propertyChange(final PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("children")) {
                TableWidget.this.removeCellListeners();
                TableWidget.this.addCellListeners();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((TableObjectScene)TableWidget.this.getScene()).refreshCells();
                        if (evt.getSource() != null && evt.getSource() instanceof DesignCell && !IReportManager.getPreferences().getBoolean("disableCrosstabAutoLayout", false)) {
                            DefaultTableCellElementsLayout.doLayout((DesignCell)evt.getSource(), (TableObjectScene)TableWidget.this.getScene());
                        }
                    }
                });
            } else if (evt.getPropertyName().equals("ROW_HEIGHT")) {
                TableWidget.this.layoutChanged(evt);
            } else {
                TableWidget.this.revalidate(true);
                TableWidget.this.getScene().validate();
            }
        }
    };
    private TexturePaint gridTexture = null;
    private static TexturePaint nullAreaTexture = null;
    private static TexturePaint nullTableAreaTexture = null;
    private final BasicStroke GRID_STROKE = new BasicStroke(0.0f, 2, 2, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);
    private int gridSize = 13;

    public TableWidget(TableObjectScene scene, JRDesignComponentElement element) {
        super((Scene)scene);
        this.element = element;
        this.table = (StandardTable)element.getComponent();
        this.setBorder((Border)new ReportBorder());
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setCheckClipping(true);
        this.updateBounds();
        this.table.getEventSupport().addPropertyChangeListener(this.layoutListener);
        element.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        this.addColumnsListeners(this.table.getColumns());
        this.addCellListeners();
        this.updateDatasetRunListeners();
    }

    public void addColumnsListeners(List<BaseColumn> columns) {
        for (BaseColumn column : columns) {
            ((StandardBaseColumn)column).getEventSupport().addPropertyChangeListener(this.layoutListener);
            if (!(column instanceof StandardColumnGroup)) continue;
            this.addColumnsListeners(((StandardColumnGroup)column).getColumns());
        }
    }

    public void removeColumnsListeners(List<BaseColumn> columns) {
        for (BaseColumn column : columns) {
            ((StandardBaseColumn)column).getEventSupport().removePropertyChangeListener(this.layoutListener);
            if (!(column instanceof StandardColumnGroup)) continue;
            this.removeColumnsListeners(((StandardColumnGroup)column).getColumns());
        }
    }

    public void addCellListeners() {
        List<TableCell> cells = ((TableObjectScene)this.getScene()).getTableMatrix().getCells();
        for (TableCell cell : cells) {
            if (cell.getCell() == null) continue;
            cell.getCell().getEventSupport().addPropertyChangeListener(this.cellLayoutListener);
        }
    }

    public void removeCellListeners() {
        List<TableCell> cells = ((TableObjectScene)this.getScene()).getTableMatrix().getCells();
        for (TableCell cell : cells) {
            if (cell.getCell() == null) continue;
            cell.getCell().getEventSupport().removePropertyChangeListener(this.cellLayoutListener);
        }
    }

    public void updateBounds() {
        int width = ((TableObjectScene)this.getScene()).getTableMatrix().getTableDesignWidth();
        width = Math.max(width, this.getElement().getWidth());
        int height = ((TableObjectScene)this.getScene()).getTableMatrix().getTableDesignHeight();
        height = Math.max(height, this.getElement().getHeight());
        this.setPreferredSize(new Dimension(width + 20, height + 20));
    }

    public JasperDesign getJasperDesign() {
        return ((AbstractReportObjectScene)this.getScene()).getJasperDesign();
    }

    protected void paintWidget() {
        super.paintWidget();
        Graphics2D g = this.getGraphics();
        Rectangle tableArea = this.getBounds();
        g.setPaint(new Color(232, 232, 234, 64));
        g.fill(tableArea);
        g.setPaint(Color.WHITE);
        Rectangle designArea = new Rectangle(0, 0, ((TableObjectScene)this.getScene()).getTableMatrix().getTableDesignWidth(), ((TableObjectScene)this.getScene()).getTableMatrix().getTableDesignHeight());
        g.fill(designArea);
        if (((AbstractReportObjectScene)this.getScene()).isGridVisible()) {
            this.paintGrid(g);
        }
        Stroke oldStroke = g.getStroke();
        double zoom = this.getScene().getZoomFactor();
        Stroke bs = Java2DUtils.getInvertedZoomedStroke((Stroke)oldStroke, (double)this.getScene().getZoomFactor());
        g.setStroke(bs);
        g.setFont(new Font("Arial", 0, 8));
        TableMatrix matrix = ((TableObjectScene)this.getScene()).getTableMatrix();
        List<TableCell> cells = matrix.getCells();
        for (TableCell tc : cells) {
            Rectangle bounds = matrix.getCellBounds(tc);
            TableWidget.paintCell(this, g, (Cell)tc.getCell(), bounds.x, bounds.y, bounds.width, bounds.height);
        }
        int width = ((TableObjectScene)this.getScene()).getTableMatrix().getTableDesignWidth();
        int height = ((TableObjectScene)this.getScene()).getTableMatrix().getTableDesignHeight();
        TableWidget.paintFrame(this, g, null, this.element.getStyle(), 0, 0, width, height);
        g.setStroke(oldStroke);
    }

    protected void paintGrid(Graphics2D g) {
        Paint oldPaint = g.getPaint();
        g.setPaint(this.getGridTexture());
        g.fill(this.getClientArea());
        g.setPaint(oldPaint);
    }

    private TexturePaint getGridTexture() {
        if (this.gridTexture == null || this.gridTexture.getImage().getWidth() != this.getGridSize()) {
            BufferedImage img = new BufferedImage(this.getGridSize(), this.getGridSize(), 1);
            Graphics2D g2 = img.createGraphics();
            g2.setColor(new Color(255, 255, 255, 255));
            g2.fill(this.getClientArea());
            g2.setColor(ReportObjectScene.GRID_LINE_COLOR);
            g2.setStroke(this.GRID_STROKE);
            g2.drawLine(this.getGridSize() - 1, 0, this.getGridSize() - 1, this.getGridSize() - 1);
            g2.drawLine(0, this.getGridSize() - 1, this.getGridSize() - 1, this.getGridSize() - 1);
            this.gridTexture = new TexturePaint(img, new Rectangle(0, 0, this.getGridSize(), this.getGridSize()));
        }
        return this.gridTexture;
    }

    private static TexturePaint getNullAreaTexture() {
        if (nullAreaTexture == null) {
            Image img2 = ImageUtilities.loadImage((String)"com/jaspersoft/ireport/components/table/null_area.png");
            BufferedImage img = new BufferedImage(16, 16, 2);
            img.getGraphics().drawImage(img2, 0, 0, null);
            nullAreaTexture = new TexturePaint(img, new Rectangle(0, 0, 16, 16));
        }
        return nullAreaTexture;
    }

    private static TexturePaint getNullTableAreaTexture() {
        if (nullTableAreaTexture == null) {
            Image img2 = ImageUtilities.loadImage((String)"com/jaspersoft/ireport/components/table/null_table_area.png");
            BufferedImage img = new BufferedImage(16, 16, 2);
            img.getGraphics().drawImage(img2, 0, 0, null);
            nullTableAreaTexture = new TexturePaint(img, new Rectangle(0, 0, 16, 16));
        }
        return nullTableAreaTexture;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int size) {
        this.gridSize = size;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("height") || evt.getPropertyName().equals("width")) {
            this.updateBounds();
            this.revalidate();
            this.getScene().validate();
        }
    }

    public void layoutChanged(PropertyChangeEvent evt) {
        ((TableObjectScene)this.getScene()).rebuildDocument();
        this.removeColumnsListeners(this.table.getColumns());
        this.removeCellListeners();
        this.addColumnsListeners(this.table.getColumns());
        this.addCellListeners();
    }

    public JRDesignComponentElement getElement() {
        return this.element;
    }

    public void setElement(JRDesignComponentElement element) {
        this.element = element;
    }

    public StandardTable getTable() {
        return this.table;
    }

    public void setTable(StandardTable table) {
        this.table = table;
    }

    public static void paintCell(Widget widget, Graphics2D g, Cell cell, int x, int y, int width, int height) {
        Paint oldPaint = g.getPaint();
        g.setColor(CELL_LABEL_COLOR);
        if (cell == null) {
            g.setPaint(TableWidget.getNullAreaTexture());
            g.fillRect(x, y, width, height);
            g.setPaint(CELL_LABEL_COLOR);
            g.drawRect(x, y, width, height);
            return;
        }
        g.drawRect(x, y, width, height);
        g.setPaint(AbstractReportObjectScene.DESIGN_LINE_COLOR);
        TableWidget.paintFrame(widget, g, cell.getLineBox(), cell.getStyle(), x, y, width, height);
        g.setPaint(oldPaint);
    }

    private static void paintFrame(Widget widget, Graphics2D g, JRLineBox box, JRStyle style, int x, int y, int w, int h) {
        JRDesignFrame frame = new JRDesignFrame((JRDefaultStyleProvider)((TableObjectScene)widget.getScene()).getJasperDesign());
        frame.setX(x);
        frame.setY(y);
        frame.setWidth(w);
        frame.setHeight(h);
        frame.setStyle(style);
        if (box != null) {
            frame.copyBox(box);
        }
        Paint oldPaint = g.getPaint();
        Shape oldClip = g.getClip();
        AffineTransform af = g.getTransform();
        g.setTransform(af);
        AffineTransform new_af = (AffineTransform)af.clone();
        AffineTransform translate = AffineTransform.getTranslateInstance(x, y);
        new_af.concatenate(translate);
        g.setTransform(new_af);
        if (frame != null) {
            DrawVisitor dv = ((TableObjectScene)widget.getScene()).getDrawVisitor();
            dv.setGraphics2D(g);
            dv.visitFrame((JRFrame)frame);
        }
        g.setTransform(af);
        g.setClip(oldClip);
        g.setPaint(oldPaint);
    }

    private void updateDatasetRunListeners() {
        this.table.getEventSupport().removePropertyChangeListener("datasetRun", this.datasetRunChangeListener);
        this.table.getEventSupport().addPropertyChangeListener("datasetRun", this.datasetRunChangeListener);
        JRDesignDataset dataset = null;
        if (this.table.getDatasetRun() != null && this.table.getDatasetRun().getDatasetName() != null) {
            dataset = (JRDesignDataset)this.getJasperDesign().getDatasetMap().get(this.table.getDatasetRun().getDatasetName());
        }
        if (dataset == this.currentDataset) {
            return;
        }
        if (dataset != this.currentDataset) {
            JRDesignGroup group;
            int i;
            List groups;
            if (this.currentDataset != null) {
                this.currentDataset.getEventSupport().removePropertyChangeListener(this.datasetRunChangeListener);
                groups = this.currentDataset.getGroupsList();
                for (i = 0; i < groups.size(); ++i) {
                    group = new JRDesignGroup();
                    group.getEventSupport().removePropertyChangeListener("name", this.datasetRunChangeListener);
                }
            }
            this.currentDataset = dataset;
            dataset.getEventSupport().addPropertyChangeListener(this.datasetRunChangeListener);
            groups = this.currentDataset.getGroupsList();
            for (i = 0; i < groups.size(); ++i) {
                group = new JRDesignGroup();
                group.getEventSupport().removePropertyChangeListener("name", this.datasetRunChangeListener);
                group.getEventSupport().addPropertyChangeListener("name", this.datasetRunChangeListener);
            }
        }
    }

    protected void datasetPropertyChanged(PropertyChangeEvent evt) {
        boolean refreshTableStructure = false;
        if (evt.getPropertyName().equals("name")) {
            if (evt.getSource() instanceof JRDesignDataset) {
                ((JRDesignDatasetRun)this.table.getDatasetRun()).setDatasetName(this.currentDataset.getName());
            } else if (evt.getSource() instanceof JRDesignGroup) {
                refreshTableStructure = true;
            }
        } else if (evt.getPropertyName().equals("datasetRun") || evt.getPropertyName().equals("groups")) {
            refreshTableStructure = true;
        }
        if (refreshTableStructure) {
            this.updateDatasetRunListeners();
            this.layoutChanged(evt);
        }
    }
}

