/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.Item;
import org.netbeans.modules.palette.Model;
import org.netbeans.modules.palette.ModelListener;
import org.netbeans.modules.palette.Settings;
import org.netbeans.modules.palette.Utils;
import org.netbeans.modules.palette.ui.CategoryDescriptor;
import org.netbeans.modules.palette.ui.DnDSupport;
import org.netbeans.spi.palette.PaletteController;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class PalettePanel
extends JPanel
implements Scrollable {
    private static PalettePanel theInstance;
    private PaletteController controller;
    private Model model;
    private Settings settings;
    private ModelListener modelListener;
    private PropertyChangeListener settingsListener;
    private CategoryDescriptor[] descriptors = new CategoryDescriptor[0];
    private Category selectedCategory;
    private Object lock = new Object();
    private MouseListener mouseListener;
    private JScrollPane scrollPane;
    private DnDSupport dndSupport;

    private PalettePanel() {
        this.setLayout(new PaletteLayoutManager());
        this.addMouseListener(this.mouseListener());
        this.dndSupport = new DnDSupport(this);
        this.setBackground(UIManager.getColor("Panel.background"));
    }

    public static synchronized PalettePanel getDefault() {
        if (null == theInstance) {
            theInstance = new PalettePanel();
        }
        return theInstance;
    }

    public JScrollPane getScrollPane() {
        if (null == this.scrollPane) {
            this.scrollPane = new JScrollPane(this);
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.scrollPane.addMouseListener(this.mouseListener());
            this.scrollPane.getViewport().setBackground(UIManager.getColor("Panel.background"));
            this.scrollPane.setViewportBorder(null);
        }
        return this.scrollPane;
    }

    CategoryDescriptor getCategoryDescriptor(Category category) {
        for (int i = 0; i < this.descriptors.length; ++i) {
            CategoryDescriptor categoryDescriptor = this.descriptors[i];
            if (categoryDescriptor.getCategory() != category) continue;
            return categoryDescriptor;
        }
        return null;
    }

    private CategoryDescriptor[] computeDescriptors(Category[] categoryArray) {
        if (null == categoryArray) {
            return new CategoryDescriptor[0];
        }
        categoryArray = this.getVisibleCategories(categoryArray);
        CategoryDescriptor[] categoryDescriptorArray = new CategoryDescriptor[categoryArray.length];
        for (int i = 0; i < categoryArray.length; ++i) {
            Category category = categoryArray[i];
            CategoryDescriptor categoryDescriptor = this.getCategoryDescriptor(category);
            if (categoryDescriptor == null) {
                categoryDescriptor = new CategoryDescriptor(this, category);
                categoryDescriptor.setShowNames(this.getSettings().getShowItemNames());
                categoryDescriptor.setIconSize(this.getSettings().getIconSize());
            } else {
                categoryDescriptor.refresh();
            }
            categoryDescriptor.setWidth(this.getWidth());
            categoryDescriptorArray[i] = categoryDescriptor;
        }
        return categoryDescriptorArray;
    }

    private Category[] getVisibleCategories(Category[] categoryArray) {
        ArrayList<Category> arrayList = new ArrayList<Category>(categoryArray.length);
        for (int i = 0; i < categoryArray.length; ++i) {
            if (!this.settings.isVisible(categoryArray[i])) continue;
            arrayList.add(categoryArray[i]);
        }
        return arrayList.toArray(new Category[arrayList.size()]);
    }

    void computeHeights(Category category) {
        this.computeHeights(this.descriptors, category);
    }

    private void computeHeights(CategoryDescriptor[] categoryDescriptorArray, Category category) {
        if (categoryDescriptorArray == null || categoryDescriptorArray.length <= 0) {
            return;
        }
        this.revalidate();
    }

    private static boolean arrayContains(Object[] objectArray, Object object) {
        if (objectArray == null || object == null) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != object) continue;
            return true;
        }
        return false;
    }

    private void setDescriptors(CategoryDescriptor[] categoryDescriptorArray) {
        CategoryDescriptor categoryDescriptor;
        int n;
        for (n = 0; n < this.descriptors.length; ++n) {
            categoryDescriptor = this.descriptors[n];
            if (PalettePanel.arrayContains(categoryDescriptorArray, categoryDescriptor)) continue;
            this.remove(categoryDescriptor.getComponent());
            this.dndSupport.remove(categoryDescriptor);
        }
        for (n = 0; n < categoryDescriptorArray.length; ++n) {
            categoryDescriptor = categoryDescriptorArray[n];
            if (PalettePanel.arrayContains(this.descriptors, categoryDescriptor)) continue;
            this.add(categoryDescriptor.getComponent());
            this.dndSupport.add(categoryDescriptor);
        }
        if (this.descriptors.length == 0 && categoryDescriptorArray.length > 0) {
            n = 0;
            for (int i = 0; i < categoryDescriptorArray.length; ++i) {
                if (!categoryDescriptorArray[i].isOpened()) continue;
                n = 1;
                break;
            }
            if (n == 0) {
                categoryDescriptorArray[0].setOpened(true);
            }
        }
        this.descriptors = categoryDescriptorArray;
        this.revalidate();
    }

    public void doRefresh() {
        if (null != this.controller) {
            this.controller.refresh();
        }
    }

    public void refresh() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = PalettePanel.this.lock;
                synchronized (object) {
                    PalettePanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    CategoryDescriptor[] categoryDescriptorArray = PalettePanel.this.computeDescriptors(null != PalettePanel.this.model ? PalettePanel.this.model.getCategories() : null);
                    PalettePanel.this.setDescriptors(categoryDescriptorArray);
                    if (null != PalettePanel.this.settings) {
                        PalettePanel.this.setIconSize(PalettePanel.this.settings.getIconSize());
                        PalettePanel.this.setShowItemNames(PalettePanel.this.settings.getShowItemNames());
                        PalettePanel.this.setItemWidth(PalettePanel.this.settings.getShowItemNames() ? PalettePanel.this.settings.getItemWidth() : -1);
                    }
                    if (null != PalettePanel.this.model) {
                        Item item = PalettePanel.this.model.getSelectedItem();
                        Category category = PalettePanel.this.model.getSelectedCategory();
                        PalettePanel.this.setSelectedItemFromModel(category, item);
                    }
                    PalettePanel.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.refresh();
    }

    void select(Category category, Item item) {
        CategoryDescriptor categoryDescriptor;
        if (category != this.selectedCategory && (categoryDescriptor = this.findDescriptorFor(this.selectedCategory)) != null) {
            categoryDescriptor.setSelectedItem(null);
        }
        this.selectedCategory = category;
        if (null != this.model) {
            if (null == category || null == item) {
                this.model.clearSelection();
            } else {
                this.model.setSelectedItem(category.getLookup(), item.getLookup());
            }
        }
    }

    private void setSelectedItemFromModel(Category category, Item item) {
        CategoryDescriptor categoryDescriptor;
        if (null != this.selectedCategory && !this.selectedCategory.equals(category) && (categoryDescriptor = this.findDescriptorFor(this.selectedCategory)) != null) {
            categoryDescriptor.setSelectedItem(null);
        }
        if ((categoryDescriptor = this.findDescriptorFor(category)) == null) {
            return;
        }
        if (item != null) {
            this.selectedCategory = category;
        }
        categoryDescriptor.setSelectedItem(item);
    }

    private CategoryDescriptor findDescriptorFor(Category category) {
        if (null != this.descriptors) {
            for (int i = 0; i < this.descriptors.length; ++i) {
                CategoryDescriptor categoryDescriptor = this.descriptors[i];
                if (!categoryDescriptor.getCategory().equals(category)) continue;
                return categoryDescriptor;
            }
        }
        return null;
    }

    private void scrollToCategory(final Category category) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = PalettePanel.this.lock;
                synchronized (object) {
                    CategoryDescriptor categoryDescriptor = PalettePanel.this.findDescriptorFor(category);
                    if (null != categoryDescriptor) {
                        PalettePanel.this.scrollPane.validate();
                        Point point = categoryDescriptor.getComponent().getLocation();
                        PalettePanel.this.scrollPane.getViewport().setViewPosition(point);
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(PaletteController paletteController, Model model, Settings settings) {
        Object object = this.lock;
        synchronized (object) {
            if (model == this.model && settings == this.settings) {
                return;
            }
            Model model2 = this.model;
            if (this.model != null && null != this.modelListener) {
                this.model.removeModelListener(this.modelListener);
            }
            if (this.settings != null && null != this.settingsListener) {
                this.settings.removePropertyChangeListener(this.settingsListener);
            }
            this.model = model;
            this.settings = settings;
            this.controller = paletteController;
            this.selectedCategory = null;
            if (this.model != null) {
                this.model.addModelListener(this.getModelListener());
            }
            if (null != this.settings) {
                this.settings.addPropertyChangeListener(this.getSettingsListener());
            }
            this.refresh();
        }
    }

    private MouseListener mouseListener() {
        if (null == this.mouseListener) {
            this.mouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent) && null != PalettePanel.this.model) {
                        JPopupMenu jPopupMenu = Utilities.actionsToPopup((Action[])PalettePanel.this.model.getActions(), (Component)PalettePanel.this);
                        Utils.addCustomizationMenuItems(jPopupMenu, PalettePanel.this.getController(), PalettePanel.this.getSettings());
                        jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            };
        }
        return this.mouseListener;
    }

    private void setShowItemNames(boolean bl) {
        for (int i = 0; i < this.descriptors.length; ++i) {
            this.descriptors[i].setShowNames(bl);
        }
        this.repaint();
    }

    private void setIconSize(int n) {
        for (int i = 0; i < this.descriptors.length; ++i) {
            this.descriptors[i].setIconSize(n);
        }
        this.repaint();
    }

    private void setItemWidth(int n) {
        for (int i = 0; i < this.descriptors.length; ++i) {
            this.descriptors[i].setItemWidth(n);
        }
        this.repaint();
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 100;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 20;
    }

    public HelpCtx getHelpCtx() {
        HelpCtx helpCtx = null;
        if (null != this.getModel()) {
            Object object;
            Item item = this.getModel().getSelectedItem();
            if (null != item && null != (object = (Node)item.getLookup().lookup(Node.class))) {
                helpCtx = object.getHelpCtx();
            }
            if (null == helpCtx || HelpCtx.DEFAULT_HELP.equals((Object)helpCtx)) {
                Node node;
                object = null;
                for (int i = 0; i < this.descriptors.length; ++i) {
                    if (!this.descriptors[i].isSelected()) continue;
                    object = this.descriptors[i];
                    break;
                }
                if (null != object && null != (node = (Node)object.getCategory().getLookup().lookup(Node.class))) {
                    helpCtx = node.getHelpCtx();
                }
            }
            if ((null == helpCtx || HelpCtx.DEFAULT_HELP.equals((Object)helpCtx)) && null != (object = (Node)this.getModel().getRoot().lookup(Node.class))) {
                helpCtx = object.getHelpCtx();
            }
        }
        if (null == helpCtx || HelpCtx.DEFAULT_HELP.equals(helpCtx)) {
            helpCtx = new HelpCtx("CommonPalette");
        }
        return helpCtx;
    }

    private ModelListener getModelListener() {
        if (null == this.modelListener) {
            this.modelListener = new ModelListener(){

                public void categoriesAdded(Category[] categoryArray) {
                    PalettePanel.this.refresh();
                    if (null != categoryArray && categoryArray.length > 0) {
                        PalettePanel.this.scrollToCategory(categoryArray[0]);
                    }
                }

                public void categoriesRemoved(Category[] categoryArray) {
                    PalettePanel.this.refresh();
                }

                public void categoriesReordered() {
                    PalettePanel.this.refresh();
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("selectedItem".equals(propertyChangeEvent.getPropertyName())) {
                        Item item = PalettePanel.this.model.getSelectedItem();
                        Category category = PalettePanel.this.model.getSelectedCategory();
                        PalettePanel.this.setSelectedItemFromModel(category, item);
                    }
                }
            };
        }
        return this.modelListener;
    }

    private PropertyChangeListener getSettingsListener() {
        if (null == this.settingsListener) {
            this.settingsListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("isVisible".equals(propertyChangeEvent.getPropertyName())) {
                        PalettePanel.this.refresh();
                        for (int i = 0; null != PalettePanel.this.descriptors && i < PalettePanel.this.descriptors.length; ++i) {
                            PalettePanel.this.descriptors[i].computeItems();
                        }
                    } else if ("iconSize".equals(propertyChangeEvent.getPropertyName())) {
                        PalettePanel.this.setIconSize(PalettePanel.this.getSettings().getIconSize());
                    } else if ("showItemNames".equals(propertyChangeEvent.getPropertyName())) {
                        PalettePanel.this.setShowItemNames(PalettePanel.this.getSettings().getShowItemNames());
                        PalettePanel.this.setItemWidth(PalettePanel.this.getSettings().getShowItemNames() ? PalettePanel.this.getSettings().getItemWidth() : -1);
                    }
                }
            };
        }
        return this.settingsListener;
    }

    Model getModel() {
        return this.model;
    }

    Settings getSettings() {
        return this.settings;
    }

    PaletteController getController() {
        return this.controller;
    }

    public void updateUI() {
        super.updateUI();
        if (null != this.model) {
            this.model.refresh();
        }
    }

    private class PaletteLayoutManager
    implements LayoutManager {
        private PaletteLayoutManager() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            int n = PalettePanel.this.getWidth();
            int n2 = 0;
            for (int i = 0; i < PalettePanel.this.descriptors.length; ++i) {
                CategoryDescriptor categoryDescriptor = PalettePanel.this.descriptors[i];
                categoryDescriptor.setPositionY(n2);
                JComponent jComponent = categoryDescriptor.getComponent();
                jComponent.setSize(n, jComponent.getPreferredSize().height);
                n2 += categoryDescriptor.getComponent().getHeight();
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = 0;
            int n2 = PalettePanel.this.getWidth();
            for (int i = 0; i < PalettePanel.this.descriptors.length; ++i) {
                CategoryDescriptor categoryDescriptor = PalettePanel.this.descriptors[i];
                n += categoryDescriptor.getPreferredHeight(n2) + 1;
            }
            return new Dimension(10, n);
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

