/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import com.jaspersoft.ireport.JrxmlDataObject;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlEditorSupport;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.ThreadUtils;
import com.jaspersoft.ireport.designer.compiler.CompilationStatusEvent;
import com.jaspersoft.ireport.designer.compiler.CompilationStatusListener;
import com.jaspersoft.ireport.designer.menu.RunReportAction;
import com.jaspersoft.ireport.designer.tools.JrxmlPreviewToolbar;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.swing.JRViewerController;
import net.sf.jasperreports.swing.JRViewerPanel;
import org.jdesktop.swingx.JXBusyLabel;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

public class JrxmlPreviewView
extends TopComponent
implements MultiViewDescription,
MultiViewElement,
CompilationStatusListener {
    private boolean needRefresh = true;
    MultiViewElementCallback multiViewCallback = null;
    JRViewerController viewerContext = new JRViewerController(null, null);
    JrxmlPreviewToolbar viewerToolbar = new JrxmlPreviewToolbar(this, this.viewerContext);
    private JrxmlEditorSupport support;
    private JrxmlVisualView visualView = null;
    int currentStatus = -1;
    JXBusyLabel label = new JXBusyLabel();

    public JrxmlPreviewView(JrxmlEditorSupport ed, JrxmlVisualView visualView) {
        this.support = ed;
        IReportManager.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent evt) {
                if (evt.getKey() != null && evt.getKey().equals("RecentFiles")) {
                    return;
                }
                JrxmlPreviewView.this.setNeedRefresh(true);
            }
        });
        this.visualView = visualView;
    }

    public int getPersistenceType() {
        return 2;
    }

    public String getDisplayName() {
        return I18n.getString("view.preview");
    }

    public Image getIcon() {
        Node nd = ((JrxmlDataObject)this.support.getDataObject()).getNodeDelegate();
        return nd.getIcon(1);
    }

    public String preferredID() {
        return "Preview";
    }

    public void componentDeactivated() {
    }

    public void componentActivated() {
    }

    public void componentHidden() {
    }

    public void componentShowing() {
        if (this.isNeedRefresh()) {
            this.setJasperPrint(null);
            this.updateUI();
            RunReportAction.runReport(this.support);
        }
    }

    public void componentClosed() {
    }

    public void componentOpened() {
    }

    public void setJasperPrint(final JasperPrint print) {
        if (print != null) {
            this.setNeedRefresh(false);
        }
        ThreadUtils.invokeInAWTThread(new Runnable(){

            public void run() {
                JrxmlPreviewView.this.removeAll();
                if (print != null) {
                    JRViewerPanel viewerPanel = new JRViewerPanel(JrxmlPreviewView.this.viewerContext){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        protected void paintPage(Graphics2D grx) {
                            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(IReportManager.getJRExtensionsClassLoader());
                                super.paintPage(grx);
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(oldClassLoader);
                            }
                        }
                    };
                    JrxmlPreviewView.this.add((Component)viewerPanel, "Center");
                    JrxmlPreviewView.this.viewerContext.loadReport(print);
                    JrxmlPreviewView.this.viewerToolbar.init();
                    JrxmlPreviewView.this.viewerContext.refreshPage();
                    viewerPanel.updateUI();
                }
                JrxmlPreviewView.this.updateUI();
            }
        });
    }

    public MultiViewElement createElement() {
        this.setLayout(new BorderLayout());
        try {
            this.associateLookup(this.visualView.getLookup());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public JComponent getToolbarRepresentation() {
        return new JrxmlPreviewToolbar(this, this.viewerContext);
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.multiViewCallback = callback;
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    public void requestActive() {
        if (this.multiViewCallback != null) {
            this.multiViewCallback.requestActive();
        } else {
            super.requestActive();
        }
    }

    public boolean isNeedRefresh() {
        return this.needRefresh;
    }

    public void setNeedRefresh(boolean needRefresh) {
        this.needRefresh = needRefresh;
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void compilationStatus(CompilationStatusEvent e) {
        if (e.getStatus() == 0) {
            if (e.getStatus() != this.currentStatus) {
                ThreadUtils.invokeInAWTThread(new Runnable(){

                    public void run() {
                        JrxmlPreviewView.this.removeAll();
                        JPanel p = new JPanel();
                        p.setLayout(new GridBagLayout());
                        JrxmlPreviewView.this.label.setBusy(true);
                        p.add((Component)JrxmlPreviewView.this.label);
                        JrxmlPreviewView.this.add(p, "Center");
                        JrxmlPreviewView.this.updateUI();
                    }
                });
            }
        } else {
            ThreadUtils.invokeInAWTThread(new Runnable(){

                public void run() {
                    JrxmlPreviewView.this.label.setBusy(false);
                }
            });
        }
        this.currentStatus = e.getStatus();
    }

    public JrxmlVisualView getVisualView() {
        return this.visualView;
    }

    public void setVisualView(JrxmlVisualView visualView) {
        this.visualView = visualView;
    }
}

