/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.GenericDesignerPanel;
import com.jaspersoft.ireport.designer.GenericDesignerPanelFactory;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.crosstab.CrosstabObjectScene;
import com.jaspersoft.ireport.designer.dnd.DesignerDropTarget;
import com.jaspersoft.ireport.designer.ruler.RulerPanel;
import com.jaspersoft.ireport.designer.utils.MultilineToolbarLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.model.ObjectSceneListener;
import org.netbeans.api.visual.model.ObjectState;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportDesignerPanel
extends JPanel
implements ObjectSceneListener {
    public static final String JASPERDESIGN_PROPERTY = "jasperdesign";
    private boolean adjustingSelection = false;
    private boolean firstLoad = true;
    private final Set<ObjectSceneListener> listeners = new HashSet<ObjectSceneListener>(1);
    private List<GenericDesignerPanel> deisgnPanels = new ArrayList<GenericDesignerPanel>();
    JasperDesign jasperDesign = null;
    private int activePanelIndex = -1;
    private RulerPanel hRuler = null;
    private RulerPanel vRuler = null;
    private ReportObjectScene scene = null;
    private JComponent myView = null;
    boolean refreshing = false;
    private static double[] zoomSteps = new double[]{0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
    private ButtonGroup buttonGroup1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelContainer;
    private JPanel jPanelMainReport;
    private JScrollPane jScrollPaneMainReport;
    private JToggleButton jToggleButtonMain;
    private JToolBar jToolBar1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addObjectSelectionListener(ObjectSceneListener l) {
        Set<ObjectSceneListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeObjectSelectionListener(ObjectSceneListener l) {
        Set<ObjectSceneListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireSelectionChangeEvent(ObjectSceneEvent arg0, Set<Object> arg1, Set<Object> arg2) {
        Iterator<ObjectSceneListener> it;
        Set<ObjectSceneListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ObjectSceneListener>(this.listeners).iterator();
        }
        while (it.hasNext()) {
            if (this.isAdjustingSelection()) continue;
            it.next().selectionChanged(arg0, arg1, arg2);
        }
    }

    public RulerPanel getHRuler() {
        return this.hRuler;
    }

    public RulerPanel getVRuler() {
        return this.vRuler;
    }

    public boolean isGridVisible() {
        return this.getActiveScene().isGridVisible();
    }

    public void setGridVisible(boolean b) {
        this.getActiveScene().setGridVisible(b);
    }

    public boolean isSnapToGrid() {
        return this.getActiveScene().isSnapToGrid();
    }

    public void setSnapToGrid(boolean b) {
        this.getActiveScene().setSnapToGrid(b);
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
        this.getScene().setJasperDesign(jasperDesign);
        if (this.firstLoad) {
            this.firstLoad = false;
            if (jasperDesign.getProperty("ireport.zoom") != null) {
                try {
                    int y;
                    int x;
                    final double zoom = Double.parseDouble(jasperDesign.getProperty("ireport.zoom"));
                    final Rectangle rect = new Rectangle(0, 0, 0, 0);
                    if (jasperDesign.getProperty("ireport.x") != null && rect.width < (x = Integer.parseInt(jasperDesign.getProperty("ireport.x")))) {
                        rect.x = x;
                    }
                    if (jasperDesign.getProperty("ireport.y") != null && rect.height < (y = Integer.parseInt(jasperDesign.getProperty("ireport.y")))) {
                        rect.y = y;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ReportDesignerPanel.this.scene.setZoomFactor(zoom);
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    Rectangle visibleRect = ReportDesignerPanel.this.scene.getView().getVisibleRect();
                                    if (rect.x != 0) {
                                        visibleRect.x = rect.x;
                                        visibleRect.width += rect.x;
                                    }
                                    if (rect.y != 0) {
                                        visibleRect.y = rect.y;
                                        visibleRect.height += rect.y;
                                    }
                                    ReportDesignerPanel.this.scene.getView().scrollRectToVisible(visibleRect);
                                }
                            });
                        }
                    });
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        for (GenericDesignerPanel p : this.getDeisgnPanels()) {
            if (p.getScene() == null) continue;
            p.getScene().removeObjectSceneListener(this, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
        }
        this.getDeisgnPanels().clear();
        this.activePanelIndex = -1;
        if (jasperDesign != null) {
            List<JRDesignElement> elements = ModelUtils.getAllElements(jasperDesign);
            for (JRDesignElement element : elements) {
                this.addElementPanel(element, jasperDesign);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ReportDesignerPanel.this.updateGenericDesignerPanels();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ReportDesignerPanel.this.firePropertyChange(ReportDesignerPanel.JASPERDESIGN_PROPERTY, null, ReportDesignerPanel.this.getJasperDesign());
            }
        });
    }

    public GenericDesignerPanel getElementPanel(JRDesignElement element) {
        for (GenericDesignerPanel p : this.getDeisgnPanels()) {
            if (p.getElement() != element) continue;
            return p;
        }
        return null;
    }

    public boolean addElementPanel(JRDesignElement element, JasperDesign design) {
        GenericDesignerPanelFactory factory;
        if (this.getElementPanel(element) != null) {
            return false;
        }
        GenericDesignerPanel panel = null;
        Collection genericDesignerPanelFactoryInstances = Lookups.forPath((String)"ireport/components/designers").lookupAll(GenericDesignerPanelFactory.class);
        Iterator it = genericDesignerPanelFactoryInstances.iterator();
        while (it.hasNext() && (!(factory = (GenericDesignerPanelFactory)it.next()).accept(element) || (panel = factory.createDesigner(element, design)) == null)) {
        }
        if (panel == null) {
            return false;
        }
        this.getDeisgnPanels().add(panel);
        System.out.println("PAnel added for element: " + element);
        System.out.flush();
        if (panel.getScene() != null) {
            panel.getScene().addObjectSceneListener(this, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
            panel.getScene().addObjectSceneListener(this, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_ADDED});
            panel.getScene().addObjectSceneListener(this, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_REMOVED});
        }
        return true;
    }

    public ReportDesignerPanel() {
        this.initComponents();
        this.scene = new ReportObjectScene();
        this.myView = this.scene.getJComponent();
        this.jScrollPaneMainReport.setViewportView(this.myView);
        this.myView.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getModifiers() == 0) {
                    int units = e.getUnitsToScroll() * 16;
                    int v = ReportDesignerPanel.this.jScrollPaneMainReport.getVerticalScrollBar().getValue();
                    v = Math.max(v, ReportDesignerPanel.this.jScrollPaneMainReport.getVerticalScrollBar().getMinimum());
                    v = Math.min(v, ReportDesignerPanel.this.jScrollPaneMainReport.getVerticalScrollBar().getMaximum());
                    ReportDesignerPanel.this.jScrollPaneMainReport.getVerticalScrollBar().setValue(v + units);
                }
            }
        });
        this.hRuler = new RulerPanel(this.scene);
        this.myView.addMouseMotionListener(this.hRuler);
        this.hRuler.addGuideLineChangedListener(this.scene);
        this.jPanel1.add((Component)this.hRuler, "Center");
        this.vRuler = new RulerPanel(this.scene);
        this.vRuler.setVertical(true);
        this.myView.addMouseMotionListener(this.vRuler);
        this.vRuler.addGuideLineChangedListener(this.scene);
        this.jPanel2.add((Component)this.vRuler, "Center");
        this.myView.setDropTarget(new DesignerDropTarget(this.scene));
        this.scene.addObjectSceneListener(this, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
        this.scene.addObjectSceneListener(this, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_REMOVED});
        this.scene.addObjectSceneListener(this, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_ADDED});
        IReportManager.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent evt) {
                try {
                    Mutex.EVENT.readAccess(new Runnable(){

                        public void run() {
                            try {
                                if (ReportDesignerPanel.this.setRefreshing(true)) {
                                    return;
                                }
                                ReportDesignerPanel.this.getScene().refreshDocument();
                                ReportDesignerPanel.this.getScene().validate();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ReportDesignerPanel.this.setRefreshing(false);
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public synchronized boolean setRefreshing(boolean b) {
        boolean old = this.refreshing;
        this.refreshing = b;
        return old;
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    public void zoomIn() {
        AbstractReportObjectScene sc = this.getActiveScene();
        double zoom = sc.getZoomFactor();
        for (int i = 0; i < zoomSteps.length; ++i) {
            if (!(zoom < zoomSteps[i])) continue;
            zoom = zoomSteps[i];
            break;
        }
        sc.setZoomFactor(zoom);
        sc.validate();
    }

    public void zoomOut() {
        AbstractReportObjectScene sc = this.getActiveScene();
        double zoom = sc.getZoomFactor();
        for (int i = zoomSteps.length - 1; i >= 0; --i) {
            if (!(zoom > zoomSteps[i])) continue;
            zoom = zoomSteps[i];
            break;
        }
        sc.setZoomFactor(zoom);
        sc.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedObjects(Set selectedObjects) {
        boolean oldValue = this.setAdjustingSelection(true);
        try {
            int count0 = this.setSelectedObjects(selectedObjects, this.getScene());
            int selectedIndex = -1;
            int cIndex = 0;
            if (selectedObjects.size() == 1 && selectedObjects.iterator().next() instanceof JRDesignElement && this.getElementPanel((JRDesignElement)selectedObjects.iterator().next()) != null) {
                selectedIndex = this.getActiveDesignerIndex();
            } else {
                for (GenericDesignerPanel p : this.getDeisgnPanels()) {
                    AbstractReportObjectScene sc = p.getScene();
                    int count = this.setSelectedObjects(selectedObjects, sc);
                    if (count0 < count) {
                        selectedIndex = cIndex;
                    }
                    ++cIndex;
                }
            }
            if (selectedObjects.size() != 0 && this.getDeisgnPanels().size() > 0) {
                this.setActiveDesignerIndex(selectedIndex);
            }
            if (this.getActiveScene() != null) {
                this.getActiveScene().validate();
            }
        }
        finally {
            this.setAdjustingSelection(oldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setSelectedObjects(Set selectedObjects, AbstractReportObjectScene sc) {
        if (sc == null) {
            return 0;
        }
        boolean oldValue = this.setAdjustingSelection(true);
        ArrayList list = new ArrayList();
        int otherObjects = 0;
        try {
            for (Object obj : selectedObjects) {
                if (sc.getObjects().contains(obj)) {
                    list.add(obj);
                    continue;
                }
                if (!(obj instanceof JRCellContents) || !(sc instanceof CrosstabObjectScene) || !ModelUtils.getAllCells(((CrosstabObjectScene)sc).getDesignCrosstab()).contains(obj)) continue;
                ++otherObjects;
            }
            sc.setSelectedObjects(new HashSet(list));
        }
        finally {
            this.setAdjustingSelection(oldValue);
        }
        return list.size() + otherObjects;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanelMainReport = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jScrollPaneMainReport = new JScrollPane();
        this.jToolBar1 = new JToolBar();
        this.jToggleButtonMain = new JToggleButton();
        this.jPanelContainer = new JPanel();
        this.jPanel1.setBackground(new Color(255, 204, 204));
        this.jPanel1.setMinimumSize(new Dimension(100, 20));
        this.jPanel1.setPreferredSize(new Dimension(100, 20));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setBackground(new Color(255, 255, 204));
        this.jPanel2.setMinimumSize(new Dimension(20, 0));
        this.jPanel2.setPreferredSize(new Dimension(20, 0));
        this.jPanel2.setLayout(new BorderLayout());
        this.jScrollPaneMainReport.setBorder(null);
        GroupLayout jPanelMainReportLayout = new GroupLayout((Container)this.jPanelMainReport);
        this.jPanelMainReport.setLayout((LayoutManager)jPanelMainReportLayout);
        jPanelMainReportLayout.setHorizontalGroup((GroupLayout.Group)jPanelMainReportLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelMainReportLayout.createSequentialGroup().add((Component)this.jPanel2, -2, 20, -2).add(0, 0, 0).add((GroupLayout.Group)jPanelMainReportLayout.createParallelGroup(1).add(2, (Component)this.jPanel1, -1, 535, Short.MAX_VALUE).add((Component)this.jScrollPaneMainReport, -1, 535, Short.MAX_VALUE))));
        jPanelMainReportLayout.setVerticalGroup((GroupLayout.Group)jPanelMainReportLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelMainReportLayout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).add(0, 0, 0).add((GroupLayout.Group)jPanelMainReportLayout.createParallelGroup(1).add((Component)this.jPanel2, -1, 409, Short.MAX_VALUE).add((Component)this.jScrollPaneMainReport, -1, 409, Short.MAX_VALUE))));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.buttonGroup1.add(this.jToggleButtonMain);
        this.jToggleButtonMain.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/report-16.png")));
        this.jToggleButtonMain.setText(NbBundle.getMessage(ReportDesignerPanel.class, (String)"ReportDesignerPanel.jToggleButtonMain.text"));
        this.jToggleButtonMain.setFocusable(false);
        this.jToggleButtonMain.setHorizontalTextPosition(4);
        this.jToggleButtonMain.setVerticalTextPosition(3);
        this.jToggleButtonMain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportDesignerPanel.this.jToggleButtonMainActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonMain);
        this.setLayout(new BorderLayout());
        this.jPanelContainer.setLayout(new BorderLayout());
        this.add((Component)this.jPanelContainer, "Center");
    }

    private void jToggleButtonMainActionPerformed(ActionEvent evt) {
        this.setActiveDesignerIndex(-1);
    }

    public ReportObjectScene getScene() {
        return this.scene;
    }

    public void setScene(ReportObjectScene scene) {
        this.scene = scene;
    }

    private void updateGenericDesignerPanels() {
        if (this.getDeisgnPanels().size() > 0) {
            this.jToolBar1.removeAll();
            this.jToolBar1.add(this.jToggleButtonMain);
            this.jToolBar1.setLayout(new MultilineToolbarLayout());
            HashMap indexes = new HashMap();
            for (int i = 0; i < this.getDeisgnPanels().size(); ++i) {
                GenericDesignerPanel panel = this.getDeisgnPanels().get(i);
                if (indexes.containsKey(panel.getClass())) {
                    Integer index = (Integer)indexes.get(panel.getClass());
                    indexes.put(panel.getClass(), index + 1);
                } else {
                    indexes.put(panel.getClass(), 1);
                }
                JToggleButton jToggleButton = new JToggleButton(MessageFormat.format(panel.getLabel(), indexes.get(panel.getClass()), panel.getElement().getKey()));
                this.buttonGroup1.add(jToggleButton);
                jToggleButton.setFocusable(false);
                jToggleButton.setActionCommand("" + i);
                jToggleButton.setHorizontalTextPosition(4);
                jToggleButton.setVerticalTextPosition(3);
                Icon icon = panel.getIcon();
                if (icon != null) {
                    jToggleButton.setIcon(panel.getIcon());
                }
                jToggleButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        int cindex = Integer.parseInt(evt.getActionCommand());
                        ReportDesignerPanel.this.setActiveDesignerIndex(cindex);
                    }
                });
                this.jToolBar1.add(jToggleButton);
            }
            this.add((Component)this.jToolBar1, "South");
            this.setActiveDesignerIndex(this.activePanelIndex);
        } else {
            this.remove(this.jToolBar1);
            this.setActiveDesignerIndex(-1);
        }
        this.updateUI();
    }

    public int getActiveDesignerIndex() {
        return this.activePanelIndex;
    }

    public GenericDesignerPanel getActiveDesignerPanel() {
        return this.getDeisgnPanels().get(this.activePanelIndex);
    }

    public void setActiveDesignerIndex(int cIndex) {
        if (cIndex >= this.getDeisgnPanels().size()) {
            throw new IndexOutOfBoundsException();
        }
        this.activePanelIndex = cIndex;
        this.jPanelContainer.removeAll();
        if (cIndex == -1) {
            this.jPanelContainer.add((Component)this.jPanelMainReport, "Center");
            this.jToggleButtonMain.setSelected(true);
        } else {
            this.jPanelContainer.add((Component)this.getDeisgnPanels().get(cIndex).getComponent(), "Center");
            if (this.jToolBar1.getComponentCount() > cIndex + 1) {
                ((JToggleButton)this.jToolBar1.getComponent(cIndex + 1)).setSelected(true);
            }
        }
        try {
            List<JRDesignElement> elements;
            if (this.getActiveScene() != null && !this.isAdjustingSelection() && (elements = this.getActiveScene().getSelectionManager().getSelectedElements()) != null) {
                ExplorerManager manager = ExplorerManager.find((Component)this);
                ArrayList<Node> nodeList = new ArrayList<Node>();
                for (JRDesignElement ele : elements) {
                    Node node = IReportManager.getInstance().findNodeOf(ele, manager.getRootContext());
                    if (node == null) continue;
                    nodeList.add(node);
                }
                manager.setSelectedNodes(nodeList.toArray(new Node[nodeList.size()]));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.jPanelContainer.updateUI();
    }

    public AbstractReportObjectScene getActiveScene() {
        if (this.getActiveDesignerIndex() == -1) {
            return this.getScene();
        }
        return this.getDeisgnPanels().get(this.getActiveDesignerIndex()).getScene();
    }

    public void objectAdded(ObjectSceneEvent evt, Object elem) {
        boolean b;
        if (elem instanceof JRDesignElement && this.getElementPanel((JRDesignElement)elem) == null && (b = this.addElementPanel((JRDesignElement)elem, this.getJasperDesign()))) {
            this.activePanelIndex = this.getDeisgnPanels().size() - 1;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ReportDesignerPanel.this.updateGenericDesignerPanels();
                }
            });
        }
    }

    public void objectRemoved(ObjectSceneEvent arg0, Object arg1) {
        if (arg1 instanceof JRDesignElement) {
            for (int i = 0; i < this.getDeisgnPanels().size(); ++i) {
                GenericDesignerPanel panel = this.getDeisgnPanels().get(i);
                if (panel.getElement() != arg1) continue;
                if (panel.getScene() != null) {
                    panel.getScene().removeObjectSceneListener(this, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
                    panel.getScene().removeObjectSceneListener(this, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_REMOVED});
                    panel.getScene().removeObjectSceneListener(this, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_ADDED});
                }
                if (this.activePanelIndex >= i) {
                    --this.activePanelIndex;
                }
                this.getDeisgnPanels().remove(panel);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ReportDesignerPanel.this.updateGenericDesignerPanels();
                    }
                });
                return;
            }
        }
    }

    public void objectStateChanged(ObjectSceneEvent arg0, Object arg1, ObjectState arg2, ObjectState arg3) {
    }

    public void selectionChanged(ObjectSceneEvent se, Set<Object> arg1, Set<Object> arg2) {
        if (this.isAdjustingSelection()) {
            return;
        }
        this.fireSelectionChangeEvent(se, arg1, arg2);
    }

    public void highlightingChanged(ObjectSceneEvent arg0, Set<Object> arg1, Set<Object> arg2) {
    }

    public void hoverChanged(ObjectSceneEvent arg0, Object arg1, Object arg2) {
    }

    public void focusChanged(ObjectSceneEvent arg0, Object arg1, Object arg2) {
    }

    public AbstractReportObjectScene getSceneOf(Object obj) {
        if (this.getScene().getObjects().contains(obj)) {
            return this.getScene();
        }
        for (GenericDesignerPanel p : this.getDeisgnPanels()) {
            AbstractReportObjectScene sc = p.getScene();
            if (sc == null || !sc.getObjects().contains(obj)) continue;
            return sc;
        }
        return null;
    }

    public boolean isAdjustingSelection() {
        return this.adjustingSelection;
    }

    public boolean setAdjustingSelection(boolean adjustingSelection) {
        boolean oldValue = this.adjustingSelection;
        this.adjustingSelection = adjustingSelection;
        return oldValue;
    }

    public List<GenericDesignerPanel> getDeisgnPanels() {
        return this.deisgnPanels;
    }
}

