/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.connection.CustomHTTPAuthenticator;
import com.jaspersoft.ireport.designer.connection.gui.PasswordDialog;
import com.jaspersoft.ireport.designer.connection.gui.XMLADataSourceConnectionEditor;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Component;
import java.net.Authenticator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import net.sf.jasperreports.engine.JRException;
import rex.graphics.datasourcetree.elements.CatalogElement;
import rex.graphics.datasourcetree.elements.DataSourceTreeElement;
import rex.metadata.ServerMetadata;

public class JRXMLADataSourceConnection
extends IReportConnection {
    private static String soapMessageFactoryClass = null;
    private static String soapConnectionFactoryClass = null;
    private String url;
    private String username;
    private String password = null;
    private boolean savePassword;
    private String datasource;
    private String catalog;
    private String cube;

    public static void setAxisSOAPClientConfig() {
        try {
            if (soapMessageFactoryClass == null && (soapMessageFactoryClass = System.getProperty("javax.xml.soap.MessageFactory")) == null) {
                soapMessageFactoryClass = MessageFactory.newInstance().getClass().getName();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (soapConnectionFactoryClass == null && (soapConnectionFactoryClass = System.getProperty("javax.xml.soap.SOAPConnectionFactory")) == null) {
                soapConnectionFactoryClass = SOAPConnectionFactory.newInstance().getClass().getName();
            }
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        System.setProperty("javax.xml.soap.MessageFactory", "org.apache.axis.soap.MessageFactoryImpl");
        System.setProperty("javax.xml.soap.SOAPConnectionFactory", "org.apache.axis.soap.SOAPConnectionFactoryImpl");
    }

    public static void restoreSOAPClientConfig() {
        if (soapMessageFactoryClass != null) {
            System.setProperty("javax.xml.soap.MessageFactory", soapMessageFactoryClass);
        }
        if (soapConnectionFactoryClass != null) {
            System.setProperty("javax.xml.soap.SOAPConnectionFactory", soapConnectionFactoryClass);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", Misc.nvl(this.getUrl(), ""));
        map.put("datasource", Misc.nvl(this.getDatasource(), ""));
        map.put("catalog", Misc.nvl(this.getCatalog(), ""));
        map.put("cube", Misc.nvl(this.getCube(), ""));
        map.put("Username", Misc.nvl(this.getUsername(), ""));
        if (this.isSavePassword()) {
            map.put("Password", Misc.nvl(this.getPassword(), ""));
        } else {
            map.put("Password", "");
        }
        map.put("SavePassword", "" + this.isSavePassword());
        return map;
    }

    public void loadProperties(HashMap map) {
        this.setUrl((String)map.get("url"));
        this.setDatasource((String)map.get("datasource"));
        this.setCatalog((String)map.get("catalog"));
        this.setCube((String)map.get("cube"));
        this.setUsername((String)map.get("Username"));
        this.setSavePassword(("" + map.get("SavePassword")).equals("true"));
        if (this.isSavePassword()) {
            this.setPassword(Misc.nvl((String)map.get("Password"), ""));
        }
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getCube() {
        return this.cube;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    public boolean isJRDataSource() {
        return false;
    }

    public Map getSpecialParameters(Map map) throws JRException {
        JRXMLADataSourceConnection.setAxisSOAPClientConfig();
        map.put("XMLA_DATA_URL", this.getUrl());
        map.put("XMLA_DATA_DATASOURCE", this.getDatasource());
        map.put("XMLA_DATA_CATALOG", this.getCatalog());
        map.put("XMLA_URL", this.getUrl());
        map.put("XMLA_DATASOURCE", this.getDatasource());
        map.put("XMLA_CATALOG", this.getCatalog());
        if (this.username != null && this.username.length() > 0) {
            String tmpPassword = this.getPassword();
            Authenticator.setDefault(new CustomHTTPAuthenticator(this.username, tmpPassword));
            map.put("XMLA_USER", this.getUsername());
            map.put("XMLA_PASSWORD", tmpPassword);
        }
        return map;
    }

    public Map disposeSpecialParameters(Map map) {
        JRXMLADataSourceConnection.restoreSOAPClientConfig();
        return map;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        if (this.isSavePassword()) {
            return this.password;
        }
        try {
            return PasswordDialog.askPassword();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public String getDescription() {
        return "XMLA Server";
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new XMLADataSourceConnectionEditor();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void test() throws Exception {
        DataSourceTreeElement[] cats;
        String urlstr = this.getUrl();
        Authenticator.setDefault(new CustomHTTPAuthenticator(this.getUsername(), this.getPassword()));
        String dataSource = this.getDatasource();
        String catalog = this.getCatalog();
        ServerMetadata smd = new ServerMetadata(urlstr, (Component)Misc.getMainWindow());
        if (!smd.isValidUrl()) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test failed! Unable to connect to url.", "", 1);
            return;
        }
        DataSourceTreeElement[] dste = smd.discoverDataSources();
        if (dste == null || dste.length == 0) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test failed! No datasources found.", "", 1);
            return;
        }
        boolean found = false;
        int intI = 0;
        if (dataSource == null || dataSource.length() <= 0) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test successful! Connected to server, but no datasource specified.", "", 1);
            return;
        }
        while (!found && intI < dste.length) {
            if (dataSource.compareTo(dste[intI].getDataSourceInfo()) == 0) {
                found = true;
                continue;
            }
            ++intI;
        }
        if (!found) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("Connection test failed! Datasource {0} not found.", new Object[]{dataSource + ""}), "", 1);
            return;
        }
        if (catalog != null && catalog.length() > 0) {
            found = false;
            cats = dste[intI].getChildren();
            if (cats == null || cats.length == 0) {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test failed! No catalogs found in datasource.", "", 1);
                return;
            }
            intI = 0;
        } else {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test successful! Connected to server and found datasource, but no catalog specified.", "", 1);
            return;
        }
        while (!found && intI < cats.length) {
            if (catalog.compareTo(((CatalogElement)cats[intI]).toString()) == 0) {
                found = true;
                continue;
            }
            ++intI;
        }
        if (!found) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("Connection test failed! Catalog {0} not found in datasource.", new Object[]{catalog + ""}), "", 1);
            return;
        }
        JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test successful! Catalog found in datasource on xmla server.", "", 1);
    }
}

