/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.options;

import com.jaspersoft.ireport.designer.options.IReportPanel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class IReportOptionsPanelController
extends OptionsPanelController {
    private IReportPanel panel;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    private boolean changed;
    private List<OptionsPanelController> delegatedControllers = new ArrayList<OptionsPanelController>();
    private List<AdvancedOption> advancedOptions = new ArrayList<AdvancedOption>();

    public IReportOptionsPanelController() {
        Lookup lookup = Lookups.forPath((String)"OptionsDialog/iReport");
        Collection subTabs = lookup.lookupAll(AdvancedOption.class);
        for (AdvancedOption option : subTabs) {
            this.advancedOptions.add(option);
            OptionsPanelController opc = option.create();
            this.delegatedControllers.add(opc);
            JComponent c = opc.getComponent(null);
            this.getPanel().addTab(option.getDisplayName(), c);
        }
    }

    public void update() {
        this.getPanel().load();
        for (OptionsPanelController opc : this.delegatedControllers) {
            opc.update();
        }
        this.changed = false;
    }

    public void applyChanges() {
        this.getPanel().store();
        for (OptionsPanelController opc : this.delegatedControllers) {
            opc.applyChanges();
        }
        this.changed = false;
    }

    public void cancel() {
        for (OptionsPanelController opc : this.delegatedControllers) {
            opc.cancel();
        }
    }

    public boolean isValid() {
        for (OptionsPanelController opc : this.delegatedControllers) {
            if (opc.isValid()) continue;
            return false;
        }
        return this.getPanel().valid();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.getPanel();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
        for (OptionsPanelController opc : this.delegatedControllers) {
            opc.addPropertyChangeListener(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
        for (OptionsPanelController opc : this.delegatedControllers) {
            opc.removePropertyChangeListener(l);
        }
    }

    private IReportPanel getPanel() {
        if (this.panel == null) {
            this.panel = new IReportPanel(this);
        }
        return this.panel;
    }

    public void changed() {
        if (!this.changed) {
            this.changed = true;
            this.pcs.firePropertyChange("changed", false, true);
        }
        this.pcs.firePropertyChange("valid", null, null);
    }
}

