/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.menu.SortFieldsAction;
import com.jaspersoft.ireport.designer.outline.NewTypesUtils;
import com.jaspersoft.ireport.designer.outline.nodes.FieldNode;
import com.jaspersoft.ireport.designer.outline.nodes.FieldsChildren;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class FieldsNode
extends IRIndexedNode
implements PropertyChangeListener {
    private JasperDesign jd = null;
    private JRDesignDataset dataset = null;
    private boolean sort = false;
    private boolean sorting = false;

    public FieldsNode(JasperDesign jd, Lookup doLkp) {
        this(jd, (JRDesignDataset)jd.getMainDataset(), doLkp);
    }

    public FieldsNode(JasperDesign jd, JRDesignDataset dataset, Lookup doLkp) {
        this(new FieldsChildren(jd, dataset, doLkp), jd, dataset, doLkp);
    }

    public FieldsNode(FieldsChildren pc, JasperDesign jd, JRDesignDataset dataset, Lookup doLkp) {
        super((Children)pc, pc.getIndex(), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, dataset})}));
        this.jd = jd;
        if (dataset == null) {
            dataset = jd.getMainDesignDataset();
        }
        this.dataset = dataset;
        dataset.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        this.setDisplayName(I18n.getString("FieldsNode.Property.Fields"));
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/fields-16.png");
        this.addNodeListener(new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
            }

            public void childrenRemoved(NodeMemberEvent ev) {
            }

            public void childrenReordered(NodeReorderEvent ev) {
                if (FieldsNode.this.isSorting() || FieldsNode.this.isSort()) {
                    return;
                }
                List list = FieldsNode.this.getDataset().getFieldsList();
                ArrayList<JRDesignField> newList = new ArrayList<JRDesignField>();
                Node[] nodes = FieldsNode.this.getChildren().getNodes();
                for (int i = 0; i < nodes.length; ++i) {
                    JRDesignField s = ((FieldNode)nodes[i]).getField();
                    newList.add(s);
                }
                list.clear();
                list.addAll(newList);
                FieldsNode.this.getDataset().getEventSupport().firePropertyChange(new PropertyChangeEvent(FieldsNode.this.getDataset(), "fields", null, null));
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        JRDesignField field;
        final Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        final int dropAction = DnDUtilities.getTransferAction(t);
        int insertAt = index;
        if (null != dropNode && null != (field = (JRDesignField)dropNode.getLookup().lookup(JRDesignField.class))) {
            if (this.isSort() && this.getDataset().getFieldsList().contains(field)) {
                return null;
            }
            return new PasteType(){

                public Transferable paste() throws IOException {
                    List list = FieldsNode.this.getDataset().getFieldsList();
                    int currentIndex = -1;
                    for (int i = 0; i < list.size(); ++i) {
                        JRDesignField f = (JRDesignField)list.get(i);
                        if (f != field) continue;
                        currentIndex = i;
                    }
                    if ((dropAction & 6) != 0) {
                        int newIndex = -1;
                        if (currentIndex != -1) {
                            Node[] nodes = FieldsNode.this.getChildren().getNodes();
                            for (int i = 0; i < nodes.length; ++i) {
                                if (((FieldNode)nodes[i]).getField() != field) continue;
                                newIndex = i;
                                break;
                            }
                            list.remove(field);
                            if (newIndex == -1) {
                                list.add(field);
                            } else {
                                list.add(newIndex, field);
                            }
                        } else {
                            try {
                                JRDesignField newField = ModelUtils.cloneField(field);
                                Map map = FieldsNode.this.getDataset().getFieldsMap();
                                int k = 1;
                                while (map.containsKey(newField.getName())) {
                                    newField.setName(field.getName() + "_" + k);
                                    ++k;
                                }
                                FieldsNode.this.getDataset().addField((JRField)newField);
                                if (dropNode.getParentNode() instanceof FieldsNode) {
                                    FieldsNode pn = (FieldsNode)dropNode.getParentNode();
                                    pn.getDataset().removeField((JRField)field);
                                }
                            }
                            catch (Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    } else {
                        try {
                            JRDesignField newField = ModelUtils.cloneField(field);
                            Map map = FieldsNode.this.getDataset().getFieldsMap();
                            int k = 1;
                            while (map.containsKey(newField.getName())) {
                                newField.setName(field.getName() + "_" + k);
                                ++k;
                            }
                            FieldsNode.this.getDataset().addField((JRField)newField);
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(NewAction.class), SystemAction.get(PasteAction.class), SystemAction.get(ReorderAction.class), SystemAction.get(SortFieldsAction.class)};
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public JRDesignDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(JRDesignDataset dataset) {
        this.dataset = dataset;
    }

    public NewType[] getNewTypes() {
        return NewTypesUtils.getNewType((Node)this, 2);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName().equals("fields")) {
            ((FieldsChildren)this.getChildren()).recalculateKeys();
        }
    }

    public boolean isSort() {
        return this.sort;
    }

    public void setSort(boolean sort) {
        this.sort = sort;
        if (sort) {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/fields-sort-16.png");
        } else {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/fields-16.png");
        }
        this.fireIconChange();
        if (this.getChildren() != null && this.getChildren() instanceof FieldsChildren) {
            this.setSorting(true);
            ((FieldsChildren)this.getChildren()).recalculateKeys();
            this.setSorting(false);
        }
    }

    public boolean isSorting() {
        return this.sorting;
    }

    public void setSorting(boolean sorting) {
        this.sorting = sorting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSorting() {
        if (!this.isSort()) {
            return;
        }
        this.setSorting(true);
        try {
            Node[] nodes = this.getChildren().getNodes();
            ArrayList<Node> nodesList = new ArrayList<Node>(Arrays.asList(nodes));
            Arrays.sort(nodes, new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            int[] ints = new int[nodes.length];
            for (int i = 0; i < ints.length; ++i) {
                ints[nodesList.indexOf((Object)nodes[i])] = i;
            }
            ((FieldsChildren)this.getChildren()).forceReorder(ints);
        }
        finally {
            this.setSorting(false);
        }
    }
}

