/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.actions.DeleteGroupAction;
import com.jaspersoft.ireport.designer.actions.MoveGroupDownAction;
import com.jaspersoft.ireport.designer.actions.MoveGroupUpAction;
import com.jaspersoft.ireport.designer.outline.nodes.BandNode;
import com.jaspersoft.ireport.designer.outline.nodes.GroupNode;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.PasteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class GroupNodeImpl
extends IRAbstractNode
implements PropertyChangeListener,
GroupNode {
    JasperDesign jd = null;
    private JRDesignGroup group = null;

    public GroupNodeImpl(JasperDesign jd, JRDesignGroup group, Lookup doLkp) {
        super(Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, group})}));
        this.jd = jd;
        this.group = group;
        this.setDisplayName(group.getName());
        super.setName(group.getName());
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/groups-16.png");
        group.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public String getDisplayName() {
        return this.group.getName();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        if (this.group != null) {
            Sheet.Set groupPropertiesSet = Sheet.createPropertiesSet();
            groupPropertiesSet.setName("GROUP_PROPERTIES");
            groupPropertiesSet.setDisplayName(I18n.getString("BandNode.Property.Groupproperties"));
            if (this.getDataset() != null) {
                groupPropertiesSet = BandNode.fillGroupPropertySet(groupPropertiesSet, this.getDataset(), this.group);
            }
            sheet.put(groupPropertiesSet);
        }
        return sheet;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canRename() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)4);
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)1);
    }

    public void destroy() throws IOException {
        JRDesignDataset dataset = (JRDesignDataset)this.getParentNode().getLookup().lookup(JRDesignDataset.class);
        this.getGroup().getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
        dataset.removeGroup((JRGroup)this.getGroup());
        super.destroy();
    }

    public Action[] getActions(boolean popup) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(SystemAction.get(CopyAction.class));
        list.add(SystemAction.get(CutAction.class));
        list.add(SystemAction.get(RenameAction.class));
        list.add(SystemAction.get(ReorderAction.class));
        list.add(SystemAction.get(PasteAction.class));
        list.add(SystemAction.get(BandNode.RefreshNodes.class));
        if (this.group != null) {
            list.add(null);
            list.add(SystemAction.get(MoveGroupUpAction.class));
            list.add(SystemAction.get(MoveGroupDownAction.class));
            list.add((Object)DeleteGroupAction.getInstance());
        }
        return list.toArray(new Action[list.size()]);
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        return tras;
    }

    public void setName(String s) {
        if (s.equals("")) {
            throw new IllegalArgumentException(I18n.getString("GroupNode.Property.GroupInvalid"));
        }
        List currentGroups = null;
        JRDesignDataset dataset = (JRDesignDataset)this.getParentNode().getLookup().lookup(JRDesignDataset.class);
        currentGroups = dataset.getGroupsList();
        for (JRDesignGroup p : currentGroups) {
            if (p == this.getGroup() || !p.getName().equals(s)) continue;
            throw new IllegalArgumentException(I18n.getString("GroupNode.Property.GroupInUse"));
        }
        String oldName = this.getGroup().getName();
        this.getGroup().setName(s);
        dataset.getGroupsMap().remove(oldName);
        dataset.getGroupsMap().put(s, this.getGroup());
        JRDesignVariable var = (JRDesignVariable)dataset.getVariablesMap().get(oldName + "_COUNT");
        var.setName(s + "_COUNT");
        dataset.getVariablesMap().remove(oldName + "_COUNT");
        dataset.getVariablesMap().put(s + "_COUNT", var);
        dataset.getEventSupport().firePropertyChange("variables", null, null);
        ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getGroup(), "Name", String.class, oldName, s);
        IReportManager.getInstance().addUndoableEdit(opue);
    }

    public JRDesignGroup getGroup() {
        return this.group;
    }

    public void setGroup(JRDesignGroup group) {
        this.group = group;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("name")) {
            super.setName(this.getGroup().getName());
            this.setDisplayName(this.getGroup().getName());
        }
        if (ModelUtils.containsProperty(this.getPropertySets(), evt.getPropertyName())) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    public JRDesignDataset getDataset() {
        if (this.getParentNode() == null) {
            return null;
        }
        return (JRDesignDataset)this.getParentNode().getLookup().lookup(JRDesignDataset.class);
    }
}

