/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.widgets;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.utils.ImageExpressionFileResolver;
import com.jaspersoft.ireport.designer.utils.ProxyFileResolver;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.File;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.export.draw.DrawVisitor;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;

public class JRDesignImageWidget
extends JRDesignElementWidget
implements Runnable {
    ImageExpressionFileResolver resolver = null;
    BufferedImage offScreenImage = null;
    boolean needReload = false;
    boolean running = false;

    public JRDesignImageWidget(AbstractReportObjectScene scene, JRDesignImage element) {
        super(scene, (JRDesignElement)element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintWidgetImplementation() {
        if (this.getElement().getHeight() <= 0 || this.getElement().getWidth() <= 0) {
            return;
        }
        if (this.offScreenImage == null || this.needReload) {
            File file;
            this.needReload = false;
            this.offScreenImage = new BufferedImage(this.getElement().getWidth(), this.getElement().getHeight(), 2);
            Container component = ((AbstractReportObjectScene)this.getScene()).getView();
            JrxmlVisualView visualView = null;
            while (component.getParent() != null) {
                if (component.getParent() instanceof JrxmlVisualView) {
                    visualView = (JrxmlVisualView)((Object)component.getParent());
                    break;
                }
                component = component.getParent();
            }
            File reportFolder = null;
            if (visualView != null && (file = FileUtil.toFile((FileObject)visualView.getEditorSupport().getDataObject().getPrimaryFile())).getParentFile() != null) {
                reportFolder = file.getParentFile();
            }
            ProxyFileResolver fileResolver = new ProxyFileResolver(IReportManager.getInstance().getFileResolvers());
            if (visualView != null && visualView.getModel() != null && visualView.getModel().getJasperDesign() != null) {
                if (this.resolver == null) {
                    this.resolver = new ImageExpressionFileResolver((JRDesignImage)this.getElement(), reportFolder + "", visualView.getModel().getJasperDesign());
                } else {
                    try {
                        this.resolver.setImageElement((JRDesignImage)this.getElement());
                        this.resolver.setJasperDesign(visualView.getModel().getJasperDesign());
                        this.resolver.setReportFolder(reportFolder + "");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                fileResolver.addResolver(this.resolver);
            }
            JRResourcesUtil.setThreadFileResolver((FileResolver)fileResolver);
            try {
                DrawVisitor dv = ((AbstractReportObjectScene)this.getScene()).getDrawVisitor();
                if (dv == null) {
                    return;
                }
                dv.setGraphics2D((Graphics2D)this.offScreenImage.getGraphics());
                try {
                    this.getElement().visit((JRVisitor)dv);
                }
                catch (Exception ex) {
                    System.err.println("iReport - Element rendering exception " + this.getElement() + " " + ex.getMessage());
                }
            }
            catch (Exception ex) {
                System.err.println("iReport - Error painting image: " + ex.getMessage());
            }
            finally {
                JRResourcesUtil.resetThreadFileResolver();
            }
        }
        this.getGraphics().drawImage(this.offScreenImage, this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height, null);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("height") || propertyName.equals("width") || propertyName.equals("backcolor") || propertyName.equals("forecolor") || propertyName.equals("parentStyle") || propertyName.equals("parentStyleNameReference") || propertyName.equals("mode") || propertyName.equals("fill") || propertyName.equals("horizontalAlignment") || propertyName.equals("verticalAlignment") || propertyName.equals("scaleImage") || propertyName.equals("expression") || propertyName.equals("pen") || propertyName.equals("linebox") || propertyName.equals("lineColor") || propertyName.equals("lineStyle") || propertyName.equals("lineWidth") || propertyName.equals("bottomPadding") || propertyName.equals("bottomPadding") || propertyName.equals("bottomPadding") || propertyName.equals("bottomPadding")) {
            if (this.running) {
                return;
            }
            Thread t = new Thread(this);
            t.start();
        }
        super.propertyChange(evt);
    }

    public void run() {
        this.running = true;
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.needReload = true;
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                JRDesignImageWidget.this.repaint();
            }
        });
        this.running = false;
    }
}

