/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.widgets;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.borders.ReportBorder;
import com.jaspersoft.ireport.designer.utils.Java2DUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class PageWidget
extends Widget {
    private int gridSize = 13;
    private TexturePaint gridTexture = null;
    private static final BasicStroke GRID_STROKE = new BasicStroke(0.0f, 2, 2, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);

    public PageWidget(ReportObjectScene scene) {
        super((Scene)scene);
        this.setBorder(new ReportBorder(scene));
        this.setBackground(Color.WHITE);
        this.setOpaque(false);
        this.setCheckClipping(true);
        this.updateBounds();
    }

    public void updateBounds() {
        JasperDesign jd = ((ReportObjectScene)this.getScene()).getJasperDesign();
        this.setPreferredSize(new Dimension(jd.getPageWidth() + 20, ModelUtils.getDesignHeight(jd) + 20));
    }

    public JasperDesign getJasperDesign() {
        return ((ReportObjectScene)this.getScene()).getJasperDesign();
    }

    protected void paintWidget() {
        super.paintWidget();
        Graphics2D g = this.getGraphics();
        g.setColor(ReportObjectScene.DESIGN_LINE_COLOR);
        Stroke oldStroke = g.getStroke();
        double zoom = this.getScene().getZoomFactor();
        Stroke bs = Java2DUtils.getInvertedZoomedStroke(oldStroke, this.getScene().getZoomFactor());
        g.setStroke(bs);
        JasperDesign jd = this.getJasperDesign();
        if (jd != null) {
            int dh = ModelUtils.getDesignHeight(jd);
            if (IReportManager.getInstance().isBackgroundSeparated() && jd.getBackground() != null && jd.getBackground().getHeight() > 0) {
                dh -= jd.getBackground().getHeight();
                dh -= jd.getTopMargin();
                dh -= jd.getBottomMargin();
                dh -= 40;
            }
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, jd.getPageWidth(), dh);
            if (((ReportObjectScene)this.getScene()).isGridVisible()) {
                this.paintGrid(g, new Rectangle(0, 0, jd.getPageWidth(), dh));
            }
            g.setColor(ReportObjectScene.DESIGN_LINE_COLOR);
            g.drawLine(jd.getLeftMargin(), 0, jd.getLeftMargin(), dh);
            g.drawLine(jd.getPageWidth() - jd.getRightMargin(), 0, jd.getPageWidth() - jd.getRightMargin(), dh);
            g.drawLine(0, jd.getTopMargin(), jd.getPageWidth(), jd.getTopMargin());
            g.drawLine(0, dh - jd.getBottomMargin(), jd.getPageWidth(), dh - jd.getBottomMargin());
            if (jd.getColumnCount() > 1) {
                int c_y0 = ModelUtils.getBandLocation(jd.getColumnHeader(), jd);
                int c_y1 = ModelUtils.getBandLocation(jd.getPageFooter(), jd);
                int c_x = jd.getLeftMargin();
                for (int i = 1; i < jd.getColumnCount(); ++i) {
                    g.drawLine(c_x += jd.getColumnWidth(), c_y0, c_x, c_y1);
                    g.drawLine(c_x += jd.getColumnSpacing(), c_y0, c_x, c_y1);
                }
            }
            g.setFont(new Font("Arial", 0, 20));
            int designHeight = jd.getTopMargin();
            g.setStroke(oldStroke);
            if (IReportManager.getPreferences().getBoolean("PROPERTY_SHOW_BAND_NAMES", true)) {
                List<JRBand> bands = ModelUtils.getBands(jd);
                for (JRBand b : bands) {
                    if (b instanceof JRDesignBand && ((JRDesignBand)b).getOrigin().getBandType() == 1 && IReportManager.getInstance().isBackgroundSeparated()) continue;
                    this.paintBand(g, jd, ModelUtils.nameOf(b, jd), b, designHeight += b.getHeight());
                }
            }
            oldStroke = g.getStroke();
            g.setStroke(bs);
            if (IReportManager.getInstance().isBackgroundSeparated() && jd.getBackground() != null && jd.getBackground().getHeight() > 0) {
                designHeight += jd.getBottomMargin();
                Color oldC = g.getColor();
                int bgPageHeight = jd.getBackground().getHeight() + jd.getTopMargin() + jd.getBottomMargin();
                g.setColor(Color.WHITE);
                g.fillRect(0, designHeight += 40, jd.getPageWidth(), bgPageHeight);
                if (((ReportObjectScene)this.getScene()).isGridVisible()) {
                    this.paintGrid(g, new Rectangle(0, designHeight, jd.getPageWidth(), bgPageHeight));
                }
                g.setColor(ReportObjectScene.DESIGN_LINE_COLOR);
                g.drawLine(jd.getLeftMargin(), designHeight, jd.getLeftMargin(), designHeight + bgPageHeight);
                g.drawLine(jd.getPageWidth() - jd.getRightMargin(), designHeight, jd.getPageWidth() - jd.getRightMargin(), designHeight + bgPageHeight);
                g.drawLine(0, designHeight + jd.getTopMargin(), jd.getPageWidth(), designHeight + jd.getTopMargin());
                g.drawLine(0, designHeight + bgPageHeight - jd.getBottomMargin(), jd.getPageWidth(), designHeight + bgPageHeight - jd.getBottomMargin());
                g.setStroke(oldStroke);
                this.paintBand(g, jd, ModelUtils.nameOf(jd.getBackground(), jd), jd.getBackground(), (designHeight += jd.getTopMargin()) + jd.getBackground().getHeight());
                g.setColor(oldC);
            }
        }
        g.setStroke(oldStroke);
    }

    private void paintBand(Graphics2D g, JasperDesign jd, String title, JRBand b, int bandBottom) {
        if (b == null || b.getHeight() == 0) {
            return;
        }
        int txt_width = g.getFontMetrics().stringWidth(title) / 2;
        int txt_height = g.getFontMetrics().getHeight() / 2;
        Java2DUtils.setClip(g, jd.getLeftMargin(), bandBottom - b.getHeight(), jd.getPageWidth() - jd.getRightMargin(), b.getHeight());
        Paint oldPaint = g.getPaint();
        g.setPaint(ReportObjectScene.GRID_LINE_COLOR);
        g.drawString(title, jd.getPageWidth() / 2 - txt_width, bandBottom - (b.getHeight() - (txt_height -= g.getFontMetrics().getMaxDescent())) / 2);
        Java2DUtils.resetClip(g);
        g.setPaint(oldPaint);
    }

    protected void paintGrid(Graphics2D g, Rectangle area) {
        Paint oldPaint = g.getPaint();
        AffineTransform backT = g.getTransform();
        g.translate(area.x, area.y);
        g.setPaint(this.getGridTexture());
        g.fill(new Rectangle(0, 0, area.width, area.height));
        g.setPaint(oldPaint);
        g.setTransform(backT);
    }

    private TexturePaint getGridTexture() {
        if (this.gridTexture == null || this.gridTexture.getImage().getWidth() != this.getGridSize()) {
            BufferedImage img = new BufferedImage(this.getGridSize(), this.getGridSize(), 1);
            Graphics2D g2 = img.createGraphics();
            g2.setColor(new Color(255, 255, 255, 255));
            g2.fill(this.getClientArea());
            g2.setColor(ReportObjectScene.GRID_LINE_COLOR);
            g2.setStroke(GRID_STROKE);
            g2.drawLine(this.getGridSize() - 1, 0, this.getGridSize() - 1, this.getGridSize() - 1);
            g2.drawLine(0, this.getGridSize() - 1, this.getGridSize() - 1, this.getGridSize() - 1);
            this.gridTexture = new TexturePaint(img, new Rectangle(0, 0, this.getGridSize(), this.getGridSize()));
        }
        return this.gridTexture;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }
}

