/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.wizards;

import com.jaspersoft.ireport.designer.wizards.FieldsSelectionWizardPanel;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.openide.awt.Mnemonics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldsSelectionVisualPanel
extends JPanel {
    private FieldsSelectionWizardPanel panel = null;
    private boolean selectionChanged = false;
    private JButton jButtonSelect;
    private JButton jButtonSelectAll;
    private JButton jButtonUnselect;
    private JButton jButtonUnselectAll;
    private JList jList1;
    private JList jList2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;

    public FieldsSelectionVisualPanel(FieldsSelectionWizardPanel panel) {
        this.panel = panel;
        this.initComponents();
        FieldListCellRenderer renderer = new FieldListCellRenderer();
        this.jList1.setCellRenderer(renderer);
        this.jList1.setModel(new DefaultListModel());
        this.jList2.setCellRenderer(renderer);
        this.jList2.setModel(new DefaultListModel());
        this.updateLists();
    }

    @Override
    public String getName() {
        return I18n.getString("FieldsSelectionVisualPanel.Name.Fields");
    }

    public void updateLists() {
        ((DefaultListModel)this.jList1.getModel()).clear();
        ((DefaultListModel)this.jList2.getModel()).clear();
        List discoveredFields = (List)this.panel.getWizard().getProperty("discoveredFields");
        if (discoveredFields != null) {
            for (JRDesignField field : discoveredFields) {
                ((DefaultListModel)this.jList1.getModel()).addElement(field);
            }
        }
        if (this.jList1.getModel().getSize() > 0) {
            this.jList1.setSelectedIndex(0);
        }
        this.updateButtons();
    }

    private void moveSelection(JList l1, JList l2) {
        if (l1.getSelectedIndex() < 0) {
            return;
        }
        this.selectionChanged = true;
        DefaultListModel model = (DefaultListModel)l1.getModel();
        DefaultListModel model2 = (DefaultListModel)l2.getModel();
        int last = model2.getSize();
        int[] selectedIndexes = l1.getSelectedIndices();
        for (int i = selectedIndexes.length - 1; i >= 0; --i) {
            int index = selectedIndexes[i];
            Object ele = model.elementAt(index);
            model.removeElementAt(index);
            model2.add(last, ele);
        }
        if (!model.isEmpty()) {
            l1.setSelectedIndex(0);
        }
        l2.setSelectionInterval(last, model2.size() - 1);
        this.updateButtons();
    }

    private void moveAll(JList l1, JList l2) {
        if (l1.getModel().getSize() == 0) {
            return;
        }
        l1.setSelectionInterval(0, l1.getModel().getSize() - 1);
        this.moveSelection(l1, l2);
    }

    public void updateButtons() {
        this.jButtonSelect.setEnabled(this.jList1.getSelectedIndex() >= 0);
        this.jButtonSelectAll.setEnabled(this.jList1.getSelectedIndex() >= 0);
        this.jButtonUnselect.setEnabled(this.jList2.getSelectedIndex() >= 0);
        this.jButtonUnselectAll.setEnabled(this.jList2.getSelectedIndex() >= 0);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel1 = new JPanel();
        this.jButtonSelect = new JButton();
        this.jButtonSelectAll = new JButton();
        this.jButtonUnselect = new JButton();
        this.jButtonUnselectAll = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jList2 = new JList();
        this.setPreferredSize(new Dimension(100, 130));
        this.setLayout(new GridBagLayout());
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                FieldsSelectionVisualPanel.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(30, 0));
        this.jPanel1.setPreferredSize(new Dimension(30, 100));
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelect, (String)">");
        this.jButtonSelect.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonSelect.setMinimumSize(new Dimension(30, 30));
        this.jButtonSelect.setPreferredSize(new Dimension(30, 30));
        this.jButtonSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldsSelectionVisualPanel.this.jButtonSelectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonSelect, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectAll, (String)">>");
        this.jButtonSelectAll.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonSelectAll.setMinimumSize(new Dimension(30, 30));
        this.jButtonSelectAll.setPreferredSize(new Dimension(30, 30));
        this.jButtonSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldsSelectionVisualPanel.this.jButtonSelectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonSelectAll, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonUnselect, (String)"<");
        this.jButtonUnselect.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonUnselect.setMinimumSize(new Dimension(30, 30));
        this.jButtonUnselect.setPreferredSize(new Dimension(30, 30));
        this.jButtonUnselect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldsSelectionVisualPanel.this.jButtonUnselectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonUnselect, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonUnselectAll, (String)"<<");
        this.jButtonUnselectAll.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonUnselectAll.setMinimumSize(new Dimension(30, 30));
        this.jButtonUnselectAll.setPreferredSize(new Dimension(30, 30));
        this.jButtonUnselectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldsSelectionVisualPanel.this.jButtonUnselectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonUnselectAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jList2.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                FieldsSelectionVisualPanel.this.jList2ValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jList2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
    }

    private void jButtonSelectActionPerformed(ActionEvent evt) {
        this.moveSelection(this.jList1, this.jList2);
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        this.moveAll(this.jList1, this.jList2);
    }

    private void jButtonUnselectActionPerformed(ActionEvent evt) {
        this.moveSelection(this.jList2, this.jList1);
    }

    private void jButtonUnselectAllActionPerformed(ActionEvent evt) {
        this.moveAll(this.jList2, this.jList1);
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
    }

    private void jList2ValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
    }

    public boolean isSelectionChanged() {
        return this.selectionChanged;
    }

    public void setSelectionChanged(boolean selectionChanged) {
        this.selectionChanged = selectionChanged;
    }

    public List<JRDesignField> getSelectedFields() {
        ArrayList<JRDesignField> list = new ArrayList<JRDesignField>();
        for (int i = 0; i < this.jList2.getModel().getSize(); ++i) {
            list.add((JRDesignField)this.jList2.getModel().getElementAt(i));
        }
        return list;
    }

    static class FieldListCellRenderer
    extends DefaultListCellRenderer {
        FieldListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof JRDesignField) {
                value = ((JRDesignField)value).getName();
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

