/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons.layers;

import com.jaspersoft.ireport.addons.layers.Layer;
import com.jaspersoft.ireport.addons.layers.LayerItemPanel;
import com.jaspersoft.ireport.addons.layers.LayersChangedEvent;
import com.jaspersoft.ireport.addons.layers.LayersChangedListener;
import com.jaspersoft.ireport.addons.layers.LayersSupport;
import com.jaspersoft.ireport.designer.IReportManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayersListPanel
extends JPanel
implements LayersChangedListener {
    public static final String PROPERTY_SELECTED_ITEMS = "PROPERTY_SELECTED_ITEMS";
    private LayerItemPanel selectedItem = null;

    public LayersListPanel() {
        this.initComponents();
        LayersSupport.getInstance().addLayersChangedListener(this);
        LayersChangedEvent event = new LayersChangedEvent(3, IReportManager.getInstance().getActiveReport());
        this.layersChanged(event);
    }

    @Override
    public Dimension getMinimumSize() {
        int h = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Dimension d = this.getComponent(i).getPreferredSize();
            if (d == null) continue;
            h += d.height;
        }
        Dimension gg = super.getMinimumSize();
        gg.height = h;
        return gg;
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
    }

    public List<Layer> getSelectedLayers() {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof LayerItemPanel) || !((LayerItemPanel)components[i]).isSelected()) continue;
            layers.add(((LayerItemPanel)components[i]).getLayer());
        }
        return layers;
    }

    public void itemMousePressed(MouseEvent evt) {
        LayerItemPanel currentlySelectedItem = (LayerItemPanel)evt.getSource();
        if (evt.isControlDown()) {
            if (currentlySelectedItem.isSelected()) {
                currentlySelectedItem.setSelected(false);
                if (currentlySelectedItem == this.selectedItem) {
                    List<Layer> selectedLayers = this.getSelectedLayers();
                    this.selectedItem = selectedLayers.size() > 0 ? this.getLayerPanelOf(selectedLayers.get(0)) : null;
                }
            } else {
                currentlySelectedItem.setSelected(true);
                this.selectedItem = currentlySelectedItem;
            }
        } else if (evt.isShiftDown() && this.selectedItem != null) {
            Component[] components = this.getComponents();
            boolean select = false;
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof LayerItemPanel)) continue;
                if (components[i] == this.selectedItem || components[i] == currentlySelectedItem) {
                    ((LayerItemPanel)components[i]).setSelected(true);
                    select = !select;
                    continue;
                }
                ((LayerItemPanel)components[i]).setSelected(select);
            }
            this.selectedItem = currentlySelectedItem;
        } else {
            currentlySelectedItem.setSelected(true);
            this.selectedItem = currentlySelectedItem;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component c = this.getComponent(i);
                if (!(c instanceof LayerItemPanel) || c == currentlySelectedItem) continue;
                ((LayerItemPanel)c).setSelected(false);
            }
        }
        this.firePropertyChange(PROPERTY_SELECTED_ITEMS, null, this.selectedItem);
    }

    private LayerItemPanel getLayerPanelOf(Layer l) {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof LayerItemPanel) || ((LayerItemPanel)components[i]).getLayer() != l) continue;
            return (LayerItemPanel)components[i];
        }
        return null;
    }

    @Override
    public void layersChanged(LayersChangedEvent event) {
        if (event.getType() == 1) {
            for (Layer layer : event.getChangedLayers()) {
                LayerItemPanel l = new LayerItemPanel();
                l.setLayer(layer);
                this.add((Component)l, 0);
            }
            this.updateUI();
        } else if (event.getType() == 2) {
            boolean fireSelectionChanged = false;
            LayerItemPanel oldSelectedItem = this.selectedItem;
            for (Layer layer : event.getChangedLayers()) {
                LayerItemPanel l = this.getLayerPanelOf(layer);
                if (l.isSelected()) {
                    fireSelectionChanged = true;
                    if (l == this.selectedItem) {
                        this.selectedItem = null;
                    }
                }
                this.remove(l);
            }
            if (fireSelectionChanged) {
                if (this.selectedItem == null) {
                    Component[] components = this.getComponents();
                    for (int i = 0; i < components.length; ++i) {
                        if (!(components[i] instanceof LayerItemPanel) || !((LayerItemPanel)components[i]).isSelected()) continue;
                        this.selectedItem = (LayerItemPanel)components[i];
                        break;
                    }
                } else {
                    oldSelectedItem = null;
                }
                this.firePropertyChange(PROPERTY_SELECTED_ITEMS, oldSelectedItem, this.selectedItem);
            }
            this.updateUI();
        } else if (event.getType() == 3) {
            this.removeAll();
            List<Layer> list = event.getLayers();
            for (Layer layer : list) {
                LayerItemPanel l = new LayerItemPanel();
                l.setLayer(layer);
                this.add((Component)l, 0);
            }
            this.add(Box.createVerticalGlue());
            this.updateUI();
            LayerItemPanel oldSelection = this.selectedItem;
            this.selectedItem = null;
            this.firePropertyChange(PROPERTY_SELECTED_ITEMS, oldSelection, this.selectedItem);
        }
    }
}

