/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.standalone.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.prefs.Preferences;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ImportSettingsUtilities {
    public static String[] getAvailableVersions() {
        File f;
        String dir = System.getProperty("netbeans.user");
        if (dir != null && dir.length() > 0 && (f = new File(dir)).exists() && f.getParentFile() != null && f.getParentFile().exists()) {
            Object[] versions = f.getParentFile().list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    File f = new File(dir, name);
                    String currentVersion = ImportSettingsUtilities.getCurrentVersion();
                    return !name.contains(currentVersion) && ImportSettingsUtilities.isValidConfigurationDirectory(f);
                }
            });
            Arrays.sort(versions);
            return versions;
        }
        return null;
    }

    public static String getCurrentVersion() {
        String s = NbBundle.getBundle((String)"org.netbeans.core.startup.Bundle").getString("currentVersion");
        if (s == null) {
            return "";
        }
        if ((s = s.trim()).length() > 0 && s.lastIndexOf(" ") >= 0) {
            s = s.substring(s.lastIndexOf(" ") + 1);
        }
        return s;
    }

    public static void importSettings(File dir) throws Exception {
        File iReportSettingsFile = new File(dir, "config/Preferences/com/jaspersoft/ireport.properties");
        Preferences prefs = NbPreferences.forModule(IReportManager.class);
        if (iReportSettingsFile.exists()) {
            Properties props = new Properties();
            props.load(new FileInputStream(iReportSettingsFile));
            Enumeration<Object> enumer = props.keys();
            while (enumer.hasMoreElements()) {
                String key = (String)enumer.nextElement();
                if (key.equals("UUID")) continue;
                prefs.put(key, props.getProperty(key));
            }
        }
        File jasperPluginSettingsFile = new File(dir, "config/Preferences/com/jaspersoft/ireport/jasperserver.properties");
        prefs = NbPreferences.forModule(JasperServerManager.class);
        if (jasperPluginSettingsFile.exists()) {
            Properties props = new Properties();
            props.load(new FileInputStream(jasperPluginSettingsFile));
            Enumeration<Object> enumer = props.keys();
            while (enumer.hasMoreElements()) {
                String key = (String)enumer.nextElement();
                prefs.put(key, props.getProperty(key));
            }
        }
    }

    public static final boolean isValidConfigurationDirectory(File f) {
        try {
            if (f == null || !f.exists() || !f.isDirectory()) {
                return false;
            }
            File f2 = new File(f, "config/preferences");
            return f2.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

