/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.standalone.menu;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.standalone.IReportStandaloneManager;
import com.jaspersoft.ireport.designer.standalone.menu.FileFilterAdapter;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;
import org.openide.util.UserCancelException;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;

public class OpenFileAction
extends CallableSystemAction {
    public OpenFileAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return I18n.getString(IReportStandaloneManager.class, (String)"CTL_OpenFileAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(OpenFileAction.class);
    }

    protected String iconResource() {
        return "com/transposix/nbext/openFile.png";
    }

    protected JFileChooser prepareFileChooser() {
        JFileChooser chooser = new JFileChooser();
        File currDir = Misc.findStartingDirectory();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, (File)currDir);
        HelpCtx.setHelpIDString((JComponent)chooser, (String)this.getHelpCtx().getHelpID());
        FileFilterAdapter mainFilter = new FileFilterAdapter(".jrxml", "JasperReports Template (.jrxml)");
        chooser.addChoosableFileFilter(mainFilter);
        chooser.addChoosableFileFilter(new FileFilterAdapter(".jrctx", "Chart Theme file (.jrctx)"));
        chooser.addChoosableFileFilter(new FileFilterAdapter(".jrtx", "Style Template file (.jrtx)"));
        chooser.addChoosableFileFilter(new FileFilterAdapter(".properties", "Resource Bundle (.properties)"));
        chooser.addChoosableFileFilter(new FileFilterAdapter(".jasper", "Compiled JasperReport (.jasper)"));
        chooser.setFileFilter(mainFilter);
        chooser.setMultiSelectionEnabled(true);
        return chooser;
    }

    public static File[] chooseFilesToOpen(JFileChooser chooser) throws UserCancelException {
        File[] files;
        do {
            int selectedOption;
            if ((selectedOption = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow())) == 0) continue;
            throw new UserCancelException();
        } while ((files = chooser.getSelectedFiles()).length == 0);
        return files;
    }

    public void performAction() {
        File[] files;
        JFileChooser chooser = this.prepareFileChooser();
        try {
            files = OpenFileAction.chooseFilesToOpen(chooser);
        }
        catch (UserCancelException ex) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            OpenFileAction.open(files[i]);
        }
        if (files.length > 0) {
            String dir = files[0].getParent();
            IReportManager.getPreferences().put("CURRENT_DIRECTORY", dir);
        }
    }

    public static void open(File f) {
        FileObject fob = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
        if (fob == null) {
            return;
        }
        try {
            DataObject dob = DataObject.find((FileObject)fob);
            if (f.getName().toLowerCase().endsWith(".properties")) {
                EditCookie oc = (EditCookie)dob.getCookie(EditCookie.class);
                if (oc != null) {
                    oc.edit();
                }
            } else {
                OpenCookie oc = (OpenCookie)dob.getCookie(OpenCookie.class);
                if (oc != null) {
                    oc.open();
                }
            }
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    protected boolean asynchronous() {
        return false;
    }
}

