/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBConnectionFactory;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.meta.DBMetaDataFactory;
import org.netbeans.modules.db.dataview.meta.DBPrimaryKey;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewDBTable;
import org.netbeans.modules.db.dataview.output.SQLExecutionHelper;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SQLStatementGenerator {
    private DataViewDBTable tblMeta;
    private DataView dataView;

    public SQLStatementGenerator(DataView dataView) {
        this.dataView = dataView;
        this.tblMeta = dataView.getDataViewDBTable();
    }

    String[] generateInsertStatement(Object[] objectArray) throws DBException {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder.append("INSERT INTO ");
        stringBuilder2.append(stringBuilder.toString());
        String string = " (";
        String string2 = "";
        String string3 = "";
        String string4 = ", ";
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            DBColumn dBColumn = this.tblMeta.getColumn(i);
            if (dBColumn.isGenerated()) continue;
            if (objectArray[i] == null && !dBColumn.isNullable()) {
                throw new DBException(NbBundle.getMessage(SQLStatementGenerator.class, (String)"MSG_nullable_check"));
            }
            if (bl) {
                string2 = string2 + string4;
                string3 = string3 + string4;
                string = string + string4;
            } else {
                bl = true;
            }
            string2 = string2 + (objectArray[i] == null ? " NULL " : "?");
            string3 = string3 + this.getQualifiedValue(dBColumn.getJdbcType(), objectArray[i]);
            string = string + dBColumn.getQualifiedName();
        }
        string = string + ")";
        String string5 = this.tblMeta.getFullyQualifiedName(0);
        stringBuilder.append(string5 + string + " Values(" + string2 + ")");
        stringBuilder2.append(string5.trim() + "\n\t" + string + " \nVALUES \n\t(" + string3 + ")");
        return new String[]{stringBuilder.toString(), stringBuilder2.toString()};
    }

    String[] generateUpdateStatement(int n, int n2, Object object, List<Object> list, List<Integer> list2, TableModel tableModel) throws DBException {
        DBColumn dBColumn = this.tblMeta.getColumn(n2);
        int n3 = dBColumn.getJdbcType();
        if (!dBColumn.isNullable() && object == null) {
            throw new DBException(NbBundle.getMessage(SQLStatementGenerator.class, (String)"MSG_nullable_check"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder.append("UPDATE ").append(this.tblMeta.getFullyQualifiedName(0)).append(" SET ");
        stringBuilder2.append(stringBuilder.toString()).append(this.tblMeta.getQualifiedName(n2)).append(" = ").append(this.getQualifiedValue(n3, object).toString()).append(" WHERE ");
        stringBuilder.append(this.tblMeta.getQualifiedName(n2)).append(" = ? WHERE ");
        list.add(object);
        list2.add(n3);
        this.generateWhereCondition(stringBuilder, stringBuilder2, list2, list, n, tableModel);
        return new String[]{stringBuilder.toString(), stringBuilder2.toString()};
    }

    String[] generateDeleteStatement(List<Integer> list, List<Object> list2, int n, TableModel tableModel) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder.append("DELETE FROM ").append(this.tblMeta.getFullyQualifiedName(0)).append(" WHERE ");
        stringBuilder2.append(stringBuilder.toString());
        this.generateWhereCondition(stringBuilder, stringBuilder2, list, list2, n, tableModel);
        return new String[]{stringBuilder.toString(), stringBuilder2.toString()};
    }

    String generateCreateStatement(DBTable dBTable) throws DBException, Exception {
        Connection connection = DBConnectionFactory.getInstance().getConnection(this.dataView.getDatabaseConnection());
        String string = "";
        if (connection == null) {
            Throwable throwable = DBConnectionFactory.getInstance().getLastException();
            string = throwable != null ? throwable.getMessage() : NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_connection_failure", (Object)this.dataView.getDatabaseConnection());
            this.dataView.setErrorStatusText(new DBException(string));
            throw new DBException(string);
        }
        DBMetaDataFactory dBMetaDataFactory = new DBMetaDataFactory(connection);
        boolean bl = dBMetaDataFactory.getDBType() == 0;
        Map<Integer, String> map = dBMetaDataFactory.buildDBSpecificDatatypeMap();
        StringBuffer stringBuffer = new StringBuffer();
        List<DBColumn> list = dBTable.getColumnList();
        stringBuffer.append("CREATE TABLE ").append(dBTable.getQualifiedName()).append(" (");
        int n = 0;
        for (DBColumn object : list) {
            Integer n2;
            if (n++ > 0) {
                stringBuffer.append(", ");
            }
            String string2 = map.containsKey(n2 = new Integer(object.getJdbcType())) ? map.get(n2) : DataViewUtils.getStdSqlType(object.getJdbcType());
            stringBuffer.append(object.getQualifiedName()).append(" ").append(string2);
            int n3 = object.getScale();
            int n4 = object.getPrecision();
            if (n4 > 0 && DataViewUtils.isPrecisionRequired(object.getJdbcType(), bl)) {
                stringBuffer.append("(").append(n4);
                if (n3 > 0 && DataViewUtils.isScaleRequired(object.getJdbcType())) {
                    stringBuffer.append(", ").append(n3).append(")");
                } else {
                    stringBuffer.append(")");
                }
            }
            if (DataViewUtils.isBinary(object.getJdbcType()) && bl) {
                stringBuffer.append("  FOR BIT DATA ");
            }
            if (!object.isNullable()) {
                stringBuffer.append(" NOT NULL");
            }
            if (!object.isGenerated()) continue;
            stringBuffer.append(" ").append(this.getAutoIncrementText(dBMetaDataFactory));
        }
        DBPrimaryKey dBPrimaryKey = dBTable.getPrimaryKey();
        if (dBPrimaryKey != null) {
            n = 0;
            stringBuffer.append(", PRIMARY KEY (");
            for (String string3 : dBPrimaryKey.getColumnNames()) {
                stringBuffer.append(dBTable.getQuoter().quoteIfNeeded(string3));
                if (n++ <= 0) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static String getCountSQLQuery(String string) {
        String[] stringArray = string.toUpperCase().split("FROM");
        return "SELECT COUNT(*) " + string.substring(stringArray[0].length());
    }

    private boolean addSeparator(boolean bl, StringBuilder stringBuilder, StringBuilder stringBuilder2, String string) {
        if (bl) {
            stringBuilder.append(string);
            stringBuilder2.append(string);
            return true;
        }
        return true;
    }

    private void generateNameValue(int n, StringBuilder stringBuilder, StringBuilder stringBuilder2, Object object, List<Object> list, List<Integer> list2) {
        String string = this.tblMeta.getQualifiedName(n);
        int n2 = this.tblMeta.getColumnType(n);
        if (object != null) {
            list.add(object);
            list2.add(n2);
            stringBuilder.append(string + " = ? ");
            stringBuilder2.append(string).append(" = ").append(this.getQualifiedValue(n2, object));
        } else {
            stringBuilder.append(string + " IS NULL ");
            stringBuilder2.append(string).append(" IS ").append(this.getQualifiedValue(n2, object));
        }
    }

    private void generateWhereCondition(StringBuilder stringBuilder, StringBuilder stringBuilder2, List<Integer> list, List<Object> list2, int n, TableModel tableModel) {
        DBPrimaryKey dBPrimaryKey = this.tblMeta.geTable(0).getPrimaryKey();
        boolean bl = false;
        boolean bl2 = false;
        if (dBPrimaryKey != null) {
            block0: for (String object : dBPrimaryKey.getColumnNames()) {
                for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                    Object object2;
                    String string = this.tblMeta.getColumnName(i);
                    if (!string.equals(object) || (object2 = tableModel.getValueAt(n, i)) == null) continue;
                    bl = true;
                    bl2 = this.addSeparator(bl2, stringBuilder, stringBuilder2, " AND ");
                    this.generateNameValue(i, stringBuilder, stringBuilder2, object2, list2, list);
                    continue block0;
                }
            }
        }
        if (dBPrimaryKey == null || !bl) {
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                Object object = tableModel.getValueAt(n, i);
                bl2 = this.addSeparator(bl2, stringBuilder, stringBuilder2, " AND ");
                this.generateNameValue(i, stringBuilder, stringBuilder2, object, list2, list);
            }
        }
    }

    private Object getQualifiedValue(int n, Object object) {
        if (object == null) {
            return "NULL";
        }
        if (DataViewUtils.isNumeric(n)) {
            return object;
        }
        return "'" + object + "'";
    }

    private String getAutoIncrementText(DBMetaDataFactory dBMetaDataFactory) throws Exception {
        switch (dBMetaDataFactory.getDBType()) {
            case 5: {
                return "AUTO_INCREMENT";
            }
            case 4: {
                return "SERIAL";
            }
            case 2: {
                return "IDENTITY";
            }
        }
        return "GENERATED ALWAYS AS IDENTITY";
    }
}

