/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JEditorPane;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.text.completion.SyntaxQueryHelper;
import org.netbeans.modules.xml.text.completion.XMLCompletionQuery;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public final class NodeSelector {
    private CaretListener caretListener;
    private Timer timerSelNodes;
    private int lastCaretOffset = -1;
    private static final int SELECTED_NODES_DELAY = 200;
    private JEditorPane pane;
    private XMLSyntaxSupport syntaxSupport;
    private Node originalUINode;
    HintContext hintContext;

    public NodeSelector(final JEditorPane jEditorPane) {
        this.pane = jEditorPane;
        this.caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                NodeSelector.this.restartTimerSelNodes(caretEvent.getDot());
            }
        };
        this.timerSelNodes = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Caret caret;
                if (NodeSelector.this.lastCaretOffset == -1 && jEditorPane != null && (caret = jEditorPane.getCaret()) != null) {
                    NodeSelector.this.lastCaretOffset = caret.getDot();
                }
                NodeSelector.this.selectElementsAtOffset(NodeSelector.this.lastCaretOffset);
            }
        });
        this.timerSelNodes.setInitialDelay(100);
        this.timerSelNodes.setRepeats(false);
        this.timerSelNodes.restart();
        jEditorPane.addCaretListener(this.caretListener);
    }

    void restartTimerSelNodes(int n) {
        this.timerSelNodes.setInitialDelay(200);
        this.lastCaretOffset = n;
        this.timerSelNodes.restart();
    }

    synchronized void selectElementsAtOffset(int n) {
        GrammarQuery grammarQuery;
        Object object;
        if (this.syntaxSupport == null) {
            object = this.pane.getDocument();
            if (object instanceof BaseDocument) {
                this.syntaxSupport = (XMLSyntaxSupport)((BaseDocument)object).getSyntaxSupport();
            }
            if (this.syntaxSupport == null) {
                return;
            }
        }
        for (object = this.pane.getParent(); object != null && !(object instanceof TopComponent); object = ((Component)object).getParent()) {
        }
        if (object == null) {
            return;
        }
        TopComponent topComponent = (TopComponent)object;
        Node[] nodeArray = topComponent.getActivatedNodes();
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        if (this.originalUINode == null) {
            this.originalUINode = nodeArray[0];
        }
        if ((grammarQuery = XMLCompletionQuery.getPerformer(this.pane.getDocument(), this.syntaxSupport)) == null) {
            return;
        }
        SyntaxQueryHelper syntaxQueryHelper = null;
        try {
            syntaxQueryHelper = new SyntaxQueryHelper(this.syntaxSupport, n);
        }
        catch (BadLocationException badLocationException) {
            topComponent.setActivatedNodes(new Node[]{new DelegatingNode(this.originalUINode, null, null)});
            return;
        }
        DelegatingNode delegatingNode = new DelegatingNode(this.originalUINode, grammarQuery, syntaxQueryHelper.getContext());
        topComponent.setActivatedNodes(new Node[]{delegatingNode});
    }

    private class AttributeProperty
    extends PropertySupport {
        private final String propName;
        private final Element ownerElem;
        private boolean canWrite;

        public AttributeProperty(Element element, String string) {
            super(string, String.class, string, string, true, true);
            this.canWrite = true;
            this.ownerElem = element;
            this.propName = string;
        }

        public void setValue(Object object) {
            try {
                this.ownerElem.setAttribute(this.propName, (String)object);
            }
            catch (DOMException dOMException) {
                this.canWrite = false;
            }
        }

        public Object getValue() {
            try {
                return this.ownerElem.getAttribute(this.propName);
            }
            catch (DOMException dOMException) {
                this.canWrite = false;
                return NbBundle.getMessage(NodeSelector.class, (String)"BK0001");
            }
        }

        public boolean canWrite() {
            return this.canWrite;
        }
    }

    private class DelegatingNode
    extends FilterNode {
        GrammarQuery grammarQuery;
        HintContext hintContext;
        Sheet propSheet;

        public DelegatingNode(Node node, GrammarQuery grammarQuery, HintContext hintContext) {
            super(node);
            this.grammarQuery = grammarQuery;
            this.hintContext = hintContext;
        }

        public Component getCustomizer() {
            if (this.grammarQuery == null || this.hintContext == null) {
                return super.getCustomizer();
            }
            return this.grammarQuery.getCustomizer(this.hintContext);
        }

        public boolean hasCustomizer() {
            if (this.grammarQuery == null || this.hintContext == null) {
                return super.hasCustomizer();
            }
            return this.grammarQuery.hasCustomizer(this.hintContext);
        }

        public Node.PropertySet[] getPropertySets() {
            if (this.propSheet == null) {
                Object object;
                this.propSheet = Sheet.createDefault();
                Sheet.Set set = this.propSheet.get("properties");
                if (this.grammarQuery != null && this.hintContext != null && (object = this.grammarQuery.getProperties(this.hintContext)) != null && ((Node.Property[])object).length > 0) {
                    set.put(object);
                    return this.propSheet.toArray();
                }
                object = null;
                if (this.hintContext != null) {
                    if (this.hintContext.getNodeType() == 1) {
                        object = (Element)this.hintContext;
                    } else if (this.hintContext.getNodeType() == 2) {
                        object = ((Attr)this.hintContext).getOwnerElement();
                    }
                }
                if (object != null) {
                    NamedNodeMap namedNodeMap = object.getAttributes();
                    for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                        org.w3c.dom.Node node = namedNodeMap.item(i);
                        set.put((Node.Property)new AttributeProperty((Element)object, node.getNodeName()));
                    }
                }
            }
            return this.propSheet.toArray();
        }
    }
}

