/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.project.ui.ExtIcon;
import org.netbeans.modules.project.ui.LazyProjectInitializing;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openidex.search.SearchInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LazyProject
implements Project,
ProjectInformation,
SearchInfo,
LogicalViewProvider {
    URL url;
    String displayName;
    ExtIcon icon;

    public LazyProject(URL uRL, String string, ExtIcon extIcon) {
        this.url = uRL;
        this.displayName = string;
        this.icon = extIcon;
    }

    public FileObject getProjectDirectory() {
        FileObject fileObject = URLMapper.findFileObject((URL)this.url);
        if (fileObject == null) {
            OpenProjectList.LOGGER.warning("Project dir with " + this.url + " not found!");
            fileObject = FileUtil.createMemoryFileSystem().getRoot();
        }
        return fileObject;
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public String getName() {
        return this.displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Icon getIcon() {
        return this.icon.getIcon();
    }

    public Project getProject() {
        return this;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public boolean canSearch() {
        return false;
    }

    public Iterator<DataObject> objectsToSearch() {
        return Collections.emptyList().iterator();
    }

    public Node createLogicalView() {
        return new ProjNode(Lookups.singleton((Object)this));
    }

    public Node findPath(Node node, Object object) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProjCh
    extends Children.Array {
        private ProjCh() {
        }

        protected Collection<Node> initCollection() {
            AbstractNode abstractNode = new AbstractNode(Children.LEAF);
            abstractNode.setName("init");
            abstractNode.setDisplayName(NbBundle.getMessage(ProjCh.class, (String)"MSG_ProjChInit"));
            abstractNode.setIconBaseWithExtension("org/netbeans/modules/project/ui/resources/wait.gif");
            return Collections.singletonList(abstractNode);
        }

        protected void addNotify() {
            super.addNotify();
            OpenProjectList.preferredProject(LazyProject.this);
        }
    }

    private final class ProjNode
    extends AbstractNode {
        public ProjNode(Lookup lookup) {
            super((Children)new ProjCh(), lookup);
            this.setName(LazyProject.this.url.toExternalForm());
            this.setDisplayName(LazyProject.this.displayName);
        }

        public Image getIcon(int n) {
            return Utilities.icon2Image((Icon)LazyProject.this.icon.getIcon());
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public Action getPreferredAction() {
            OpenProjectList.preferredProject(LazyProject.this);
            return super.getPreferredAction();
        }

        public boolean hasCustomizer() {
            return false;
        }

        public Action[] getActions(boolean bl) {
            OpenProjectList.preferredProject(LazyProject.this);
            return new Action[]{SystemAction.get(LazyProjectInitializing.class), CommonProjectActions.closeProjectAction()};
        }
    }
}

