/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.locale.I18n;
import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.connection.JRDataSourceProviderConnection;
import com.jaspersoft.ireport.designer.utils.Misc;

/**
 *
 * @author  gtoffoli
 */
public class JRDataSourceProviderConnectionEditor extends javax.swing.JPanel implements IReportConnectionEditor {
    
    private IReportConnection iReportConnection = null;
    
    /** Creates new form EJBQLConnectionEditor */
    public JRDataSourceProviderConnectionEditor() {
        initComponents();
        //applyI18n();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelDatasourceProvider = new javax.swing.JPanel();
        jLabel17 = new javax.swing.JLabel();
        jTextFieldJRDataSourceProvider = new javax.swing.JTextField();

        setLayout(new java.awt.BorderLayout());

        jPanelDatasourceProvider.setLayout(new java.awt.GridBagLayout());

        jLabel17.setText(I18n.getString("JRDataSourceProviderConnectionEditor.Label.ProviderClass")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 1, 3);
        jPanelDatasourceProvider.add(jLabel17, gridBagConstraints);

        jTextFieldJRDataSourceProvider.setText("com.jaspersoft.ireport.examples.PersonBeansDataSource");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        jPanelDatasourceProvider.add(jTextFieldJRDataSourceProvider, gridBagConstraints);

        add(jPanelDatasourceProvider, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel17;
    private javax.swing.JPanel jPanelDatasourceProvider;
    private javax.swing.JTextField jTextFieldJRDataSourceProvider;
    // End of variables declaration//GEN-END:variables
    
    
    public void setIReportConnection(IReportConnection c) {
        
        this.iReportConnection = c;
        if (iReportConnection instanceof JRDataSourceProviderConnection)
        {
            JRDataSourceProviderConnection con = (JRDataSourceProviderConnection)iReportConnection;
            this.jTextFieldJRDataSourceProvider.setText( Misc.nvl(con.getProperties().get("JRDataSourceProvider"), "") ); 
        }
    }

    @SuppressWarnings("unchecked")
    public IReportConnection getIReportConnection() {
        
        IReportConnection irConn = new JRDataSourceProviderConnection();
        ((JRDataSourceProviderConnection)irConn).getProperties().put("JRDataSourceProvider", this.jTextFieldJRDataSourceProvider.getText().trim() );
        iReportConnection = irConn;
        return iReportConnection;
    }
    
    /*
    public void applyI18n(){
          jLabel17.setText(I18n.getString("connectionDialog.label17","JasperReports DataSource Provider class"));
    }
    */
    
    
}
