/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxFormatInfo;

public class XlsxFormatHelper
extends BaseHelper {
    private Map formatCache = new HashMap();

    public XlsxFormatHelper(Writer writer) {
        super(writer);
    }

    public int getFormat(String pattern) {
        if (pattern == null) {
            return -1;
        }
        XlsxFormatInfo formatInfo = new XlsxFormatInfo(pattern);
        Integer formatIndex = (Integer)this.formatCache.get(formatInfo.getId());
        if (formatIndex == null) {
            formatIndex = this.formatCache.size();
            this.export(formatInfo, formatIndex);
            this.formatCache.put(formatInfo.getId(), formatIndex);
        }
        return formatIndex;
    }

    private void export(XlsxFormatInfo formatInfo, Integer formatIndex) {
        this.write("<numFmt numFmtId=\"" + (formatIndex + 1) + "\"");
        if (formatInfo.pattern != null && formatInfo.pattern.trim().length() > 0) {
            this.write(" formatCode=\"" + formatInfo.pattern + "\"");
        } else {
            this.write(" formatCode=\"General\"");
        }
        this.write("/>\n");
    }
}

