/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.filtertree.elements;

import javax.swing.ImageIcon;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.dimensiontree.elements.MemberElement;
import rex.graphics.filtertree.elements.FilterTreePopUpActions;
import rex.metadata.ServerMetadata;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;

public class FilterTreeMemberElement
extends MemberElement
implements LanguageChangedListener {
    private boolean nodeEnabled;
    static ImageIcon iconEnabled = S.getAppIcon("member_selected.gif");
    static ImageIcon iconDisabled = S.getAppIcon("member_not_selected.gif");

    public FilterTreeMemberElement(ServerMetadata svm, XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties, String _catalogName, String _cubeName, String _dimensionUniqueName, String _hierarchyUniqueName, String _levelUniqueName, int _levelNumber, String _memberName, String _memberUniqueName, String _memberCaption, int _memberType, int _memberOrdinal, int _childrenCardinality) {
        super(svm, _restrictions, _properties, _catalogName, _cubeName, _dimensionUniqueName, _hierarchyUniqueName, _levelUniqueName, _levelNumber, _memberName, _memberUniqueName, _memberCaption, _memberType, _memberOrdinal, _childrenCardinality);
        I18n.addOnLanguageChangedListener(this);
        this.nodeEnabled = true;
    }

    public DimensionTreeElement[] getChildren(boolean noMatterWhat) {
        if (this.getChildrenCount() > 0) {
            this.getRestrictions().setMemberUniqueName(this.getUniqueName());
            this.getRestrictions().setTreeOp(XMLADiscoverRestrictions.MD_TREEOP_CHILDREN);
            this.getRestrictions().setLevelUniqueName(null);
            return this.getServerMetadata().getFilterTreeMembersList(this.getRestrictions(), this.getProperties());
        }
        return null;
    }

    public ImageIcon getIcon() {
        if (this.isEnabled()) {
            return iconEnabled;
        }
        return iconDisabled;
    }

    public String[] getPopUpActionList() {
        if (this.isEnabled()) {
            return new String[]{FilterTreePopUpActions.DISABLE_THIS_ELEMENT, FilterTreePopUpActions.ENABLE_ONLY_THIS_ELEMENT, FilterTreePopUpActions.ENABLE_ALL_BUT_THIS_ELEMENT};
        }
        return new String[]{FilterTreePopUpActions.ENABLE_THIS_ELEMENT, FilterTreePopUpActions.ENABLE_ONLY_THIS_ELEMENT, FilterTreePopUpActions.ENABLE_ALL_BUT_THIS_ELEMENT};
    }

    public boolean isEnabled() {
        return this.nodeEnabled;
    }

    public void setEnabled(boolean newValue) {
        this.nodeEnabled = newValue;
    }

    public void languageChanged(LanguageChangedEvent evt) {
        FilterTreePopUpActions.popUpCaptions.put(FilterTreePopUpActions.ENABLE_ALL_BUT_THIS_ELEMENT, I18n.getString("menu.enableAllExceptThis"));
        FilterTreePopUpActions.popUpCaptions.put(FilterTreePopUpActions.ENABLE_ONLY_THIS_ELEMENT, I18n.getString("menu.enableJustThisElem"));
        FilterTreePopUpActions.popUpCaptions.put(FilterTreePopUpActions.ENABLE_THIS_ELEMENT, I18n.getString("menu.enableThisElem"));
        FilterTreePopUpActions.popUpCaptions.put(FilterTreePopUpActions.DISABLE_THIS_ELEMENT, I18n.getString("menu.disableElem"));
        FilterTreePopUpActions.popUpCaptions.put(FilterTreePopUpActions.LOSE_FILTER, I18n.getString("menu.loseFilter"));
        FilterTreePopUpActions.popUpCaptions.put(FilterTreePopUpActions.APPLY_FILTER, I18n.getString("menu.applyFilter"));
        FilterTreePopUpActions.popUpCaptions.put(FilterTreePopUpActions.MOVE_TO_TAB, I18n.getString("menu.moveToTab"));
        FilterTreePopUpActions.popUpCaptions.put(FilterTreePopUpActions.MOVE_TO_SPLIT_PANE, I18n.getString("menu.moveToSplitPane"));
    }
}

