/*
 * Decompiled with CFR 0.152.
 */
package rex.metadata;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;
import rex.exceptions.RexXMLADiscoverException;
import rex.exceptions.RexXMLAExecuteException;
import rex.graphics.datasourcetree.elements.CatalogElement;
import rex.graphics.datasourcetree.elements.CubeElement;
import rex.graphics.datasourcetree.elements.DataSourceElement;
import rex.graphics.datasourcetree.elements.DataSourceTreeElement;
import rex.graphics.dimensiontree.elements.DimensionElement;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.dimensiontree.elements.HierarchyElement;
import rex.graphics.dimensiontree.elements.LevelElement;
import rex.graphics.dimensiontree.elements.MeasureElement;
import rex.graphics.filtertree.elements.FilterTreeLevelElement;
import rex.metadata.SAXMemberHandler;
import rex.metadata.resultelements.Cell;
import rex.utils.I18n;
import rex.utils.S;
import rex.xmla.RexXMLAPort;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;
import rex.xmla.XMLAExecuteProperties;
import rex.xmla.XMLAObjectsFactory;
import rex.xmla.XMLAPort;

public class ServerMetadata {
    private URL endpoint;
    private Component panel;
    XMLAPort port;

    public ServerMetadata(String webServiceURL, Component panel) {
        try {
            this.panel = panel;
            this.endpoint = new URL(webServiceURL);
        }
        catch (Exception e) {
            S.out("Cannot instantiate ServerMetaData!");
            S.out("Error:" + e);
        }
    }

    public ServerMetadata(String webServiceURL) {
        this(webServiceURL, null);
    }

    public boolean isHTTPS() {
        return this.endpoint != null && this.endpoint.getProtocol().equals("https");
    }

    private void init() {
        if (this.port == null) {
            try {
                this.port = new RexXMLAPort(this.endpoint);
            }
            catch (Exception e) {
                S.out("Error while initializing service & call...");
                S.out("Error:" + e);
            }
        }
    }

    private boolean errorOccured(Document resultDOM) {
        NodeList errList = resultDOM.getElementsByTagName("Error");
        if (errList != null && errList.getLength() > 0) {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < errList.getLength(); ++i) {
                sb.append("\nError occured!");
                NamedNodeMap attrs = errList.item(i).getAttributes();
                for (int j = 0; j < attrs.getLength(); ++j) {
                    sb.append("\n  " + attrs.item(j).getNodeName() + " = " + attrs.item(j).getNodeValue());
                }
            }
            JOptionPane.showMessageDialog(this.panel, I18n.getString("msgText.discoverCall") + sb.toString(), I18n.getString("msgTitle.discoverCall"), 0);
            return true;
        }
        return false;
    }

    public boolean isValidUrl() {
        return this.endpoint != null;
    }

    public DataSourceTreeElement[] discoverDataSources() {
        DataSourceElement[] retVal = null;
        if (this.endpoint == null) {
            return retVal;
        }
        this.init();
        XMLADiscoverRestrictions r = XMLAObjectsFactory.newXMLADiscoverRestrictions();
        XMLADiscoverProperties p = XMLAObjectsFactory.newXMLADiscoverProperties();
        try {
            Document result = this.port.discoverDataSources(r, p);
            if (this.errorOccured(result)) {
                return null;
            }
            NodeList nl = result.getElementsByTagName("row");
            if (nl != null && nl.getLength() > 0) {
                retVal = new DataSourceElement[nl.getLength()];
                for (int i = 0; i < nl.getLength(); ++i) {
                    retVal[i] = new DataSourceElement(this, nl.item(i));
                }
            }
        }
        catch (Exception e) {
            S.out("Error(discoverDataSources):" + e);
            S.reportError(this.panel, e);
            e.printStackTrace();
            return null;
        }
        return retVal;
    }

    public DataSourceTreeElement[] getCatalogList(XMLADiscoverRestrictions restrictions, XMLADiscoverProperties properties) {
        CatalogElement[] retVal = null;
        if (this.endpoint == null) {
            return retVal;
        }
        this.init();
        try {
            Document result = this.port.getCatalogList(restrictions, properties);
            if (this.errorOccured(result)) {
                return null;
            }
            NodeList nl = result.getElementsByTagName("row");
            if (nl != null && nl.getLength() > 0) {
                retVal = new CatalogElement[nl.getLength()];
                for (int i = 0; i < nl.getLength(); ++i) {
                    retVal[i] = new CatalogElement(this, nl.item(i), properties.getDataSourceInfo());
                }
            }
        }
        catch (Exception e) {
            S.out("Error(getCatalogList):" + e);
            return null;
        }
        return retVal;
    }

    public DataSourceTreeElement[] getCubeList(XMLADiscoverRestrictions restrictions, XMLADiscoverProperties properties) {
        DataSourceTreeElement[] retVal = null;
        if (this.endpoint == null) {
            return retVal;
        }
        this.init();
        try {
            Document result = this.port.getCubeList(restrictions, properties);
            if (this.errorOccured(result)) {
                return null;
            }
            NodeList nl = result.getElementsByTagName("row");
            if (nl != null && nl.getLength() > 0) {
                retVal = new DataSourceTreeElement[nl.getLength()];
                for (int i = 0; i < nl.getLength(); ++i) {
                    retVal[i] = new CubeElement(this, nl.item(i), properties.getDataSourceInfo());
                }
            }
        }
        catch (Exception e) {
            S.out("Error(getCubeList):" + e);
            return null;
        }
        return retVal;
    }

    public DimensionTreeElement[] getDimensionList(XMLADiscoverRestrictions restrictions, XMLADiscoverProperties properties) {
        DimensionTreeElement[] retVal = null;
        if (this.endpoint == null) {
            return retVal;
        }
        this.init();
        try {
            Document result = this.port.getDimensionList(restrictions, properties);
            if (this.errorOccured(result)) {
                return null;
            }
            NodeList nl = result.getElementsByTagName("row");
            if (nl != null && nl.getLength() > 0) {
                retVal = new DimensionTreeElement[nl.getLength()];
                for (int i = 0; i < nl.getLength(); ++i) {
                    retVal[i] = new DimensionElement(this, nl.item(i), restrictions, properties);
                }
            }
        }
        catch (Exception e) {
            S.out("Error(getDimensionList):" + e + " (" + e.getMessage() + ")");
            return null;
        }
        return retVal;
    }

    public DimensionTreeElement[] getHierarchyList(XMLADiscoverRestrictions restrictions, XMLADiscoverProperties properties) {
        DimensionTreeElement[] retVal = null;
        if (this.endpoint == null) {
            return retVal;
        }
        this.init();
        try {
            Document result = this.port.getHierarchyList(restrictions, properties);
            if (this.errorOccured(result)) {
                return null;
            }
            NodeList nl = result.getElementsByTagName("row");
            if (nl != null && nl.getLength() > 0) {
                retVal = new DimensionTreeElement[nl.getLength()];
                for (int i = 0; i < nl.getLength(); ++i) {
                    retVal[i] = new HierarchyElement(this, nl.item(i), restrictions, properties);
                }
            }
        }
        catch (Exception e) {
            S.out("Error(getHierarchyList):" + e);
            return null;
        }
        return retVal;
    }

    public DimensionTreeElement[] getLevelList(XMLADiscoverRestrictions restrictions, XMLADiscoverProperties properties) {
        DimensionTreeElement[] retVal = null;
        if (this.endpoint == null) {
            return retVal;
        }
        this.init();
        try {
            Document result = this.port.getLevelList(restrictions, properties);
            if (this.errorOccured(result)) {
                return null;
            }
            NodeList nl = result.getElementsByTagName("row");
            if (nl != null && nl.getLength() > 0) {
                retVal = new DimensionTreeElement[nl.getLength()];
                for (int i = 0; i < nl.getLength(); ++i) {
                    retVal[i] = new LevelElement(this, nl.item(i), restrictions, properties);
                }
            }
        }
        catch (Exception e) {
            S.out("Error(getLevelList):" + e);
            return null;
        }
        return retVal;
    }

    public DimensionTreeElement[] getFilterLevelList(XMLADiscoverRestrictions restrictions, XMLADiscoverProperties properties) {
        DimensionTreeElement[] retVal = null;
        if (this.endpoint == null) {
            return retVal;
        }
        this.init();
        try {
            Document result = this.port.getLevelList(restrictions, properties);
            if (this.errorOccured(result)) {
                return null;
            }
            NodeList nl = result.getElementsByTagName("row");
            if (nl != null && nl.getLength() > 0) {
                retVal = new DimensionTreeElement[nl.getLength()];
                for (int i = 0; i < nl.getLength(); ++i) {
                    retVal[i] = new FilterTreeLevelElement(this, nl.item(i), restrictions, properties);
                }
            }
        }
        catch (Exception e) {
            S.out("Error(getFilterLevelList):" + e);
            e.printStackTrace();
            return null;
        }
        return retVal;
    }

    public DimensionTreeElement[] getMeasuresList(XMLADiscoverRestrictions restrictions, XMLADiscoverProperties properties) {
        DimensionTreeElement[] retVal = null;
        if (this.endpoint == null) {
            return retVal;
        }
        this.init();
        try {
            Document result = this.port.getMeasureList(restrictions, properties);
            if (this.errorOccured(result)) {
                return null;
            }
            NodeList nl = result.getElementsByTagName("row");
            if (nl != null && nl.getLength() > 0) {
                retVal = new DimensionTreeElement[nl.getLength()];
                for (int i = 0; i < nl.getLength(); ++i) {
                    retVal[i] = new MeasureElement(this, nl.item(i), restrictions, properties);
                }
            }
        }
        catch (Exception e) {
            S.out("Error(getMeasuresList):" + e);
            return null;
        }
        return retVal;
    }

    public DimensionTreeElement[] getDimensionTreeMembersList(XMLADiscoverRestrictions restrictions, XMLADiscoverProperties properties) {
        return this.getMembersList(restrictions, properties, false);
    }

    public DimensionTreeElement[] getFilterTreeMembersList(XMLADiscoverRestrictions restrictions, XMLADiscoverProperties properties) {
        return this.getMembersList(restrictions, properties, true);
    }

    private DimensionTreeElement[] getMembersList(XMLADiscoverRestrictions restrictions, XMLADiscoverProperties properties, boolean spawnFilterTreeMemberElement) {
        DimensionTreeElement[] retVal = null;
        if (this.endpoint == null) {
            return retVal;
        }
        this.init();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXMemberHandler handler = new SAXMemberHandler(this, restrictions, properties, spawnFilterTreeMemberElement);
            try {
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(this.port.getMemberListAsStream(restrictions, properties), (DefaultHandler)handler);
                retVal = handler.getMembers();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        catch (Exception e) {
            S.out("Error(getMembersList2):" + e);
            return null;
        }
        return retVal;
    }

    public Document execute(String mdx, XMLAExecuteProperties properties) throws IOException {
        if (this.endpoint == null) {
            return null;
        }
        this.init();
        try {
            return this.port.execute(mdx, properties);
        }
        catch (IOException e) {
            S.out("Error executing MDX:" + mdx + "\ne.getMessage() = " + e.getMessage() + "\nStackTrace:");
            e.printStackTrace();
            throw e;
        }
        catch (RexXMLADiscoverException e) {
            throw new IOException(e.getError());
        }
        catch (RexXMLAExecuteException e) {
            throw new IOException(e.getError());
        }
    }

    public static void main(String[] args) {
        ServerMetadata svm = new ServerMetadata("http://localhost:8080/mondrian/xmla");
        XMLAExecuteProperties execPropFoodMart = XMLAObjectsFactory.newXMLAExecuteProperties();
        execPropFoodMart.setDataSourceInfo("FoodMartSource");
        execPropFoodMart.setCatalog("FoodMart");
        String mdxQuerySales = "SELECT NON EMPT {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY {[Time].[1997]} ON ROWS FROM [Sales]";
        try {
            System.out.println(new Cell(svm.execute(mdxQuerySales, execPropFoodMart).getElementsByTagName("CellData").item(0).getChildNodes().item(1)).getCellValue());
        }
        catch (IOException io) {
            System.out.println(io.toString());
        }
    }
}

