/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlDialect
extends JdbcDialectImpl {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(MySqlDialect.class, Dialect.DatabaseProduct.MYSQL){

        protected boolean acceptsConnection(Connection connection) {
            try {
                return super.acceptsConnection(connection) && !MySqlDialect.isInfobright(connection.getMetaData());
            }
            catch (SQLException e) {
                throw Util.newError(e, "Error while instantiating dialect");
            }
        }
    };

    public MySqlDialect(Connection connection) throws SQLException {
        super(connection);
    }

    public static boolean isInfobright(DatabaseMetaData databaseMetaData) {
        Statement statement = null;
        try {
            ResultSet resultSet;
            String productVersion = databaseMetaData.getDatabaseProductVersion();
            if (productVersion.compareTo("5.1") >= 0 && (resultSet = (statement = databaseMetaData.getConnection().createStatement()).executeQuery("select * from INFORMATION_SCHEMA.engines where ENGINE = 'BRIGHTHOUSE'")).next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "while running query to detect Brighthouse engine");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    protected String deduceProductName(DatabaseMetaData databaseMetaData) {
        String productName = super.deduceProductName(databaseMetaData);
        if (MySqlDialect.isInfobright(databaseMetaData)) {
            return "MySQL (Infobright)";
        }
        return productName;
    }

    @Override
    protected String deduceIdentifierQuoteString(DatabaseMetaData databaseMetaData) {
        String quoteIdentifierString = super.deduceIdentifierQuoteString(databaseMetaData);
        if (quoteIdentifierString == null) {
            quoteIdentifierString = "`";
        }
        return quoteIdentifierString;
    }

    @Override
    public boolean requiresAliasForFromQuery() {
        return true;
    }

    @Override
    public boolean allowsFromQuery() {
        return this.productVersion.compareTo("4.") >= 0;
    }

    @Override
    public boolean allowsCompoundCountDistinct() {
        return true;
    }

    @Override
    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return this.generateInlineGeneric(columnNames, columnTypes, valueList, null, false);
    }

    @Override
    public Dialect.NullCollation getNullCollation() {
        return Dialect.NullCollation.NEGINF;
    }

    @Override
    public String generateOrderItem(String expr, boolean nullable, boolean ascending) {
        if (nullable) {
            assert (this.getNullCollation() == Dialect.NullCollation.NEGINF);
            if (ascending) {
                return "ISNULL(" + expr + "), " + expr;
            }
            return expr + " DESC";
        }
        if (ascending) {
            return expr + " ASC";
        }
        return expr + " DESC";
    }

    @Override
    public boolean requiresOrderByAlias() {
        return true;
    }

    @Override
    public boolean supportsMultiValueInExpr() {
        return true;
    }
}

