/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;
import mondrian.util.Format;

public class I18nTest
extends FoodMartTestCase {
    public static final char Euro = '\u20ac';
    public static final char Nbsp = '\u00a0';
    public static final char EA = '\u00e9';
    public static final char UC = '\u00fb';

    public void testFormat() {
        Util.discard((Object)Util.nl);
        Locale spanish = new Locale("es", "ES");
        Locale german = new Locale("de", "DE");
        Format numFormat = new Format("#,000.00", spanish);
        I18nTest.assertEquals((String)"123.456,79", (String)numFormat.format(new Double(123456.789)));
        Format currencyFormat = new Format("Currency", spanish);
        I18nTest.assertEquals((String)"1.234.567,79 \u20ac", (String)currencyFormat.format(new Double(1234567.789)));
        Format dateFormat = new Format("Medium Date", spanish);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2005);
        calendar.set(2, 0);
        calendar.set(5, 22);
        Date date = calendar.getTime();
        I18nTest.assertEquals((String)"22-ene-05", (String)dateFormat.format(date));
        dateFormat = new Format("Long Date", german);
        I18nTest.assertEquals((String)"Samstag, Januar 22, 2005", (String)dateFormat.format(date));
    }

    public void testAutoFrench() {
        String localeName = "fr_FR";
        String resultString = "12\u00a0345,67";
        this.assertFormatNumber(localeName, resultString);
    }

    public void testAutoSpanish() {
        this.assertFormatNumber("es", "12.345,67");
    }

    public void testAutoMexican() {
        this.assertFormatNumber("es_MX", "12,345.67");
    }

    private void assertFormatNumber(String localeName, String resultString) {
        Util.PropertyList properties = TestContext.instance().getFoodMartConnectionProperties();
        properties.put(RolapConnectionProperties.Locale.name(), localeName);
        Connection connection = DriverManager.getConnection(properties, null);
        Query query = connection.parseQuery("WITH MEMBER [Measures].[Foo] AS ' 12345.67 ',\n FORMAT_STRING='#,###.00'\nSELECT {[Measures].[Foo]} ON COLUMNS\nFROM [Sales]");
        Result result = connection.execute(query);
        String actual = TestContext.toString(result);
        I18nTest.assertEquals((String)I18nTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: " + resultString + "\n"), (String)actual);
    }
}

